/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.mainpanel;

import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.MyJMenu;
import ciss.phase_viewer.common.MyJMenuItem;
import ciss.phase_viewer.common.MyThread;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.graph.dataset.DataSetManipulator;
import ciss.phase_viewer.imageviewer.ImageLoader;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.main.Main;
import ciss.phase_viewer.mainpanel.Chase;
import ciss.phase_viewer.mainpanel.ChaseGUI;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.mainpanel.DirBrowserMenu;
import ciss.phase_viewer.mainpanel.LookandFeel;
import ciss.phase_viewer.mainpanel.ProcessMenu;
import ciss.phase_viewer.mainpanel.WindowMenu;
import ciss.phase_viewer.pkg.ActivationPanel;
import ciss.phase_viewer.process.ProcessViewer;
import ciss.phase_viewer.projectbrowser.Restorer;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.scripting.BshConsole;
import ciss.phase_viewer.settings.ExternalProgramSelector;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.ssh.hosts.HostConfigurator;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;
import ciss.phase_viewer.ssh.sftp.SftpClient;
import ciss.phase_viewer.ssh.terminal.Terminal;
import ciss.phase_viewer.textviewer.HelpViewer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class ChaseJMenuItems {
    private Logger logger = Logger.getLogger(ChaseJMenuItems.class.getName());
    private Vector menuItems = new Vector();
    private GlobalProperties propChase = PropertiesManager.getGlobalProperties(0);
    private final String FS = System.getProperty("file.separator");
    private final String PS = System.getProperty("path.separator");
    private final String CR = System.getProperty("line.separator");
    private ProjectDirBrowser dirBrowser;

    public ChaseJMenuItems() {
        this.createMenu();
    }

    public JMenuItem[] getMenuItems() {
        JMenuItem[] items = new JMenuItem[this.menuItems.size()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = (JMenuItem)this.menuItems.get(i);
        }
        return items;
    }

    private void fileMenu() {
        ProjectDirBrowser dirBrowser = ChaseGUI.getProjectDirBrowser();
        DirBrowserMenu dirMenu = new DirBrowserMenu("Project", 80, dirBrowser);
        this.menuItems.add(dirMenu);
    }

    private void createMenu() {
        MyJMenu modulemenu;
        LookandFeel l_and_f = new LookandFeel();
        this.fileMenu();
        MyJMenu networkmenu = modulemenu = new MyJMenu("Module", 77);
        MyJMenuItem sshterminal = new MyJMenuItem("ssh terminal", 84);
        networkmenu.add(sshterminal);
        sshterminal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Terminal term = new Terminal();
                term.setVisible(true);
            }
        });
        MyJMenuItem sftpclient = new MyJMenuItem("sftp client", 70);
        networkmenu.add(sftpclient);
        sftpclient.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClient sftp = new SftpClient();
            }
        });
        MyJMenuItem networkconfig = new MyJMenuItem("configure host info", 67);
        networkmenu.add(networkconfig);
        networkconfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator configurator = new HostConfigurator();
            }
        });
        modulemenu.addSeparator();
        this.menuItems.add(modulemenu);
        MyJMenu chasemenu = modulemenu;
        MyJMenuItem macv = new MyJMenuItem("atomic configuration viewer", 65);
        macv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseJMenuItems.this.bootACViewer();
            }
        });
        chasemenu.add(macv);
        MyJMenuItem mgraph = new MyJMenuItem("graph tool", 71);
        mgraph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseJMenuItems.this.bootGraphTool();
            }
        });
        chasemenu.add(mgraph);
        MyJMenuItem mimageView = new MyJMenuItem("image viewer", 73);
        mimageView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseJMenuItems.this.bootImageLoader();
            }
        });
        chasemenu.add(mimageView);
        MyJMenu toolmenu = new MyJMenu("External tools", 69);
        MyJMenuItem mexeeditor = new MyJMenuItem("Editor", 68);
        mexeeditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseJMenuItems.this.bootEditor();
            }
        });
        toolmenu.add(mexeeditor);
        toolmenu.addSeparator();
        MyJMenuItem mshell = new MyJMenuItem("shell", 83);
        toolmenu.add(mshell);
        mshell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseJMenuItems.this.bootProcessFrame();
            }
        });
        MyJMenu processmenu = new MyJMenu("Process", 82);
        MyJMenuItem mprocessViewer = new MyJMenuItem("Process Viewer", 86);
        mprocessViewer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseJMenuItems.this.bootProcessViewer();
            }
        });
        processmenu.add(mprocessViewer);
        ProcessMenu process = new ProcessMenu("Process", 82);
        this.menuItems.add(process);
        MyJMenu prefs = new MyJMenu("Preferences", 70);
        MyJMenuItem msetappl = new MyJMenuItem("program paths", 80);
        msetappl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExternalProgramSelector foo = new ExternalProgramSelector();
            }
        });
        prefs.add(msetappl);
        WindowMenu window = new WindowMenu("Window(s)", 87);
        this.menuItems.add(window);
        prefs.add(l_and_f);
        this.menuItems.add(prefs);
        MyJMenuItem restoreDefault = new MyJMenuItem("restore default settings", 82);
        restoreDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ChaseJMenuItems.this.logger.info("restoring default settings...");
                String chaseini = System.getProperty("user.home") + System.getProperty("file.separator") + ".phase-viewer";
                if (new File(chaseini).exists()) {
                    try {
                        ChaseJMenuItems.this.logger.info("your original .phase-viewer direrectory will be backed up to : " + chaseini + "_bak");
                        new File(chaseini + "_bak").mkdir();
                        Utils.copyDir(new File(chaseini), new File(chaseini + "_bak"));
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
                Chase.generateDefaultDotChaseDir(true);
            }
        });
        prefs.addSeparator();
        prefs.add(restoreDefault);
        this.menuItems.add(null);
        MyJMenu helpmenu = new MyJMenu("Help", 72);
        MyJMenuItem mversion = new MyJMenuItem("Version", 86);
        mversion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseJMenuItems.this.bootVersionDialog();
            }
        });
        helpmenu.add(mversion);
        MyJMenuItem mmanual = new MyJMenuItem("Online manual", 77);
        mmanual.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        mmanual.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpViewer browser = new HelpViewer();
            }
        });
        helpmenu.add(mmanual);
        MyJMenuItem mrestore = new MyJMenuItem("restore broken projects", 82);
        mrestore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ChaseFileChooser cfc = new ChaseFileChooser();
                cfc.setFileSelectionMode(1);
                if (cfc.showOpenDialog(Desk.getDesktop()) != 0) {
                    ChaseJMenuItems.this.logger.info("operation canceled.");
                    return;
                }
                File tmpFile = null;
                try {
                    tmpFile = File.createTempFile("tmp", "xml");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ChaseJMenuItems.this.logger.error("Failed to create a temp file; RESTORE FAILED!!");
                    return;
                }
                if (!Restorer.restore(cfc.getSelectedFile(), tmpFile)) {
                    ChaseJMenuItems.this.logger.error("RESTORE FAILED!!");
                    return;
                }
                HostInfo info = HostList.getHostList().getHostInfo("localhost");
                info.setProperty("basedir", cfc.getSelectedFile().getAbsolutePath());
                HostList.getHostList().save();
                String myprojFile = System.getProperty("user.home") + System.getProperty("file.separator") + ".phase-viewer" + System.getProperty("file.separator") + "my_projects.xml";
                try {
                    ExternalProgramExecuter.copyBinary(tmpFile.getAbsolutePath(), myprojFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ChaseJMenuItems.this.logger.error("failed to recreate file : " + myprojFile);
                    ChaseJMenuItems.this.logger.error("RESTORE FAILED!!");
                    return;
                }
                Main.getRootFrame().dispose();
                System.exit(0);
            }
        });
        helpmenu.addSeparator();
        helpmenu.add(mrestore);
        this.menuItems.add(helpmenu);
    }

    private void bootProcessViewer() {
        if (!ConstParameters.osName.toLowerCase().trim().startsWith("windows")) {
            ProcessViewer psv = new ProcessViewer();
            psv.start();
            psv.setVisible(true);
        } else {
            String taskmgr = this.propChase.getProperty("taskmgr");
            MyThread myThread = new MyThread(taskmgr);
        }
    }

    private void bootActivationPanel() {
        ActivationPanel ap = new ActivationPanel();
        ap.display();
    }

    private void bootVersionDialog() {
        Document doc = Main.getDefaultPropertiesDocument();
        Element elem = doc.getRootElement().getChild("version_dialog");
        String title = MyElement.decode(elem.getChildTextTrim("title").trim());
        String message = elem.getChildTextTrim("message");
        URL advancelogo = this.getClass().getResource(MyElement.decode(elem.getChildTextTrim("imagefilepath")));
        ImageIcon icon = null;
        if (advancelogo != null) {
            icon = new ImageIcon(advancelogo);
        }
        JOptionPane.showInternalMessageDialog(Desk.getDesktop(), message, title, -1, icon);
    }

    private void bootEditor() {
        String editorPath = this.propChase.getProperty("editor");
        MyThread th = new MyThread(Utils.getPathDQ(this.propChase.getProperty("editor")));
    }

    private void bootBSV() {
        String BSVbooter = Utils.getPathDQ(ConstParameters.getJavaPath()) + " -jar ";
        BSVbooter = BSVbooter + Utils.getPathDQ(System.getProperty("pviewer.home") + this.FS + this.propChase.getProperty("BioStationViewer"));
        MyThread th = new MyThread(BSVbooter);
    }

    private void bootACViewer() {
        MainPanel panel = new MainPanel();
        try {
            panel.display3D();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void bootGraphTool() {
        DataSetManipulator manip = new DataSetManipulator();
    }

    private void bootImageLoader() {
        ImageLoader imageLoader = new ImageLoader(System.getProperty("user.home"));
        imageLoader.display();
    }

    private void bootProcessFrame() {
        BshConsole console = new BshConsole();
    }
}

