/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.io.Importer;
import ciss.phase_viewer.atomcoord.io.PhaseInputFileFilter;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceUnits;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class PhaseInputImporter
implements Importer {
    private Logger logger = Logger.getLogger(PhaseInputImporter.class.getName());

    public boolean isImportable(String fileName) {
        return !new File(fileName).isDirectory();
    }

    public AtomCoords[] getAtomCoordsFrom(String fileName) {
        AtomCoords coords = new AtomCoords();
        DataManager manager = new DataManager(fileName);
        if (!manager.parse()) {
            return null;
        }
        InputInterface inputFrom = manager.getInputInterface();
        String coordsys = inputFrom.getInputInterfacePrimitiveEntry("structure.atom_list.coordinate_system").getValue();
        inputFrom.selectBlock("structure.unit_cell");
        InputInterfaceUnits units = inputFrom.getUnits();
        int lenunit = 1;
        String[] uni = units.getUnits();
        String lenu = "bohr";
        if (uni != null) {
            for (int i = 0; i < uni.length; ++i) {
                if (uni[i].toLowerCase().equals("angstrom")) {
                    lenunit = 2;
                    lenu = "angstrom";
                    continue;
                }
                if (!uni[i].toLowerCase().equals("nm")) continue;
                lenunit = 3;
                lenu = "nm";
            }
        }
        InputInterfacePrimitiveEntry[] cellentries = inputFrom.getAllPrimitiveEntries();
        boolean validCell = true;
        double[][] cellVector = null;
        double[] cellabc = null;
        HashMap<String, String> hashcell = null;
        if (cellentries == null) {
            validCell = false;
        } else {
            hashcell = new HashMap<String, String>();
            for (int i = 0; i < cellentries.length; ++i) {
                hashcell.put(cellentries[i].getName(), cellentries[i].getValue());
            }
        }
        if (hashcell.get("a_vector") != null && hashcell.get("b_vector") != null && hashcell.get("c_vector") != null) {
            cellVector = new double[3][3];
            try {
                String[] stravec = hashcell.get("a_vector").toString().split("\\s+");
                String[] strbvec = hashcell.get("b_vector").toString().split("\\s+");
                String[] strcvec = hashcell.get("c_vector").toString().split("\\s+");
                for (int i = 0; i < 3; ++i) {
                    cellVector[0][i] = Double.parseDouble(stravec[i]);
                    cellVector[1][i] = Double.parseDouble(strbvec[i]);
                    cellVector[2][i] = Double.parseDouble(strcvec[i]);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                cellVector = null;
            }
            catch (ArrayIndexOutOfBoundsException aobe) {
                aobe.printStackTrace();
                cellVector = null;
            }
        } else if (hashcell.get("a") != null && hashcell.get("b") != null && hashcell.get("c") != null && hashcell.get("alpha") != null && hashcell.get("beta") != null && hashcell.get("gamma") != null) {
            cellabc = new double[6];
            try {
                cellabc[0] = Double.parseDouble(hashcell.get("a").toString());
                cellabc[1] = Double.parseDouble(hashcell.get("b").toString());
                cellabc[2] = Double.parseDouble(hashcell.get("c").toString());
                cellabc[3] = Double.parseDouble(hashcell.get("alpha").toString());
                cellabc[4] = Double.parseDouble(hashcell.get("beta").toString());
                cellabc[5] = Double.parseDouble(hashcell.get("gamma").toString());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                cellabc = null;
            }
        }
        if (cellVector == null && cellabc == null) {
            validCell = false;
        } else if (cellVector != null) {
            validCell = true;
            Cell ce = new Cell(cellVector[0], cellVector[1], cellVector[2]);
            coords.setCell(ce);
        } else if (cellabc != null) {
            validCell = true;
            Cell ce = new Cell((double)cellabc[0], (double)cellabc[1], (double)cellabc[2], (double)cellabc[3], cellabc[4], cellabc[5]);
            coords.setCell(ce);
        }
        boolean iscart = coordsys.equalsIgnoreCase("cartesian");
        coords.isCart(iscart);
        this.logger.debug("is cart? " + iscart);
        inputFrom.selectBlock("structure.atom_list.atoms");
        InputInterfaceUnits unitAtom = inputFrom.getUnits();
        boolean lenunitAtom = true;
        String[] uniAtom = units.getUnits();
        if (uniAtom != null) {
            for (int i = 0; i < uniAtom.length; ++i) {
                if (uniAtom[i].toLowerCase().equals("angstrom")) {
                    lenunit = 2;
                    lenu = "angstrom";
                    continue;
                }
                if (!uniAtom[i].toLowerCase().equals("nm")) continue;
                lenunit = 3;
                lenu = "nm";
            }
        }
        coords.setUnit(lenunit);
        this.logger.debug("length unit: " + lenu);
        coords.inputInterface2AtomCoords(inputFrom, "structure.atom_list.atoms");
        coords.convert(6, 8);
        if (coords.getNumAt() != 0) {
            return new AtomCoords[]{coords};
        }
        return null;
    }

    public void setOptions(HashMap options) {
    }

    public void createOptionsPanel(boolean heavy, PropertyChangeListener listener, String fileName) {
    }

    public boolean hasOptions() {
        return false;
    }

    public String getType() {
        return "phase input file";
    }

    public FileFilter getFileFilter() {
        return new PhaseInputFileFilter();
    }
}

