/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.io.AtomCoordsIO;
import ciss.phase_viewer.atomcoord.io.Importable;
import ciss.phase_viewer.atomcoord.io.Importer;
import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.main.PluginLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

class ImporterGUIPanel
extends JPanel {
    private Logger logger = Logger.getLogger(ImporterGUIPanel.class.getName());
    private Importable caller;
    private Importer[] importers;
    private JInternalFrame frame;
    private JFrame jframe;
    private JComboBox comboType;
    private JTextField pathTF;
    private JButton bootChooser;
    private JButton btnopt;

    ImporterGUIPanel(Importable caller, JInternalFrame frame) {
        this.caller = caller;
        this.frame = frame;
        this.init();
    }

    ImporterGUIPanel(Importable caller, JFrame jframe) {
        this.caller = caller;
        this.jframe = jframe;
        this.init();
    }

    private void init() {
        this.createImporters();
        String[] types = new String[this.importers.length];
        for (int i = 0; i < this.importers.length; ++i) {
            types[i] = this.importers[i].getType();
        }
        this.comboType = new JComboBox<String>(types);
        this.pathTF = new JTextField(20);
        this.bootChooser = new JButton("choose...");
        JPanel panel1 = new JPanel();
        JPanel pcomboType = new JPanel();
        pcomboType.setBorder(new TitledBorder("file type"));
        pcomboType.add(this.comboType);
        JPanel pchooser = new JPanel();
        this.btnopt = new JButton("options");
        pchooser.setLayout(new BoxLayout(pchooser, 0));
        pchooser.add(this.pathTF);
        pchooser.add(this.bootChooser);
        pchooser.add(this.btnopt);
        panel1.add(pcomboType);
        panel1.add(pchooser);
        JPanel pbtns = new JPanel();
        pbtns.setLayout(new BoxLayout(pbtns, 0));
        JButton importbtn = new JButton("import selected");
        JButton btncancel = new JButton("cancel");
        pbtns.add(importbtn);
        pbtns.add(btncancel);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(panel1);
        panel.add(pbtns);
        this.comboType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ImporterGUIPanel.this.importers[ImporterGUIPanel.this.comboType.getSelectedIndex()].hasOptions()) {
                    ImporterGUIPanel.this.btnopt.setEnabled(true);
                } else {
                    ImporterGUIPanel.this.btnopt.setEnabled(false);
                }
            }
        });
        this.bootChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImporterGUIPanel.this.chooser();
            }
        });
        importbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String file = ImporterGUIPanel.this.pathTF.getText();
                if (file == null || file.length() == 0 || !new File(file).exists()) {
                    ImporterGUIPanel.this.logger.error("the file you've specified does not exist.");
                    return;
                }
                ImporterGUIPanel.this.caller.coordsImported(ImporterGUIPanel.this.importers[ImporterGUIPanel.this.comboType.getSelectedIndex()].getAtomCoordsFrom(file), ImporterGUIPanel.this.comboType.getSelectedItem().toString(), file);
                if (ImporterGUIPanel.this.frame != null) {
                    ImporterGUIPanel.this.frame.dispose();
                } else if (ImporterGUIPanel.this.jframe != null) {
                    ImporterGUIPanel.this.jframe.dispose();
                }
            }
        });
        this.btnopt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean isHeavy = true;
                if (ImporterGUIPanel.this.frame != null) {
                    isHeavy = false;
                }
                ImporterGUIPanel.this.importers[ImporterGUIPanel.this.comboType.getSelectedIndex()].createOptionsPanel(isHeavy, null, "");
            }
        });
        btncancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ImporterGUIPanel.this.frame != null) {
                    ImporterGUIPanel.this.frame.dispose();
                } else if (ImporterGUIPanel.this.jframe != null) {
                    ImporterGUIPanel.this.jframe.dispose();
                }
            }
        });
        this.add(panel);
        this.comboType.setSelectedIndex(0);
    }

    private void createImporters() {
        int i;
        Document doc = XMLUtils.getDocumentFromURL(AtomCoordsIO.SUPPORTED_FILETYPE);
        Element root = doc.getRootElement();
        List list = root.getChildren("importer");
        Vector<String> vec = new Vector<String>();
        for (i = 0; i < list.size(); ++i) {
            String loadClass = ((Element)list.get(i)).getChildTextTrim("loadclass");
            vec.addElement(loadClass);
        }
        this.importers = new Importer[vec.size()];
        for (i = 0; i < vec.size(); ++i) {
            String load = (String)vec.get(i);
            this.importers[i] = (Importer)PluginLoader.instantiate(load, null);
        }
    }

    private void chooser() {
        ChaseFileChooser fdlg = new ChaseFileChooser("atom", true);
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("select atomic configuration file");
        fdlg.setFileSelectionMode(0);
        FileFilter filter = this.importers[this.comboType.getSelectedIndex()].getFileFilter();
        if (filter != null) {
            fdlg.addChoosableFileFilter(filter);
        }
        if (fdlg.showOpenDialog(this) != 0) {
            return;
        }
        this.pathTF.setText(fdlg.getSelectedFile().getAbsolutePath());
    }

    class doImport
    implements Runnable {
        doImport() {
        }

        public void run() {
            String file = ImporterGUIPanel.this.pathTF.getText();
            if (file == null || file.length() == 0 || !new File(file).exists()) {
                ImporterGUIPanel.this.logger.error("the file you've specified does not exist.");
                return;
            }
            ImporterGUIPanel.this.caller.coordsImported(ImporterGUIPanel.this.importers[ImporterGUIPanel.this.comboType.getSelectedIndex()].getAtomCoordsFrom(file), ImporterGUIPanel.this.comboType.getSelectedItem().toString(), file);
        }
    }
}

