/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import org.jfree.data.AbstractDataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetChangeListener;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.XYDataset;

public class XYBarDataset
extends AbstractDataset
implements IntervalXYDataset,
DatasetChangeListener {
    private XYDataset underlying;
    private double barWidth;

    public XYBarDataset(XYDataset underlying, double barWidth) {
        this.underlying = underlying;
        this.underlying.addChangeListener(this);
        this.barWidth = barWidth;
    }

    public int getSeriesCount() {
        return this.underlying.getSeriesCount();
    }

    public String getSeriesName(int series) {
        return this.underlying.getSeriesName(series);
    }

    public int getItemCount(int series) {
        return this.underlying.getItemCount(series);
    }

    public Number getXValue(int series, int item) {
        return this.underlying.getXValue(series, item);
    }

    public Number getYValue(int series, int item) {
        return this.underlying.getYValue(series, item);
    }

    public Number getStartXValue(int series, int item) {
        Double result = null;
        Number xnum = this.underlying.getXValue(series, item);
        if (xnum != null) {
            result = new Double(xnum.doubleValue() - this.barWidth / 2.0);
        }
        return result;
    }

    public Number getEndXValue(int series, int item) {
        Double result = null;
        Number xnum = this.underlying.getXValue(series, item);
        if (xnum != null) {
            result = new Double(xnum.doubleValue() + this.barWidth / 2.0);
        }
        return result;
    }

    public Number getStartYValue(int series, int item) {
        return this.underlying.getYValue(series, item);
    }

    public Number getEndYValue(int series, int item) {
        return this.underlying.getYValue(series, item);
    }

    public void datasetChanged(DatasetChangeEvent event) {
        this.notifyListeners(event);
    }
}

