/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import jp.advancesoft.chase.mainpanel.Desktop;
import jp.advancesoft.chase.ssh.KnownHosts;
import jp.advancesoft.chase.ssh.hosts.HostInfo;
import jp.advancesoft.chase.ssh.hosts.MyUserInfo;
import org.apache.log4j.Logger;

public class SessionCreator {
    private static Logger logger = Logger.getLogger(SessionCreator.class.getName());

    private SessionCreator() {
    }

    public static Session getSession(HostInfo info) throws JSchException {
        logger.debug("creating session: ");
        String user = info.getProperty("username");
        String address = info.getProperty("address");
        if (user == null || user.length() == 0) {
            if ((user = SessionCreator.prompt("username", user, info)) == null || user.length() == 0) {
                logger.info("invalid user name.");
                return null;
            }
            info.setProperty("username", user);
        }
        if (address == null || address.length() == 0) {
            if ((address = SessionCreator.prompt("address", address, info)) == null || address.length() == 0) {
                logger.info("invalid address.");
                return null;
            }
            info.setProperty("address", address);
        }
        JSch jsch = KnownHosts.getJSch();
        Session session = jsch.getSession(user, address, 22);
        MyUserInfo userinfo = new MyUserInfo(info);
        session.setUserInfo(userinfo);
        session.connect();
        return session;
    }

    public static Session getSession(HostInfo info, int timeout) throws JSchException {
        logger.debug("creating session: ");
        String user = info.getProperty("username");
        String address = info.getProperty("address");
        if (user == null || user.length() == 0) {
            SessionCreator.prompt("username", user, info);
            if (user == null || user.length() == 0) {
                logger.info("operation canceled.");
                return null;
            }
        }
        if (address == null || address.length() == 0) {
            SessionCreator.prompt("address", address, info);
            if (address == null || address.length() == 0) {
                logger.info("operation canceled.");
                return null;
            }
        }
        MyUserInfo userinfo = new MyUserInfo(info);
        JSch jsch = KnownHosts.getJSch();
        Session session = jsch.getSession(user, address, 22);
        session.setUserInfo(userinfo);
        session.setTimeout(timeout);
        session.connect();
        return session;
    }

    private static String prompt(String tag, String str, HostInfo info) {
        JTextField text = new JTextField();
        Object[] ob = new Object[]{text};
        int result = JOptionPane.showConfirmDialog(Desktop.getDesktop(), text, "enter " + tag, 2);
        if (result == 0) {
            str = text.getText();
            info.setProperty(tag, str);
            return str;
        }
        return null;
    }
}

