/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.graph.dataset;

import java.util.Vector;
import jp.advancesoft.chase.graph.dataset.DataSetElement;
import jp.advancesoft.chase.graph.dataset.DataSetSet;
import org.apache.log4j.Logger;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DataSetCollection {
    private Logger logger = Logger.getLogger(DataSetCollection.class.getName());
    private Vector dsetVector = new Vector();
    private Vector dsetSet = new Vector();
    private String name = "";

    public DataSetCollection(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getDataSetCollectionCount() {
        return this.dsetSet.size();
    }

    public void initData() {
        this.dsetSet = new Vector();
    }

    private DataSetSet getDataSetSet(int ID) {
        for (int i = 0; i < this.dsetSet.size(); ++i) {
            if (ID != ((DataSetSet)this.dsetSet.get(i)).getID()) continue;
            return (DataSetSet)this.dsetSet.get(i);
        }
        DataSetSet set = new DataSetSet(ID);
        this.dsetSet.addElement(set);
        return set;
    }

    public void addRange(DataSetElement dse) {
        this.addRange(0, dse);
    }

    public void addRange(int ID, DataSetElement dse) {
        DataSetSet set = this.getDataSetSet(ID);
        set.addRange(dse);
    }

    public void setDomain(DataSetElement dse) {
        this.setDomain(0, dse);
    }

    public void setDomain(int ID, DataSetElement dse) {
        DataSetSet set = this.getDataSetSet(ID);
        set.setDomain(dse);
    }

    public void setDomainAxisName(int ID, String domainAxisName) {
        DataSetSet set = this.getDataSetSet(ID);
        set.setDomainAxisName(domainAxisName);
    }

    public void setRangeAxisName(int ID, String rangeAxisName) {
        DataSetSet set = this.getDataSetSet(ID);
        set.setRangeAxisName(rangeAxisName);
    }

    public String[] getAxisNames(int ID) {
        DataSetSet set = this.getDataSetSet(ID);
        return set.getAxisNames();
    }

    public String getRangeAxisName(int ID) {
        DataSetSet set = this.getDataSetSet(ID);
        return set.getRangeAxisName();
    }

    public String getDomainAxisName(int ID) {
        DataSetSet set = this.getDataSetSet(ID);
        return set.getDomainAxisName();
    }

    public DataSetElement getDomain(int ID) {
        DataSetSet set = this.getDataSetSet(ID);
        return set.getDomain();
    }

    public DataSetElement getDomain() {
        DataSetSet set = this.getDataSetSet(0);
        return set.getDomain();
    }

    public DataSetElement[] getRange(int ID) {
        DataSetSet set = this.getDataSetSet(ID);
        return set.getRange();
    }

    public DataSetElement[] getRange() {
        return this.getRange(0);
    }

    public XYSeriesCollection getXYSeriesCollection() {
        return this.getXYSeriesCollection(0);
    }

    public XYSeriesCollection getXYSeriesCollection(int ID) {
        XYSeriesCollection collection = new XYSeriesCollection();
        DataSetElement delem = this.getDomain(ID);
        DataSetElement[] relem = this.getRange(ID);
        if (delem == null || relem == null) {
            return null;
        }
        String[] domainData = delem.getData();
        if (domainData == null || domainData.length == 0) {
            return null;
        }
        double[] ddomainData = new double[domainData.length];
        try {
            for (int j = 0; j < domainData.length; ++j) {
                ddomainData[j] = Double.parseDouble(domainData[j].replace('D', 'E'));
                this.logger.debug("dsetx at " + j + ": " + ddomainData[j]);
            }
        }
        catch (NumberFormatException nfe) {
            this.logger.error("domain data: not a number. ");
            return null;
        }
        for (int ra = 0; ra < relem.length; ++ra) {
            DataSetElement dsete = relem[ra];
            XYSeries series = new XYSeries((Comparable)((Object)dsete.getFullName()), true, true);
            try {
                String[] str = dsete.getData();
                if (str == null || str.length == 0) continue;
                for (int j = 0; j < str.length; ++j) {
                    double d = Double.parseDouble(str[j].replace('D', 'E'));
                    this.logger.debug("range data for " + dsete.getName() + " at " + j + ": " + str[j]);
                    series.add(ddomainData[j], d);
                }
            }
            catch (NumberFormatException npe) {
                this.logger.warn("data no. " + ra + " of " + ID + " was not a number; ignoring.");
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aiobe) {
                this.logger.error("inconsistent data");
                return null;
            }
            collection.addSeries(series);
        }
        return collection;
    }
}

