/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.common;

import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import jp.advancesoft.chase.common.MenuBlock;
import org.apache.log4j.Logger;

public class MenuTree {
    private Logger logger = Logger.getLogger(MenuTree.class.getName());
    private MenuBlock list = new MenuBlock(null, null);

    public void addMenu(JMenu menu) {
        this.list.add(new MenuBlock(this.list, menu));
    }

    public void addMenuItem(JMenuItem menuItem) {
        this.addMenuItem(menuItem, false);
    }

    public void addMenuItem(JMenuItem menuItem, boolean hasSeparator) {
        JMenu menu = this.list.getMenu();
        if (menu != null) {
            if (hasSeparator) {
                menu.add(new JSeparator());
            }
            menu.add(menuItem);
        }
    }

    public void selectBlock(JMenu menu) {
        String name = menu.getText();
        this.logger.debug("menu: " + menu);
        this.logger.debug("size of list: " + this.list.size());
        for (int i = 1; i < this.list.size(); ++i) {
            MenuBlock bl = (MenuBlock)this.list.get(i);
            this.logger.debug("block: " + bl);
            if (!name.trim().equals(bl.getName())) continue;
            this.list = bl;
            return;
        }
        this.list.add(new MenuBlock(this.list, menu));
        this.selectBlock(menu);
    }

    public void selectBlock(String name) {
        for (int i = 1; i < this.list.size(); ++i) {
            MenuBlock bl = (MenuBlock)this.list.get(i);
            this.logger.debug("block: " + bl);
            if (!name.trim().equals(bl.getName())) continue;
            this.list = bl;
            return;
        }
        JMenu menu = new JMenu(name);
        this.list.add(new MenuBlock(this.list, menu));
        this.selectBlock(menu);
    }

    public void selectParent() {
        this.list = (MenuBlock)this.list.get(0);
    }

    public void selectRoot() {
        while (this.list.get(0) != null) {
            this.selectParent();
        }
    }

    public JMenu[] getMenus() {
        this.selectRoot();
        Vector<JMenu> menuvec = new Vector<JMenu>();
        for (int i = 1; i < this.list.size(); ++i) {
            menuvec.addElement(((MenuBlock)this.list.get(i)).getMenu());
        }
        if (menuvec.size() == 0) {
            return null;
        }
        Object[] ret = new JMenu[menuvec.size()];
        menuvec.copyInto(ret);
        return ret;
    }
}

