/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;
import jp.advancesoft.chase.common.ConstParameters;
import jp.advancesoft.chase.common.ExternalProgramExecuter;
import jp.advancesoft.chase.common.MyMessageBox;
import jp.advancesoft.chase.ssh.Execute;
import org.apache.log4j.Logger;

class ProcessManager {
    private static Logger logger = Logger.getLogger(ProcessManager.class.getName());
    private MyMessageBox mbox = new MyMessageBox();
    public static final int KILL_TERM = 9;
    public static final int KILL_KILL = 15;
    private Execute execute;
    private String username;

    protected ProcessManager() {
    }

    protected ProcessManager(Execute execute, String username) {
        this.execute = execute;
        this.username = username;
    }

    protected Vector getProcess() {
        Vector processVector = new Vector();
        String ps = "";
        if (this.execute == null) {
            ps = this.getpsCommand();
            try {
                BufferedReader[] bin = ExternalProgramExecuter.executeGetBR(ps);
                processVector = this.getProcessString(bin[0]);
            }
            catch (Exception e) {
                return null;
            }
        } else {
            String pscom = "ps -u " + this.username + " -l";
            String res = new String();
            res = this.execute.command(pscom);
            logger.debug("got string: " + res);
            if (res.length() != 0) {
                if (res.trim().startsWith("ps:") && (res = this.execute.command(pscom = "ps -uxc")).length() != 0 && res.trim().startsWith("ps:")) {
                    return null;
                }
                String[] pss = res.split("\\n");
                if (pss.length <= 0 && (pss = res.split(System.getProperty("file.separator"))).length <= 0) {
                    return null;
                }
                for (int i = 0; i < pss.length; ++i) {
                    processVector.add(pss[i]);
                }
            } else {
                return null;
            }
        }
        return processVector;
    }

    protected void killProcess(int id, String term) {
        if (id >= 0) {
            String kill = "kill -" + term + " " + id;
            logger.info("performing command: " + kill);
            if (this.execute == null) {
                try {
                    BufferedReader[] br = ExternalProgramExecuter.executeGetBR(kill);
                    this.writetoStdOut(br[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("failed to kill process " + id);
                }
            } else {
                this.execute.command(kill);
            }
        } else {
            logger.error("invalid PID");
        }
    }

    private void writetoStdOut(BufferedReader br) {
        String str = new String();
        try {
            while ((str = br.readLine()) != null) {
                logger.info(str);
            }
        }
        catch (IOException ie) {
            logger.error("failed to read from: " + br);
        }
    }

    private Vector getProcessString(BufferedReader br) {
        String string = new String();
        Vector<String> returnVector = new Vector<String>();
        try {
            while ((string = br.readLine()) != null) {
                returnVector.addElement(string);
            }
        }
        catch (Exception e) {
            this.mbox.setText("failed read from stdout");
            return null;
        }
        return returnVector;
    }

    private String getpsCommand() {
        String ret = new String();
        String osName = ConstParameters.osName.toLowerCase().trim();
        ret = osName.startsWith("hp-ux") || osName.startsWith("aix") || osName.startsWith("irix") || osName.startsWith("windows") || osName.startsWith("linux") ? "ps -u " + System.getProperty("user.name") + " -l" : "ps -uxc";
        return ret;
    }
}

