/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.util.StringTokenizer;
import java.util.Vector;
import jp.advancesoft.chase.common.LineEditor;
import jp.advancesoft.chase.phase.FileParserEkCal;

class F_INPParserEkCal
extends FileParserEkCal {
    private LineEditor lineeditor;
    private Vector tagVec;
    private int tagStart;

    public F_INPParserEkCal(String fileName) {
        super(fileName);
    }

    public void initializeLineEditor() {
        this.lineeditor = new LineEditor(super.getString());
    }

    public boolean checkAndModify() {
        int iek_convtag;
        int icondtag;
        boolean bmod = false;
        int icontroltag = this.lineeditor.findIgnoreCase("control");
        if (icontroltag == -1) {
            this.lineeditor.addLine(0, "Control{");
            this.lineeditor.addLine(1, "}");
            icontroltag = 0;
            bmod = true;
        }
        if ((icondtag = this.lineeditor.findIgnoreCase(icontroltag, "condition")) == -1) {
            this.lineeditor.addLine(icontroltag + 1, "     condition = fixed_charge");
            bmod = true;
        } else {
            String condition = this.lineeditor.getLine(icondtag);
            StringTokenizer st = new StringTokenizer(condition, "=");
            if (st.countTokens() < 2) {
                System.out.println("invalid condition tag!");
            } else {
                st.nextToken();
                String value = st.nextToken().trim().toLowerCase().trim();
                if (!(value.startsWith("fixed_charge") || value.startsWith("fixed_charge_continuation") || value.startsWith("2") || value.startsWith("3"))) {
                    this.lineeditor.replaceLine(icondtag, "     condition = fixed_charge");
                    bmod = true;
                }
            }
        }
        int iaccuracytag = this.lineeditor.findIgnoreCase("accuracy");
        if (iaccuracytag == -1) {
            this.lineeditor.addLine(0, "accuracy{");
            this.lineeditor.addLine(1, "}");
            iaccuracytag = 0;
            bmod = true;
        }
        if ((iek_convtag = this.lineeditor.findIgnoreCase("ek_convergence")) == -1) {
            this.lineeditor.addLine(iaccuracytag + 1, "     ek_convergence{");
            this.lineeditor.addLine(iaccuracytag + 2, "          num_max_iteration = 500");
            this.lineeditor.addLine(iaccuracytag + 3, "          sw_eval_eig_diff = on");
            this.lineeditor.addLine(iaccuracytag + 4, "          delta_eigenvalue = 1.e-6 hartree");
            this.lineeditor.addLine(iaccuracytag + 5, "          succession = 2");
            this.lineeditor.addLine(iaccuracytag + 6, "     }");
            bmod = true;
        }
        super.setString(this.lineeditor.getFullString());
        return bmod;
    }

    public boolean selectTag(String tag) {
        int tagStartBuf = this.tagStart;
        this.tagStart = this.lineeditor.findIgnoreCase(tag);
        if (this.tagStart == -1) {
            this.tagStart = tagStartBuf;
            return false;
        }
        return true;
    }

    public int getTagStart() {
        return this.tagStart;
    }

    public void addLine(int addTag, String value) {
        this.lineeditor.addLine(addTag + 1, value);
        super.setString(this.lineeditor.getFullString());
    }

    public void modify(String key, String value, int offset) {
        String whiteSpace = new String();
        String space = " ";
        for (int i = 0; i < offset; ++i) {
            whiteSpace = whiteSpace + space;
        }
        int imod = this.lineeditor.findIgnoreCase(this.tagStart, key);
        if (imod == -1) {
            this.lineeditor.addLine(this.tagStart + 1, whiteSpace + key + " = " + value);
        } else {
            this.lineeditor.replaceLine(imod, whiteSpace + key + " = " + value);
        }
        super.setString(this.lineeditor.getFullString());
    }
}

