/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfaceUnits;
import jp.advancesoft.chase.phase.ComboBoxPhaseUnit;
import jp.advancesoft.chase.phase.PhaseInputPanelInterface;
import org.apache.log4j.Logger;

public class ChoicePanelPhaseUnit
extends JPanel
implements PhaseInputPanelInterface {
    private ComboBoxPhaseUnit combobox;
    private static Logger logger = Logger.getLogger(ChoicePanelPhaseUnit.class.getName());
    private InputInterface inputinterface;
    private InputInterfaceUnits units;
    private String[] inputSpecifications;
    private String[] choices;
    private String[] fullName;
    private String title;
    private Vector dupli = null;

    ChoicePanelPhaseUnit(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices, EventListener parent) {
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.title = title;
        this.choices = choices;
        this.extractInputFile();
        this.createGUI();
        this.addListeners(parent);
    }

    ChoicePanelPhaseUnit(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices, Vector dupli, EventListener parent) {
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.title = title;
        this.choices = choices;
        this.dupli = dupli;
        this.extractInputFile();
        this.createGUI();
        this.addListeners(parent);
    }

    ChoicePanelPhaseUnit(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices) {
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.title = title;
        this.choices = choices;
        this.extractInputFile();
        this.createGUI();
    }

    ChoicePanelPhaseUnit(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices, Vector dupli) {
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.title = title;
        this.choices = choices;
        this.dupli = dupli;
        this.extractInputFile();
        this.createGUI();
    }

    private void extractInputFile() {
        for (int is = 0; is < this.inputSpecifications.length; ++is) {
            String inp = this.inputSpecifications[is];
            logger.debug("inp: " + inp);
            this.fullName = inp.split("\\.");
            this.inputinterface.selectRoot();
            logger.debug("length of fullName: " + this.fullName.length);
            for (int i = 0; i < this.fullName.length - 1; ++i) {
                String ident = this.fullName[i];
                if (this.inputinterface.selectBlock(ident)) continue;
                logger.debug("couldn't select block: " + ident);
            }
            this.units = this.inputinterface.getUnits();
            if (this.units.getName().trim().length() == 0 && is != this.inputSpecifications.length - 1) continue;
            logger.debug("got entry: " + this.units.getName());
            String st = this.inputSpecifications[0];
            this.inputinterface.selectRoot();
            break;
        }
    }

    private void createGUI() {
        super.setLayout(new BoxLayout(this, 0));
        this.createComboBox();
        super.add(this.combobox);
        if (this.title != null) {
            super.setBorder(new TitledBorder(this.title));
        }
    }

    private void createComboBox() {
        this.combobox = new ComboBoxPhaseUnit(this.choices, this.inputSpecifications, this.inputinterface, 4);
        String[] value = this.units.getUnits();
        if (value != null) {
            block0: for (int j2 = 0; j2 < this.choices.length; ++j2) {
                for (int i = 0; i < value.length; ++i) {
                    String val = value[i].trim();
                    if (!this.choices[j2].equalsIgnoreCase(val)) continue;
                    this.combobox.setSelectedIndex(j2);
                    continue block0;
                }
            }
        }
    }

    public void addListeners(EventListener listener) {
        this.combobox.addActionListener((ActionListener)listener);
    }

    public void setEnabled(boolean enabled) {
        this.combobox.setEnabled(enabled);
    }

    public String getValue() {
        return (String)this.combobox.getSelectedItem();
    }

    public String getUnit() {
        return new String();
    }

    public JComboBox getComboBox() {
        return this.combobox;
    }
}

