/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.HasNestedException;
import jas.util.NestedException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class NestedRuntimeException
extends RuntimeException
implements HasNestedException {
    private Throwable detail;

    public NestedRuntimeException(Throwable throwable) {
        this.detail = throwable;
    }

    public NestedRuntimeException(String string, Throwable throwable) {
        super(string);
        this.detail = throwable;
    }

    public Throwable getNestedException() {
        return this.detail;
    }

    public String getMessage() {
        return NestedException.formatNestedException(this);
    }

    public String getSimpleMessage() {
        return super.getMessage();
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.detail != null) {
            System.err.println("Nested Exception is:");
            this.detail.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.detail != null) {
            printStream.println("Nested Exception is:");
            this.detail.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.detail != null) {
            printWriter.println("Nested Exception is:");
            this.detail.printStackTrace(printWriter);
        }
    }
}

