/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.DocumentOutputStream;
import jas.util.JASDialog;
import jas.util.JASState;
import jas.util.OnScreenPopupMenu;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class ErrorBox
extends JASDialog {
    private Throwable m_throw;
    private boolean m_details;
    private JFrame m_frame;

    public ErrorBox(JFrame jFrame, String string) {
        this(jFrame, string, null, null);
    }

    public ErrorBox(JFrame jFrame, String string, String string2) {
        this(jFrame, string, null, string2);
    }

    public ErrorBox(JFrame jFrame, String string, Throwable throwable) {
        this(jFrame, string, throwable, null);
    }

    public ErrorBox(JFrame jFrame, String string, Throwable throwable, String string2) {
        super((Frame)jFrame, "Error...", true, 1 | (throwable != null ? 6 : 0) | (string2 != null ? 8 : 0));
        if (string2 != null) {
            this.setHelpTopic(string2);
        }
        this.init(string, throwable, jFrame);
    }

    private void init(String string, Throwable throwable, JFrame jFrame) {
        this.setApplyLabel("Details");
        this.setApplyMnemonic('D');
        this.setCancelLabel("Traceback");
        this.setCancelMnemonic('T');
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(UIManager.getIcon("OptionPane.errorIcon")));
        jPanel.add(new JLabel(string));
        this.getContentPane().add((Component)jPanel, "North");
        this.m_frame = jFrame;
        this.m_throw = throwable;
        this.m_details = throwable != null;
        this.pack();
        this.getToolkit().beep();
    }

    protected final void enableApply(JASState jASState) {
        jASState.setEnabled(this.m_details);
    }

    protected final void onCancel() {
        JTextArea jTextArea = new JTextArea();
        PrintWriter printWriter = new PrintWriter(new DocumentOutputStream(jTextArea.getDocument()));
        this.m_throw.printStackTrace(printWriter);
        printWriter.close();
        jTextArea.setEditable(false);
        jTextArea.addMouseListener(new PopupListener(new PopupMenu(jTextArea)));
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(500, 300));
        JOptionPane.showMessageDialog(this, jScrollPane, "Traceback...", -1);
    }

    protected final void onApply() {
        JTextArea jTextArea = new JTextArea(this.m_throw.toString());
        jTextArea.setEditable(false);
        jTextArea.addMouseListener(new PopupListener(new PopupMenu(jTextArea)));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jTextArea);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.pack();
        this.m_details = false;
        this.callEnable();
    }

    private static class PopupListener
    extends MouseAdapter {
        private JPopupMenu menu;

        PopupListener(JPopupMenu jPopupMenu) {
            this.menu = jPopupMenu;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent);
        }

        private void maybePopup(MouseEvent mouseEvent) {
            if (this.menu.isPopupTrigger(mouseEvent)) {
                this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private static class PopupMenu
    extends OnScreenPopupMenu
    implements ActionListener {
        private JTextArea parent;
        JMenuItem copy = new JMenuItem("Copy", 67);
        JMenuItem select = new JMenuItem("Select All", 83);

        PopupMenu(JTextArea jTextArea) {
            this.parent = jTextArea;
            this.copy.addActionListener(this);
            this.select.addActionListener(this);
            this.add(this.copy);
            this.add(this.select);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.select) {
                this.parent.selectAll();
            } else if (object == this.copy) {
                this.parent.copy();
            }
        }
    }
}

