/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;

public class ColorMenu
extends JMenu {
    private ColorSelectionModel colorModel;
    private ButtonGroup group = new ButtonGroup();
    public static final Color[] BASIC_COLORS = new Color[]{Color.black, Color.darkGray, Color.gray, Color.lightGray, Color.blue, Color.cyan, Color.green, Color.magenta, Color.red, Color.pink, Color.orange, Color.yellow, Color.white};
    public static final String[] BASIC_COLOR_NAMES = new String[]{"black", "dark gray", "gray", "light gray", "blue", "cyan", "green", "magenta", "red", "pink", "orange", "yellow", "white"};
    public static final Color[] EXTENDED_COLORS = new Color[]{Color.black, new Color(0.1f, 0.1f, 0.1f), new Color(0.2f, 0.2f, 0.2f), new Color(0.3f, 0.3f, 0.3f), new Color(0.4f, 0.4f, 0.4f), new Color(0.5f, 0.5f, 0.5f), new Color(0.6f, 0.6f, 0.6f), new Color(0.7f, 0.7f, 0.7f), new Color(0.8f, 0.8f, 0.8f), new Color(0.9f, 0.9f, 0.9f), Color.white, Color.red, new Color(255, 136, 28), new Color(120, 62, 27), new Color(0, 125, 32), new Color(11, 157, 150), Color.blue, new Color(109, 0, 168), new Color(168, 0, 126), Color.pink, Color.orange, Color.yellow, Color.green, Color.cyan, new Color(164, 207, 255), new Color(225, 170, 255), new Color(255, 170, 210)};
    public static final String[] EXTENDED_COLOR_NAMES = new String[]{"black", "grey 10%", "grey 20%", "grey 30%", "grey 40%", "grey 50%", "grey 60%", "grey 70%", "grey 80%", "grey 90%", "white", "red", "orange", "brown", "green", "turquoise", "blue", "purple", "magenta", "pink", "light orange", "yellow", "light green", "cyan", "sky blue", "violet", "light magenta"};
    private static final int size = 12;

    public ColorMenu(String string, ColorSelectionModel colorSelectionModel) {
        this(string, colorSelectionModel, false);
    }

    public ColorMenu(String string) {
        this(string, false);
    }

    public ColorMenu(String string, boolean bl) {
        this(string, new DefaultColorSelectionModel(), bl);
    }

    public ColorMenu(String string, ColorSelectionModel colorSelectionModel, boolean bl) {
        this(string, colorSelectionModel, bl ? EXTENDED_COLORS : BASIC_COLORS, bl ? EXTENDED_COLOR_NAMES : BASIC_COLOR_NAMES);
    }

    public ColorMenu(String string, ColorSelectionModel colorSelectionModel, Color[] colorArray, String[] stringArray) {
        super(string);
        this.colorModel = colorSelectionModel;
        for (int i = 0; i < colorArray.length; ++i) {
            this.add(new ColorMenuItem(colorArray[i], stringArray[i]));
        }
        this.add(new OtherColorMenuItem());
    }

    public ColorSelectionModel getSelectionModel() {
        return this.colorModel;
    }

    public void setSelectionModel(ColorSelectionModel colorSelectionModel) {
        this.colorModel = colorSelectionModel;
    }

    public Color getColor() {
        return this.colorModel.getSelectedColor();
    }

    public void setColor(Color color) {
        this.colorModel.setSelectedColor(color);
    }

    protected void fireMenuSelected() {
        Color color = this.colorModel.getSelectedColor();
        Enumeration<AbstractButton> enumeration = this.group.getElements();
        while (enumeration.hasMoreElements()) {
            ColorMenuItem colorMenuItem = (ColorMenuItem)enumeration.nextElement();
            colorMenuItem.setSelectedColor(color);
        }
        super.fireMenuSelected();
    }

    private class OtherColorMenuItem
    extends JMenuItem {
        OtherColorMenuItem() {
            super("Other...");
        }

        public void fireActionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(this, "Choose color...", ColorMenu.this.colorModel.getSelectedColor());
            if (color != null) {
                ColorMenu.this.colorModel.setSelectedColor(color);
            }
        }
    }

    private class ColorMenuItem
    extends JRadioButtonMenuItem
    implements Icon {
        private Color color;

        ColorMenuItem(Color color, String string) {
            super(string);
            this.setIcon(this);
            this.color = color;
            ColorMenu.this.group.add(this);
        }

        public void fireActionPerformed(ActionEvent actionEvent) {
            ColorMenu.this.colorModel.setSelectedColor(this.color);
        }

        void setSelectedColor(Color color) {
            this.setSelected(color == this.color);
        }

        public int getIconHeight() {
            return 12;
        }

        public int getIconWidth() {
            return 12;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(this.color == null ? this.getBackground() : this.color);
            graphics.fill3DRect(n, n2, 12, 12, true);
            graphics.setColor(color);
        }
    }
}

