/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.AxisType;
import jas.plot.CoordinateTransformation;
import jas.plot.PlotGraphics;
import jas.plot.StringCoordinateTransformation;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;

public final class StringAxis
extends AxisType
implements StringCoordinateTransformation {
    public static final int CENTER_TEXT_IN_DIVISION = 1;
    public static final int TEXT_BESIDE_DIVISION = 2;
    private int labelPlacementStyle;
    private Hashtable hash;
    private final int majorTickLength = 5;
    private final int minorTickLength = 3;
    private final int minSpaceBetweenLabels = 3;
    private String[] labels;
    private int[] layers;

    public StringAxis() {
        this(1);
    }

    public StringAxis(int n) {
        this.labelPlacementStyle = n;
    }

    public void setLabelPlacementStyle(int n) {
        this.labelPlacementStyle = n;
    }

    public int getLabelPlacementStyle() {
        return this.labelPlacementStyle;
    }

    public void setLabels(String[] stringArray) {
        if (this.hash == null) {
            this.hash = new Hashtable(stringArray.length);
        } else {
            this.hash.clear();
        }
        this.labels = stringArray;
        for (int i = 0; i < stringArray.length; ++i) {
            this.hash.put(stringArray[i], new Integer(i));
        }
        if (this.axis != null && this.axis.getAxisOrientation() == 2 && (this.layers == null || this.layers.length != stringArray.length)) {
            this.layers = new int[stringArray.length];
        }
        this.labelsValid = false;
    }

    public String[] getLabels() {
        return this.labels;
    }

    CoordinateTransformation getCoordinateTransformation() {
        return this;
    }

    void assumeAxisLength(int n) {
        int n2;
        if (this.labels == null || this.labels.length == 0) {
            return;
        }
        this.labelsValid = true;
        Font font = this.axis.getFont();
        FontMetrics fontMetrics = this.axis.getToolkit().getFontMetrics(font);
        int n3 = n2 = this.labelPlacementStyle == 1 ? n / this.labels.length / 2 : 0;
        if (this.axis.getAxisOrientation() == 2) {
            this.spaceRequirements.flowPastEnd = this.labelPlacementStyle == 1 ? Math.max(fontMetrics.stringWidth(this.labels[this.labels.length - 1]) / 2 - n / this.labels.length / 2, 0) : fontMetrics.stringWidth(this.labels[this.labels.length - 1]) / 2;
            this.spaceRequirements.width = Math.max(0, fontMetrics.stringWidth(this.labels[0]) / 2 - n2);
            int n4 = 0;
            if (n > 0) {
                int[] nArray = new int[3];
                int n5 = this.labelPlacementStyle == 2 ? this.labels.length - 1 : this.labels.length;
                int n6 = this.spaceRequirements.width + 3;
                if (this.labelPlacementStyle == 1) {
                    n6 += n / this.labels.length / 2;
                }
                for (int i = 0; i < this.labels.length; ++i) {
                    int n7 = n6 + i * n / n5;
                    int n8 = 0;
                    int n9 = fontMetrics.stringWidth(this.labels[i]) / 2;
                    if (i != 0) {
                        while (n7 - n9 < nArray[n8]) {
                            if (++n8 < nArray.length) continue;
                            int[] nArray2 = new int[nArray.length * 2];
                            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                            nArray = nArray2;
                        }
                    }
                    if (n8 > n4) {
                        n4 = n8;
                    }
                    nArray[n8] = n7 + n9 + 3;
                    this.layers[i] = n8;
                }
            }
            this.spaceRequirements.height = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 7 + n4 * fontMetrics.getHeight();
        } else {
            this.spaceRequirements.width = this.longestStringLength(fontMetrics, this.labels) + 7;
            this.spaceRequirements.height = Math.max(0, fontMetrics.getAscent() / 2 + fontMetrics.getMaxDescent() - n2);
            this.spaceRequirements.flowPastEnd = this.labelPlacementStyle == 1 ? Math.max(fontMetrics.getMaxAscent() - fontMetrics.getAscent() / 2 - n / this.labels.length / 2, 0) : fontMetrics.getMaxAscent() - fontMetrics.getAscent() / 2;
        }
    }

    void paintAxis(PlotGraphics plotGraphics, double d, double d2, double d3, Color color, Color color2, Color color3) {
        block4: {
            if (this.labels == null) break block4;
            int n = this.labelPlacementStyle == 2 ? this.labels.length - 1 : this.labels.length;
            FontMetrics fontMetrics = plotGraphics.getFontMetrics();
            if (this.axis.getAxisOrientation() == 2) {
                double d4 = this.labelPlacementStyle == 2 ? d : d + d3 / (double)this.labels.length / 2.0;
                double d5 = d2 + (double)fontMetrics.getMaxAscent() + 7.0;
                double d6 = fontMetrics.getHeight();
                for (int i = 0; i < this.labels.length; ++i) {
                    double d7 = d4 + (double)i * d3 / (double)n;
                    plotGraphics.setColor(color2);
                    plotGraphics.drawLine(d7, d2 + 5.0, d7, d2 - 5.0);
                    plotGraphics.setColor(color);
                    plotGraphics.drawString(this.labels[i], d7 - (double)(fontMetrics.stringWidth(this.labels[i]) / 2), d5 + (double)this.layers[i] * d6);
                }
            } else {
                double d8 = this.axis.onLeftSide ? d - 7.0 : d + 7.0;
                double d9 = this.labelPlacementStyle == 2 ? d2 : d2 - d3 / (double)this.labels.length / 2.0;
                double d10 = fontMetrics.getAscent() / 2;
                for (int i = 0; i < this.labels.length; ++i) {
                    double d11 = d9 - (double)i * d3 / (double)n;
                    plotGraphics.setColor(color);
                    plotGraphics.drawString(this.labels[i], this.axis.onLeftSide ? d8 - (double)fontMetrics.stringWidth(this.labels[i]) : d8, d11 + d10);
                    plotGraphics.setColor(color2);
                    plotGraphics.drawLine(d + 5.0, d11, d - 5.0, d11);
                }
            }
        }
    }

    int getMajorTickMarkLength() {
        return 5;
    }

    private int longestStringLength(FontMetrics fontMetrics, String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = fontMetrics.stringWidth(stringArray[i]);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private double indexToLocation(int n) {
        double d = this.axis.getMinLocation();
        double d2 = this.axis.getMaxLocation();
        if (this.labelPlacementStyle == 1) {
            return d + (d2 - d) * (double)n / (double)this.labels.length + (d2 - d) / (double)this.labels.length / 2.0;
        }
        return d + (d2 - d) * (double)n / (double)this.labels.length;
    }

    public double convert(String string) {
        try {
            return this.indexToLocation((Integer)this.hash.get(string));
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    public double binWidth() {
        return (double)(this.axis.getMaxLocation() - this.axis.getMinLocation()) / (double)this.labels.length;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.labelPlacementStyle);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.labelPlacementStyle = objectInput.readInt();
    }
}

