/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/05/10, 18:50
!  AUTHOR(S): KOGA, Junichiro
!  File : MagPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * ֌W̐ݒs.
 * 
 * @author
 */
public class MagPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(MagPanel.class.getName());

    /** Creates a new instance of MagPanel */
    public MagPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        JScrollPane scr = new JScrollPane();
        scr.getViewport().setView(
                new MagPanelPanel(projectInfo.getInputInterface()));
        add(scr);
    }

    public void initializeProject() {
    }

    public void init() {
    }

    class MagPanelPanel extends PhaseInputItems implements
            InputInterfaceEntryChangeListener {
        private TableForInputInterface tbl_af;
        private ChoicePanelPhase cppfixspin;
        private InputPanelPhase ippspin;

        MagPanelPanel(InputInterface inputInterface) {
            super(inputInterface);
        }

        private boolean initdone = false;

        public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
            String tag = e.getTag();
            if (!tag.equalsIgnoreCase("structure.symmetry.tspace")) {
                return;
            }
            InputInterfaceEntry ent = e.getEntry();
            if (ent == null || !(ent instanceof InputInterfacePrimitiveEntry)) {
                return;
            }

            if (!((InputInterfacePrimitiveEntry) ent).getName()
                    .equalsIgnoreCase("lattice_system")) {
                return;
            }
            ciss.phase_viewer.common.Utils.stop(tbl_af);
            tbl_af.updateCellEditor(0);
            ((JComboBox) ((DefaultCellEditor) tbl_af.getColumnModel()
                    .getColumn(0).getCellEditor()).getComponent())
                    .addActionListener(new TSpaceRotComboListener(tbl_af));
            initdone = false;
        }

        public void inputInterfaceInitializing() {
        }

        public void inputInterfaceInitialized() {
        }

        public void createGUI() {
            inputInterface.addInputInterfaceEntryChangeListener(this);
            JPanel pall = new JPanel();
            pall.setLayout(new BoxLayout(pall, BoxLayout.Y_AXIS));
            String struc = "structure.";
            String[] magspecs = { struc + "magnetic_state" };
            // String[] magchoice = { NO_SELECTION, "para", "ferro", "antiferro"
            // };
            String[] magchoice = { NO_SELECTION, "para", "ferro" };
            Vector magdupli = new Vector();
            magdupli.addElement(new String[] { "3", "af" });
            ChoicePanelPhase mag = new ChoicePanelPhase(magspecs,
                    inputInterface, "magnetic state", magchoice, magdupli, this);
            String[] specfixspin = { struc
                    + "ferromagnetic_state.sw_fix_total_spin" };
            cppfixspin = new ChoicePanelPhase(specfixspin, inputInterface,
                    "fix total spin", ON_OFF, ON_OFF_DUPLI, this);
            String[] specspin = { struc + "ferromagnetic_state.total_spin" };
            ippspin = new InputPanelPhase(specspin, inputInterface,
                    "total spin", InputPanelPhase.NONE, 7, this);
            cppfixspin.registerDisabableGUI(new int[] { 0, 2 },
                    ippspin.getTextField());
            JPanel pmag = new JPanel();
            pmag.setLayout(new GridLayout(1, 3));
            pmag.add(mag);
            pmag.add(cppfixspin);
            pmag.add(ippspin);

            JPanel p_tspace = new JPanel();
            p_tspace.setLayout(new BoxLayout(p_tspace, BoxLayout.Y_AXIS));
            p_tspace.setBorder(new TitledBorder(
                    "tspace (necessary for anti-ferro magnetic calculations."));

            JPanel p_tspace_misc = new JPanel();
            p_tspace_misc.setLayout(new BoxLayout(p_tspace_misc,
                    BoxLayout.X_AXIS));

            String[] latticesymmspec = {
                    "structure.symmetry.tspace.lattice_system",
                    "structure.symmetry.tspace.system" };
            String[] latticesymmchoi = { NO_SELECTION, "trigonal", "hexagonal",
                    "primitive", "facecentered", "bodycentered", "basecentered" };
            ChoicePanelPhase latticesymm = new ChoicePanelPhase(
                    latticesymmspec, inputInterface, "lattice system",
                    latticesymmchoi, this);

            p_tspace_misc.add(latticesymm);

            p_tspace.add(p_tspace_misc);

            String[] afgentablespec = { "structure.symmetry.tspace.af_generator" };
            JPanel p_tspace_table_af = new JPanel();
            p_tspace_table_af.setBorder(new TitledBorder("af_generator"));

            tbl_af = new TableForInputInterface(afgentablespec, inputInterface,
                    this);

            tbl_af.setColumnSelectionAllowed(true);
            tbl_af.setRowSelectionAllowed(true);
            cppfixspin.getComboBox().addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent arg0) {
                    String val = ippspin.getValue();
                    if (val == null || val.trim().length() == 0)
                        ippspin.getTextField().setText("0");
                }
            });

            JScrollPane scrPane_af = new JScrollPane();
            scrPane_af.getViewport().setView(tbl_af);
            scrPane_af.setPreferredSize(new Dimension(500, 40));
            p_tspace_table_af.add(scrPane_af);
            p_tspace.add(p_tspace_table_af);

            int[] intaf = new int[] { 0, 1, 2 };
            mag.registerDisabableGUI(intaf, latticesymm);
            mag.registerDisabableGUI(new int[] { 0, 1, 3 },
                    cppfixspin.getComboBox());

            int[] intarray = new int[] { 0 };
            latticesymm.registerDisabableGUI(intarray, tbl_af);

            pall.add(pmag);
            // pall.add(p_tspace);
            setLayout(new BorderLayout());
            add(pall, BorderLayout.NORTH);
            ((JComboBox) ((DefaultCellEditor) tbl_af.getColumnModel()
                    .getColumn(0).getCellEditor()).getComponent())
                    .addActionListener(new TSpaceRotComboListener(tbl_af));
        }
    }
}
