/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/16, 19:29
!  AUTHOR(S): KOGA, Junichiro
!  File : CmixAndSolver.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.inputcheck;

import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.input.PhaseInputChecker;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;

/**
 * dזx@\o[ȒPɃ`FbN
 * 
 * @author
 */
public class CmixAndSolver extends PhaseInputChecker {
    private Logger logger = Logger.getLogger(CmixAndSolver.class.getName());

    /** Creates a new instance of CmixAndSolver */
    public CmixAndSolver() {
    }

    public boolean isFixable() {
        // return true;
        return false;
    }

    public String getName() {
        return "charge mixing scheme and solver settings";
    }

    public String getDescription() {
        return "check charge mixing scheme and solver settings";
    }

    public String getCandidate() {
        return "";
    }

    public boolean fixInput() {
        // InputInterfaceTable solverTable =
        // inputInterface.getInputInterfaceTable("wavefunction_solver.solvers");
        // InputInterfaceTable cmixTable =
        // inputInterface.getInputInterfaceTable("charge_mixing.mixing_methods");
        // Vector solvers = solverTable.getTableData();
        // Vector cmixs = cmixTable.getTableData();
        //
        // for ( int i=0 ; i<solvers.size() ; i++ ) {
        // String [] sol = (String[]) solvers.get(i);
        // String solMethod = sol[solverTable.getIndexFor("method")];
        // if ( solMethod.trim().toLowerCase().startsWith(rmm) ) {
        // }
        // }
        return true;
    }

    private final String rmm = "rmm";

    private final String davidson = "davidson";

    private final String simple = "simple";

    public int doCheck() {
        InputInterfaceTable solverTable = inputInterface
                .getInputInterfaceTable("wavefunction_solver.solvers");
        InputInterfaceTable cmixTable = inputInterface
                .getInputInterfaceTable("charge_mixing.mixing_methods");
        int solvercmixInd = solverTable.getIndexFor("cmix");
        int solvermethodInd = solverTable.getIndexFor("sol");
        int cmixMethodInd = cmixTable.getIndexFor("method");
        Vector solvers = solverTable.getTableData();
        Vector cmixs = cmixTable.getTableData();

        for (int i = 0; i < solvers.size(); i++) {
            String[] dat = (String[]) solvers.get(i);
            String cmixnum = dat[solvercmixInd];
            if (!Utils.isNumber(cmixnum)) {
                message += "invalid cmix specification : " + cmixnum;
                return ERROR;
            }
            int cmi = Integer.parseInt(cmixnum) - 1;
            if (cmixs.size() < cmi) {
                message += "cmix method no. " + cmi + " undefined.";
                return ERROR;
            }
            String meth = dat[solvermethodInd];
            if (meth.trim().toLowerCase().startsWith(rmm)) {
                String[] cmdata = (String[]) cmixs.get(cmi);
                String cmmethod = cmdata[cmixMethodInd];
                if (!cmmethod.trim().toLowerCase().startsWith("simple")) {
                    message += "the rmm solver must be used with 'simple' cmix method.";
                    return ERROR;
                }
            }
            if (meth.trim().toLowerCase().startsWith(davidson)) {
                String prec = dat[solverTable.getIndexFor("prec")];
                if (Utils.getBool(prec)) {
                    message += "preconditioning must be off for the Davidson solver.";
                    return ERROR;
                }
            }
        }

        return OK;
    }
}
