/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : GraphicsPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.imageviewer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

import javax.swing.JPanel;

class GraphicsPanel extends JPanel {

    /** the buffered image */
    private BufferedImage image;

    /** scale image */
    private double scale = 1.0d;

    /** rotate image */
    private double rot = 0.d;

    /** width of image */
    private int w;

    /** height of image */
    private int h;

    private int pororland = 0;

    /**
     * ̕\ɊւݒɂRXgN^[. 摜HɊւ͐삵Ȃ.
     * 炩߉Hς݂BufferedImagen.
     * 
     * @param image
     *            \BufferedImage
     * @param scale
     *            \̑傫
     * @param rot
     *            ]p
     * @param pororland
     *            |[g[ghXP[vIׂ悤ɂ邽߂̃p^[, ݖ.
     */
    protected GraphicsPanel(BufferedImage image, double scale, double rot,
            int pororland) {
        this.image = image;
        this.w = image.getWidth();
        this.h = image.getHeight();
        this.scale = scale;
        this.rot = rot;
        this.pororland = pororland;

        setPreferredSize(new Dimension((int) (w * scale), (int) (h * scale)));
    }

    /**
     * ftHgRXgN^[
     * 
     * @param image
     *            \BufferedImage
     */
    protected GraphicsPanel(BufferedImage image) {
        this.image = image;
        this.w = image.getWidth();
        this.h = image.getHeight();
        setPreferredSize(new Dimension(w, h));
    }

    /**
     * @param image
     *            \BufferedImage
     */
    protected void setImage(BufferedImage image) {
        this.image = image;
        revalidate();
    }

    /**
     * @param scale
     *            \̑傫
     */
    protected void setScale(double scale) {
        this.scale = scale;
    }

    /**
     * @param rot
     *            \̉]p
     */
    protected void setRotation(double rot) {
        this.rot = rot;
    }

    /**
     * paintComponent\bhI[o[Ch, image{plɕ`悷
     */
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D) g;
        int x = 0;
        int y = 0;
        g2.drawImage(image, null, x, y);
    }

}
