/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/27 18:59:41
!  AUTHOR(S): KOGA, Junichiro
!  File : BasicWizConvCheck.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.inputwizard;

import java.io.File;
import java.text.DecimalFormat;
import java.util.HashMap;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.common.PhaseUtils;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;

public class BasicWizConvCheck extends BasicWiz {
    private Logger logger = Logger.getLogger(BasicWizConvCheck.class.getName());

    private DecimalFormat format = new DecimalFormat("0.00");

    /*
     * (non-Javadoc)
     * 
     * @see
     * ciss.phase_viewer.plugins.projectmanipulator.phase.inputwizard.BasicWiz
     * #createGUI()
     */
    public void createGUI() {
        removeAll();
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, BoxLayout.X_AXIS));
        panel1.setBorder(new TitledBorder("num. bands and kmesh"));
        String[] specband = { "accuracy.num_bands" };
        InputPanelPhase numbands = new InputPanelPhase(specband,
                inputInterface, "num. bands", InputPanelPhase.NONE, 8, this);
        JPanel pb = new JPanel();
        pb.add(numbands);
        String[] kmeshSpec = { "accuracy.ksampling.mesh" };
        TableForInputInterface kmeshTable = new TableForInputInterface(
                kmeshSpec, inputInterface, null, this);
        kmeshTable.getModel().addTableModelListener(this);
        numbands.getTextField().setText(String.valueOf(defaultNumBands));
        kmeshTable.setValueAt(String.valueOf(defaultKmesh[0]), 0, 1);
        kmeshTable.setValueAt(String.valueOf(defaultKmesh[1]), 0, 2);
        kmeshTable.setValueAt(String.valueOf(defaultKmesh[2]), 0, 3);
        String[] kmethodSpec = { "accuracy.ksampling.method" };
        String[] kmethodChoice = { "monk", "mesh", "gamma" };
        ChoicePanelPhase cppkmethod = new ChoicePanelPhase(kmethodSpec,
                inputInterface, "method", kmethodChoice, this);
        cppkmethod.getComboBox().setSelectedIndex(0);
        JPanel ptable = new JPanel();
        ptable.setLayout(new BoxLayout(ptable, BoxLayout.X_AXIS));
        ptable.setBorder(new TitledBorder("kmesh"));
        ptable.add(cppkmethod);
        ptable.add(kmeshTable.getPanel());
        panel1.add(pb);
        panel1.add(ptable);

        JPanel panel2 = new JPanel();
        panel2.setBorder(new TitledBorder("cutoff and convergence"));
        panel2.setLayout(new BoxLayout(panel2, BoxLayout.X_AXIS));
        String[] wfspec = { "accuracy.cutoff_wf" };
        String[] cdspec = { "accuracy.cutoff_cd" };
        String[] convspec = { "accuracy.scf_convergence.delta_total_energy" };
        InputPanelPhase ippwf = new InputPanelPhase(wfspec, inputInterface,
                "wave function cutoff", InputPanelPhase.ENERGY, 6, this);
        InputPanelPhase ippcd = new InputPanelPhase(cdspec, inputInterface,
                "charge density cutoff", InputPanelPhase.ENERGY, 6, this);
        InputPanelPhase ippconv = new InputPanelPhase(convspec, inputInterface,
                "SCF convergence", InputPanelPhase.ENERGY, 6, this);
        ippwf.getTextField().setText(format.format(defaultCutoffWF));
        ippcd.getTextField().setText(format.format(defaultCutoffCD));
        ippconv.getTextField().setText(String.valueOf(defaultDE));
        JPanel pwf = new JPanel();
        JPanel pcd = new JPanel();
        JPanel pconv = new JPanel();
        pwf.add(ippwf);
        pcd.add(ippcd);
        pconv.add(ippconv);
        panel2.add(pwf);
        panel2.add(pcd);
        panel2.add(pconv);
        add(panel1);
        add(panel2);

        String fs = System.getProperty("file.separator");
        String convcheckscript = System.getProperty("pviewer.home") + fs
                + "scripts" + fs + "jobcontrol" + fs + "phase" + fs
                + "conv_check.bsh";
        if (!(new File(convcheckscript).exists())) {
            logger.error("couldn'find script : " + convcheckscript);
            logger.error("will not configure input for convergence check.");
            return;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * ciss.phase_viewer.plugins.projectmanipulator.phase.inputwizard.BasicWiz
     * #setProperties(java.util.HashMap)
     */
    public void setProperties(HashMap properties) {
        try {
            isMetallic = new Boolean(properties.get("metallic").toString())
                    .booleanValue();
            spin = new Boolean(properties.get("spin").toString())
                    .booleanValue();
            coords = (AtomCoords) properties.get("atomcoords");
        } catch (Exception exc) {
        }
        logger.debug("coords: " + coords);
        defaultNumBands = PhaseUtils.getDefaultNumBands(coords, isMetallic,
                spin);
        logger.debug("default num. bands: " + defaultNumBands);

        Cell cell = coords.getCell(0);
        defaultKmesh = PhaseUtils.getDefaultKmesh(cell, isMetallic);

        for (int i = 0; i < defaultKmesh.length; i++) {
            if (defaultKmesh[i] > 2)
                defaultKmesh[i] -= 2;
        }

        logger.debug("default kmesh: " + defaultKmesh[0] + ", "
                + defaultKmesh[1] + ", " + defaultKmesh[2]);

        boolean hasUSPP = PhaseUtils.hasUSPP(coords);
        defaultCutoffWF *= 0.7;
        if (hasUSPP) {
            defaultCutoffCD = defaultCutoffWF * 9.d;
        } else {
            defaultCutoffCD = defaultCutoffWF * 4.d;
        }
        logger.debug("default cutoff, wf: " + defaultCutoffWF + ", cd: "
                + defaultCutoffCD);
    }

}
