/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : FrameChase.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.mainpanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;

import org.apache.log4j.Logger;

import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

public class FrameChase extends JFrame implements ChaseFrame {
    private int mode = ChaseFrame.AUTOMATIC;

    private Dimension size;

    private FrameChase This;

    private boolean register = true;

    public FrameChase(String title, int mode, Dimension size) {
        super(title);
        this.mode = mode;
        this.size = size;
        this.This = this;
        initFrame();
    }

    public FrameChase(String title, Dimension size) {
        super(title);
        this.size = size;
        this.This = this;
        initFrame();
    }

    public FrameChase(String title, Dimension size, boolean register) {
        super(title);
        this.size = size;
        this.This = this;
        this.register = register;
        initFrame();
    }

    private void initFrame() {
        if (register) {
            Desktop4Frame.getDesktop().add(this);
        }
        Desktop4Frame.getDesktop().initialLocation(this, mode);
        int x = size.width;
        int y = size.height;

        GlobalProperties props = PropertiesManager
                .getGlobalProperties(PropertiesManager.PROPERTIES_WINDOW);
        String ident = FrameChase.class.getName();
        String title = getTitle();
        String winx = ident + "." + title + ".window_size_x";
        String winy = ident + "." + title + ".window_size_y";
        try {
            x = Integer.parseInt(props.getProperty(winx));
            y = Integer.parseInt(props.getProperty(winy));
        } catch (Exception exc) {
        }
        // System.out.println("x,y: "+x+" "+y);
        setSize(x, y);
        addComponentListener(new ComponentListenerFrameChase(this));
        addWindowListener(new WindowAdapterThis());
    }

    class WindowAdapterThis extends WindowAdapter {
        public void windowClosed(WindowEvent e) {
            Desktop4Frame.getDesktop().remove(This);
        }
    }

    public void dispose() {
        Desktop4Frame.getDesktop().remove(this);
        super.dispose();
    }

    public ChaseDesktop getDesktop() {
        return (ChaseDesktop) Desktop4Frame.getDesktop();
    }

    public void selected() {
    }

    public void selected(boolean init) {
    }

    public void unselect() {
    }

    public boolean isHeavyWeight() {
        return true;
    }

    public void saveState() {
        String ident = FrameChase.class.getName();
        String title = getTitle();
        String winx = ident + "." + title + ".window_size_x";
        String winy = ident + "." + title + ".window_size_y";
        GlobalProperties props = PropertiesManager
                .getGlobalProperties(PropertiesManager.PROPERTIES_WINDOW);
        props.setProperty(winx, String.valueOf(getSize().width));
        props.setProperty(winy, String.valueOf(getSize().height));
        props.storeProperty();
    }

}

class ComponentListenerFrameChase implements ComponentListener {
    private static Logger logger = Logger
            .getLogger(ComponentListenerFrameChase.class.getName());

    private Component component;

    public ComponentListenerFrameChase(Component component) {
        this.component = component;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
        GlobalProperties props = PropertiesManager
                .getGlobalProperties(PropertiesManager.PROPERTIES_PVIEWER);
        boolean boo = new Boolean(props.getProperty("heavy_check_bounds"))
                .booleanValue();
        if (boo) {
            checkBounds();
        }
    }

    public void componentResized(ComponentEvent e) {
        ((ChaseFrame) component).saveState();
    }

    public void componentShown(ComponentEvent e) {
    }

    private void checkBounds() {
        logger.debug("checking bounds ...");

        int locx = component.getLocation().x;
        int locy = component.getLocation().y;

        int locxmax = locx + component.getSize().width;
        int locymax = locy + component.getSize().height;

        boolean changed = false;

        if (locxmax > Desktop4Frame.screenWidth) {
            locx = Desktop4Frame.screenWidth - component.getSize().width;
            changed = true;
        }

        if (locymax > Desktop4Frame.screenHeight) {
            locy = Desktop4Frame.screenHeight - component.getSize().height;
            changed = true;
        }

        if (locx < 0) {
            locx = 0;
            changed = true;
        }

        if (locy < 0) {
            locy = 0;
            changed = true;
        }

        if (changed) {
            component.setLocation(locx, locy);
        }

    }
}
