/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/01/04, 13:58
!  AUTHOR(S): KOGA, Junichiro
!  File : MyElement.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.jdom;

import java.io.UnsupportedEncodingException;

import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.Namespace;

/**
 * JDOMElementUTF8set/get悤ɂ. ƎvJDOM̎dl゠܂ ܂Ȃ.
 * ꂭ炢Ƃė~. encode/decode\bh͂܂g.
 * 
 * @author
 */
public class MyElement extends org.jdom.Element {
    private static Logger logger = Logger.getLogger(MyElement.class.getName());

    /** Creates a new instance of ElementUTF8 */

    protected MyElement() {
        super();
    }

    public MyElement(java.lang.String name) {
        super(name);
    }

    public MyElement(java.lang.String name, Namespace namespace) {
        super(name, namespace);
    }

    public MyElement(java.lang.String name, java.lang.String uri) {
        super(name, uri);
    }

    public MyElement(java.lang.String name, java.lang.String prefix,
            java.lang.String uri) {
        super(name, prefix, uri);
    }

    public Element setText(String text) {
        String newtext = encode(text);
        return super.setText(newtext);
    }

    public String getText() {
        return decode(super.getText());
    }

    public String getTextTrim() {
        return decode(super.getTextTrim());
    }

    public String getChildTextNormalize(String name) {
        return decode(super.getChildTextNormalize(name));
    }

    public String getChildTextNormalize(String name, Namespace ns) {
        return decode(super.getChildTextNormalize(name, ns));
    }

    public String getChildTextTrim(String name) {
        return decode(super.getChildTextTrim(name));
    }

    public String getChildTextTrim(String name, Namespace ns) {
        return decode(getChildTextTrim(name, ns));
    }

    public String getChildText(String name, Namespace ns) {
        return decode(getChildText(name, ns));
    }

    /**
     * UTF8ɃGR[h.
     * 
     * @param text
     *            GR[h
     * @return UTF8ȕ
     */
    public static String encode(String text) {
        if (text == null) {
            return "";
        }
        String newtext = "";
        try {
            newtext = java.net.URLEncoder.encode(text, "UTF8");
        } catch (UnsupportedEncodingException uee) {
            logger.error("unsupported encoding...");
            newtext = "";
        }
        return newtext;
    }

    /**
     * UTF8fR[h
     * 
     * @param text
     *            UTF8ȕ
     * @return ʂ̕
     */
    public static String decode(String text) {
        if (text == null) {
            return "";
        }
        String ret = "";
        try {
            ret = java.net.URLDecoder.decode(text, "UTF8");
        } catch (UnsupportedEncodingException uee) {
            logger.error("unsupported encoding...");
            ret = "";
        }
        return ret;
    }

}
