/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/01/26, 20:51
!  AUTHOR(S): KOGA, Junichiro
!  File : FrameCombo.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.atomcoord.io;

import java.awt.event.ActionListener;

import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

/**
 * ut[Ivputility GUI; \Vv!
 * 
 * @author
 */
public class FrameCombo extends JPanel {
    static String FIRST_FRAME = "first frame";
    static String LAST_FRAME = "last frame";
    static String ALL_FRAME = "all";
    private String[] frameChoice = { FIRST_FRAME, LAST_FRAME, ALL_FRAME };
    private JComboBox combo;
    private Logger logger = Logger.getLogger(FrameCombo.class.getName());

    public FrameCombo() {
        super();
        init();
    }

    private void init() {
        setBorder(new TitledBorder("select frame"));
        combo = new JComboBox(frameChoice);
        combo.setEditable(true);
        add(combo);
    }

    void addActionListener(ActionListener listener) {
        combo.addActionListener(listener);
    }

    String getChoice() {
        return combo.getSelectedItem().toString();
    }

    /**
     * u^[Qbgt[vԂ. , St[̏ꍇɌ-1Ԃ.
     * 
     * @param numFrame
     *            t[
     * @return ^[Qbgt[
     */
    int getTargetFrame(int numFrame) {
        int targetFrame = 0;
        String frame = getChoice();
        if (frame.equals(FrameCombo.ALL_FRAME)) {
            return -1;
        }
        if (frame.equals(FrameCombo.LAST_FRAME)) {
            return numFrame - 1;
        } else if (frame.equals(FrameCombo.FIRST_FRAME)) {
            return 0;
        } else {
            try {
                targetFrame = Integer.parseInt(frame.trim());
            } catch (NumberFormatException npe) {
                targetFrame = 0;
            } catch (NullPointerException npe) {
                targetFrame = 0;
            }
            if (targetFrame >= numFrame) {
                targetFrame = numFrame - 1;
            }
            return targetFrame;
        }
    }
}
