/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

final class SkinArrowButton
extends JButton
implements SwingConstants {
    private int direction;
    private Skin skin = SkinLookAndFeel.getSkin();

    public SkinArrowButton(int direction) {
        this.setRequestFocusEnabled(false);
        this.setDirection(direction);
        this.setBackground(UIManager.getColor("control"));
    }

    public void setDirection(int dir) {
        this.direction = dir;
    }

    public int getDirection() {
        return this.direction;
    }

    public Dimension getPreferredSize() {
        return this.skin.getScrollbar().getArrowPreferredSize(this.direction);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paint(Graphics g) {
        this.skin.getScrollbar().paintArrow(g, this, this.direction);
    }
}

