/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataSource;
import jas.hist.DateTransformationConverter;
import jas.hist.Handle;
import jas.hist.HasHandles;
import jas.plot.CoordinateTransformation;
import jas.plot.DateCoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.Overlay;
import jas.plot.OverlayContainer;
import jas.plot.PlotGraphics;
import jas.plot.PrintHelper;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public abstract class OverlayWithHandles
implements Overlay,
MouseListener,
MouseMotionListener {
    private Cursor defaultCursor = null;
    private static MouseEvent mouseEvent = null;
    private static boolean changeCursor;
    private boolean handlesPainted = false;
    private static final double handleSize = 2.5;
    private HandleWrapper[] handles = null;
    private HandleWrapper currentHandle = null;
    private HandleWrapper capturedHandle = null;
    private HasHandles hasHandles;
    protected OverlayContainer container;

    protected OverlayWithHandles(DataSource dataSource) {
        if (dataSource instanceof HasHandles) {
            this.hasHandles = (HasHandles)((Object)dataSource);
        }
    }

    public void paint(PlotGraphics plotGraphics) {
        if (this.handles != null && !PrintHelper.isPrinting()) {
            CoordinateTransformation coordinateTransformation = this.container.getXTransformation();
            CoordinateTransformation coordinateTransformation2 = this.container.getYTransformation();
            plotGraphics.clearTransformation();
            for (int i = 0; i < this.handles.length; ++i) {
                this.handles[i].paint(plotGraphics, coordinateTransformation, coordinateTransformation2);
            }
        }
    }

    void paintHandles(MouseEvent mouseEvent) {
        this.handlesPainted = true;
        CoordinateTransformation coordinateTransformation = this.container.getXTransformation();
        DoubleCoordinateTransformation doubleCoordinateTransformation = coordinateTransformation instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)coordinateTransformation) : (DoubleCoordinateTransformation)coordinateTransformation;
        CoordinateTransformation coordinateTransformation2 = this.container.getYTransformation();
        DoubleCoordinateTransformation doubleCoordinateTransformation2 = coordinateTransformation2 instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)coordinateTransformation2) : (DoubleCoordinateTransformation)coordinateTransformation2;
        Handle[] handleArray = this.hasHandles.getHandles(doubleCoordinateTransformation.getPlotMin(), doubleCoordinateTransformation.getPlotMax(), doubleCoordinateTransformation2.getPlotMin(), doubleCoordinateTransformation2.getPlotMax());
        this.handles = new HandleWrapper[handleArray.length];
        for (int i = 0; i < this.handles.length; ++i) {
            this.handles[i] = new HandleWrapper(handleArray[i]);
        }
        this.container.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.paintHandles(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.handles = null;
        this.container.repaint();
        this.handlesPainted = false;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.handlesPainted) {
            this.paintHandles(mouseEvent);
        }
        if (OverlayWithHandles.mouseEvent == null || OverlayWithHandles.mouseEvent != mouseEvent) {
            OverlayWithHandles.mouseEvent = mouseEvent;
            changeCursor = true;
        }
        if (this.defaultCursor == null) {
            this.defaultCursor = mouseEvent.getComponent().getCursor();
        }
        Point point = mouseEvent.getPoint();
        if (this.handles != null) {
            for (int i = 0; i < this.handles.length; ++i) {
                if (!this.handles[i].contains(point)) continue;
                Cursor cursor = this.handles[i].cursor();
                if (cursor != null) {
                    mouseEvent.getComponent().setCursor(cursor);
                    changeCursor = false;
                }
                this.setCurrentHandle(this.handles[i]);
                return;
            }
            if (mouseEvent.getComponent().getCursor() != this.defaultCursor && changeCursor) {
                mouseEvent.getComponent().setCursor(this.defaultCursor);
            }
        }
        this.setCurrentHandle(null);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.currentHandle != null) {
            this.captureHandle(this.currentHandle);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.captureHandle(null);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.capturedHandle != null) {
            this.capturedHandle.moveTo(mouseEvent.getPoint());
            this.container.repaint();
        }
    }

    public void containerNotify(OverlayContainer overlayContainer) {
        if (this.container != null) {
            this.container.removeMouseListener(this);
            this.container.removeMouseMotionListener(this);
        }
        this.container = overlayContainer;
        if (overlayContainer != null && this.hasHandles != null) {
            overlayContainer.addMouseListener(this);
            overlayContainer.addMouseMotionListener(this);
        }
    }

    private void setCurrentHandle(HandleWrapper handleWrapper) {
        if (this.currentHandle != handleWrapper) {
            this.currentHandle = handleWrapper;
            this.container.repaint();
        }
    }

    private void captureHandle(HandleWrapper handleWrapper) {
        if (this.capturedHandle != handleWrapper) {
            this.capturedHandle = handleWrapper;
            this.container.repaint();
        }
    }

    private class HandleWrapper {
        private Handle handle;

        HandleWrapper(Handle handle) {
            this.handle = handle;
        }

        void paint(PlotGraphics plotGraphics, CoordinateTransformation coordinateTransformation, CoordinateTransformation coordinateTransformation2) {
            DoubleCoordinateTransformation doubleCoordinateTransformation = coordinateTransformation instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)coordinateTransformation) : (DoubleCoordinateTransformation)coordinateTransformation;
            DoubleCoordinateTransformation doubleCoordinateTransformation2 = coordinateTransformation2 instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)coordinateTransformation2) : (DoubleCoordinateTransformation)coordinateTransformation2;
            double d = doubleCoordinateTransformation.convert(this.handle.getX());
            double d2 = doubleCoordinateTransformation2.convert(this.handle.getY());
            plotGraphics.setColor(this == OverlayWithHandles.this.currentHandle ? Color.red : Color.black);
            plotGraphics.fillRect(d - 2.5, d2 - 2.5, d + 2.5, d2 + 2.5);
        }

        boolean contains(Point point) {
            CoordinateTransformation coordinateTransformation = OverlayWithHandles.this.container.getXTransformation();
            CoordinateTransformation coordinateTransformation2 = OverlayWithHandles.this.container.getYTransformation();
            DoubleCoordinateTransformation doubleCoordinateTransformation = coordinateTransformation instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)coordinateTransformation) : (DoubleCoordinateTransformation)coordinateTransformation;
            DoubleCoordinateTransformation doubleCoordinateTransformation2 = coordinateTransformation2 instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)coordinateTransformation2) : (DoubleCoordinateTransformation)coordinateTransformation2;
            double d = doubleCoordinateTransformation.convert(this.handle.getX()) - 2.5;
            double d2 = doubleCoordinateTransformation2.convert(this.handle.getY()) - 2.5;
            return (double)point.x >= d && (double)point.x <= d + 5.0 && (double)point.y >= d2 && (double)point.y > d2 && (double)point.y <= d2 + 5.0;
        }

        void moveTo(Point point) {
            CoordinateTransformation coordinateTransformation = OverlayWithHandles.this.container.getXTransformation();
            CoordinateTransformation coordinateTransformation2 = OverlayWithHandles.this.container.getYTransformation();
            DoubleCoordinateTransformation doubleCoordinateTransformation = coordinateTransformation instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)coordinateTransformation) : (DoubleCoordinateTransformation)coordinateTransformation;
            DoubleCoordinateTransformation doubleCoordinateTransformation2 = coordinateTransformation2 instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)coordinateTransformation2) : (DoubleCoordinateTransformation)coordinateTransformation2;
            this.handle.moveTo(doubleCoordinateTransformation.unConvert(point.x), doubleCoordinateTransformation2.unConvert(point.y));
        }

        Cursor cursor() {
            return this.handle.cursor();
        }
    }
}

