/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.field.MFInt32;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.field.SFMatrix;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.AppearanceNode;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.ComposedGeometryNode;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NormalNode;
import org.cybergarage.x3d.node.TextureCoordinateNode;
import org.cybergarage.x3d.util.BoundingBox;

public class IndexedFaceSetNode
extends ComposedGeometryNode {
    private static final String convexFieldName = "convex";
    private static final String creaseAngleFieldName = "creaseAngle";
    private static final String coordIndexFieldName = "coordIndex";
    private static final String texCoordIndexFieldName = "texCoordIndex";
    private static final String colorIndexFieldName = "colorIndex";
    private static final String normalIndexFieldName = "normalIndex";
    private static final String coordIndexEventInName = "coordIndex";
    private static final String texCoordIndexEventInName = "texCoordIndex";
    private static final String colorIndexEventInName = "colorIndex";
    private static final String normalIndexEventInName = "normalIndex";
    private SFBool convexField;
    private SFFloat creaseAngleField;
    private MFInt32 coordIndexField;
    private MFInt32 texCoordIndexField;
    private MFInt32 colorIndexField;
    private MFInt32 normalIndexField;
    private MFInt32 setCoordIndexField;
    private MFInt32 setTexCoordIndexField;
    private MFInt32 setColorIndexField;
    private MFInt32 setNormalIndexField;

    public IndexedFaceSetNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.INDEXEDFACESET);
        this.convexField = new SFBool(true);
        this.convexField.setName(convexFieldName);
        this.addField(this.convexField);
        this.creaseAngleField = new SFFloat(0.0f);
        this.creaseAngleField.setName(creaseAngleFieldName);
        this.addField(this.creaseAngleField);
        this.coordIndexField = new MFInt32();
        this.coordIndexField.setName("coordIndex");
        this.addField(this.coordIndexField);
        this.texCoordIndexField = new MFInt32();
        this.texCoordIndexField.setName("texCoordIndex");
        this.addField(this.texCoordIndexField);
        this.colorIndexField = new MFInt32();
        this.colorIndexField.setName("colorIndex");
        this.addField(this.colorIndexField);
        this.normalIndexField = new MFInt32();
        this.normalIndexField.setName("normalIndex");
        this.addField(this.normalIndexField);
        this.setCoordIndexField = new MFInt32();
        this.setCoordIndexField.setName("coordIndex");
        this.addEventIn(this.setCoordIndexField);
        this.setTexCoordIndexField = new MFInt32();
        this.setTexCoordIndexField.setName("texCoordIndex");
        this.addEventIn(this.setTexCoordIndexField);
        this.setColorIndexField = new MFInt32();
        this.setColorIndexField.setName("colorIndex");
        this.addEventIn(this.setColorIndexField);
        this.setNormalIndexField = new MFInt32();
        this.setNormalIndexField.setName("normalIndex");
        this.addEventIn(this.setNormalIndexField);
    }

    public IndexedFaceSetNode(IndexedFaceSetNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFBool getConvexField() {
        if (!this.isInstanceNode()) {
            return this.convexField;
        }
        return (SFBool)this.getField(convexFieldName);
    }

    public void setConvex(boolean value) {
        this.getConvexField().setValue(value);
    }

    public void setConvex(String value) {
        this.getConvexField().setValue(value);
    }

    public boolean getConvex() {
        return this.getConvexField().getValue();
    }

    public boolean isConvex() {
        return this.getConvex();
    }

    public SFFloat getCreaseAngleField() {
        if (!this.isInstanceNode()) {
            return this.creaseAngleField;
        }
        return (SFFloat)this.getField(creaseAngleFieldName);
    }

    public void setCreaseAngle(float value) {
        this.getCreaseAngleField().setValue(value);
    }

    public void setCreaseAngle(String value) {
        this.getCreaseAngleField().setValue(value);
    }

    public float getCreaseAngle() {
        return this.getCreaseAngleField().getValue();
    }

    public MFInt32 getCoordIndexField() {
        if (!this.isInstanceNode()) {
            return this.coordIndexField;
        }
        return (MFInt32)this.getField("coordIndex");
    }

    public void addCoordIndex(int value) {
        this.getCoordIndexField().addValue(value);
    }

    public int getNCoordIndices() {
        return this.getCoordIndexField().getSize();
    }

    public void setCoordIndex(int index, int value) {
        this.getCoordIndexField().set1Value(index, value);
    }

    public void setCoordIndices(String value) {
        this.getCoordIndexField().setValues(value);
    }

    public int getCoordIndex(int index) {
        return this.getCoordIndexField().get1Value(index);
    }

    public void removeCoordIndex(int index) {
        this.getCoordIndexField().removeValue(index);
    }

    public int getNTriangleCoordIndices() {
        return this.getCoordIndexField().getNTriangleIndices();
    }

    public MFInt32 getTexCoordIndexField() {
        if (!this.isInstanceNode()) {
            return this.texCoordIndexField;
        }
        return (MFInt32)this.getField("texCoordIndex");
    }

    public void addTexCoordIndex(int value) {
        this.getTexCoordIndexField().addValue(value);
    }

    public int getNTexCoordIndices() {
        return this.getTexCoordIndexField().getSize();
    }

    public void setTexCoordIndex(int index, int value) {
        this.getTexCoordIndexField().set1Value(index, value);
    }

    public void setTexCoordIndices(String value) {
        this.getTexCoordIndexField().setValues(value);
    }

    public void setTexCoordIndices(String[] value) {
        this.getTexCoordIndexField().setValues(value);
    }

    public int getTexCoordIndex(int index) {
        return this.getTexCoordIndexField().get1Value(index);
    }

    public void removeTexCoordIndex(int index) {
        this.getTexCoordIndexField().removeValue(index);
    }

    public MFInt32 getColorIndexField() {
        if (!this.isInstanceNode()) {
            return this.colorIndexField;
        }
        return (MFInt32)this.getField("colorIndex");
    }

    public void addColorIndex(int value) {
        this.getColorIndexField().addValue(value);
    }

    public int getNColorIndices() {
        return this.getColorIndexField().getSize();
    }

    public void setColorIndex(int index, int value) {
        this.getColorIndexField().set1Value(index, value);
    }

    public void setColorIndices(String value) {
        this.getColorIndexField().setValues(value);
    }

    public int getColorIndex(int index) {
        return this.getColorIndexField().get1Value(index);
    }

    public void removeColorIndex(int index) {
        this.getColorIndexField().removeValue(index);
    }

    public MFInt32 getNormalIndexField() {
        if (!this.isInstanceNode()) {
            return this.normalIndexField;
        }
        return (MFInt32)this.getField("normalIndex");
    }

    public void addNormalIndex(int value) {
        this.getNormalIndexField().addValue(value);
    }

    public int getNNormalIndices() {
        return this.getNormalIndexField().getSize();
    }

    public void setNormalIndex(int index, int value) {
        this.getNormalIndexField().set1Value(index, value);
    }

    public void setNormalIndices(String value) {
        this.getNormalIndexField().setValues(value);
    }

    public int getNormalIndex(int index) {
        return this.getNormalIndexField().get1Value(index);
    }

    public void removeNormalIndex(int index) {
        this.getNormalIndexField().removeValue(index);
    }

    public MFInt32 getSetCoordIndexField() {
        if (!this.isInstanceNode()) {
            return this.setCoordIndexField;
        }
        return (MFInt32)this.getEventIn("coordIndex");
    }

    public void addSetCoordIndex(int value) {
        this.getSetCoordIndexField().addValue(value);
    }

    public int getNSetCoordIndices() {
        return this.getSetCoordIndexField().getSize();
    }

    public void setSetCoordIndex(int index, int value) {
        this.getSetCoordIndexField().set1Value(index, value);
    }

    public void setSetCoordIndices(String value) {
        this.getSetCoordIndexField().setValues(value);
    }

    public int getSetCoordIndex(int index) {
        return this.getSetCoordIndexField().get1Value(index);
    }

    public void removeSetCoordIndex(int index) {
        this.getSetCoordIndexField().removeValue(index);
    }

    public int getNSetTriangleCoordIndices() {
        return this.getSetCoordIndexField().getNTriangleIndices();
    }

    public MFInt32 getSetTexCoordIndexField() {
        if (!this.isInstanceNode()) {
            return this.setTexCoordIndexField;
        }
        return (MFInt32)this.getEventIn("texCoordIndex");
    }

    public void addSetTexCoordIndex(int value) {
        this.getSetTexCoordIndexField().addValue(value);
    }

    public int getNSetTexCoordIndices() {
        return this.getSetTexCoordIndexField().getSize();
    }

    public void setSetTexCoordIndex(int index, int value) {
        this.getSetTexCoordIndexField().set1Value(index, value);
    }

    public void setSetTexCoordIndices(String value) {
        this.getSetTexCoordIndexField().setValues(value);
    }

    public int getSetTexCoordIndex(int index) {
        return this.getSetTexCoordIndexField().get1Value(index);
    }

    public void removeSetTexCoordIndex(int index) {
        this.getSetTexCoordIndexField().removeValue(index);
    }

    public MFInt32 getSetColorIndexField() {
        if (!this.isInstanceNode()) {
            return this.setColorIndexField;
        }
        return (MFInt32)this.getEventIn("colorIndex");
    }

    public void addSetColorIndex(int value) {
        this.getSetColorIndexField().addValue(value);
    }

    public int getNSetColorIndices() {
        return this.getSetColorIndexField().getSize();
    }

    public void setSetColorIndex(int index, int value) {
        this.getSetColorIndexField().set1Value(index, value);
    }

    public void setSetColorIndices(String value) {
        this.getSetColorIndexField().setValues(value);
    }

    public int getSetColorIndex(int index) {
        return this.getSetColorIndexField().get1Value(index);
    }

    public void removeSetColorIndex(int index) {
        this.getSetColorIndexField().removeValue(index);
    }

    public MFInt32 getSetNormalIndexField() {
        if (!this.isInstanceNode()) {
            return this.setNormalIndexField;
        }
        return (MFInt32)this.getEventIn("normalIndex");
    }

    public void addSetNormalIndex(int value) {
        this.getSetNormalIndexField().addValue(value);
    }

    public int getNSetNormalIndices() {
        return this.getSetNormalIndexField().getSize();
    }

    public void setNSetormalIndex(int index, int value) {
        this.getSetNormalIndexField().set1Value(index, value);
    }

    public void setNSetormalIndices(String value) {
        this.getSetNormalIndexField().setValues(value);
    }

    public int getNSetormalIndex(int index) {
        return this.getSetNormalIndexField().get1Value(index);
    }

    public void removeSetNormalIndex(int index) {
        this.getSetNormalIndexField().removeValue(index);
    }

    public boolean isChildNodeType(Node node) {
        return node.isColorNode() || node.isCoordinateNode() || node.isNormalNode() || node.isTextureCoordinateNode();
    }

    public void initialize() {
        super.initialize();
        SceneGraph sg = this.getSceneGraph();
        if (sg == null) {
            return;
        }
        if (!this.isInitialized()) {
            AppearanceNode appearance;
            Node parentNode;
            if (sg.getOption(2)) {
                this.generateNormals();
            }
            if (sg.getOption(4) && (parentNode = this.getParentNode()) != null && (appearance = parentNode.getAppearanceNodes()) != null && appearance.getTextureNode() != null) {
                this.generateTextureCoordinate();
            }
            this.updateBoundingBox();
            this.setInitializationFlag(true);
        }
        this.updateColorField();
        this.updateCoordField();
        this.updateNormalField();
        this.updateTexCoordField();
    }

    public void uninitialize() {
    }

    public void update() {
    }

    public void outputContext(PrintWriter printStream, String indentString) {
        TextureCoordinateNode texCoord;
        ColorNode color;
        NormalNode normal;
        SFBool convex = this.getConvexField();
        SFBool solid = this.getSolidField();
        SFBool normalPerVertex = this.getNormalPerVertexField();
        SFBool colorPerVertex = this.getColorPerVertexField();
        SFBool ccw = this.getCCWField();
        printStream.println(indentString + "\t" + "ccw " + ccw);
        printStream.println(indentString + "\t" + "colorPerVertex " + colorPerVertex);
        printStream.println(indentString + "\t" + "normalPerVertex " + normalPerVertex);
        printStream.println(indentString + "\t" + "convex " + convex);
        printStream.println(indentString + "\t" + "creaseAngle " + this.getCreaseAngle());
        printStream.println(indentString + "\t" + "solid " + solid);
        CoordinateNode coord = this.getCoordinateNodes();
        if (coord != null && 0 < coord.getNPoints()) {
            if (!coord.isInstanceNode()) {
                String nodeName = coord.getName();
                if (nodeName != null && 0 < nodeName.length()) {
                    printStream.println(indentString + "\t" + "coord DEF " + coord.getName() + " Coordinate {");
                } else {
                    printStream.println(indentString + "\t" + "coord Coordinate {");
                }
                coord.outputContext(printStream, indentString + "\t");
                printStream.println(indentString + "\t" + "}");
            } else {
                printStream.println(indentString + "\t" + "coord USE " + coord.getName());
            }
        }
        if ((normal = this.getNormalNodes()) != null && 0 < normal.getNVectors()) {
            if (!normal.isInstanceNode()) {
                String nodeName = normal.getName();
                if (nodeName != null && 0 < nodeName.length()) {
                    printStream.println(indentString + "\t" + "normal DEF " + normal.getName() + " Normal {");
                } else {
                    printStream.println(indentString + "\t" + "normal Normal {");
                }
                normal.outputContext(printStream, indentString + "\t");
                printStream.println(indentString + "\t" + "}");
            } else {
                printStream.println(indentString + "\t" + "normal USE " + normal.getName());
            }
        }
        if ((color = this.getColorNodes()) != null && 0 < color.getNColors()) {
            if (!color.isInstanceNode()) {
                String nodeName = color.getName();
                if (nodeName != null && 0 < nodeName.length()) {
                    printStream.println(indentString + "\t" + "color DEF " + color.getName() + " Color {");
                } else {
                    printStream.println(indentString + "\t" + "color Color {");
                }
                color.outputContext(printStream, indentString + "\t");
                printStream.println(indentString + "\t" + "}");
            } else {
                printStream.println(indentString + "\t" + "color USE " + color.getName());
            }
        }
        if ((texCoord = this.getTextureCoordinateNodes()) != null && 0 < texCoord.getNPoints()) {
            if (!texCoord.isInstanceNode()) {
                String nodeName = texCoord.getName();
                if (nodeName != null && 0 < nodeName.length()) {
                    printStream.println(indentString + "\t" + "texCoord DEF " + texCoord.getName() + " TextureCoordinate {");
                } else {
                    printStream.println(indentString + "\t" + "texCoord TextureCoordinate {");
                }
                texCoord.outputContext(printStream, indentString + "\t");
                printStream.println(indentString + "\t" + "}");
            } else {
                printStream.println(indentString + "\t" + "texCoord USE " + texCoord.getName());
            }
        }
        if (0 < this.getNCoordIndices()) {
            MFInt32 coordIndex = this.getCoordIndexField();
            printStream.println(indentString + "\t" + "coordIndex [");
            coordIndex.outputIndex(printStream, indentString + "\t\t");
            printStream.println(indentString + "\t" + "]");
        }
        if (0 < this.getNColorIndices()) {
            MFInt32 colorIndex = this.getColorIndexField();
            printStream.println(indentString + "\t" + "colorIndex [");
            colorIndex.outputIndex(printStream, indentString + "\t\t");
            printStream.println(indentString + "\t" + "]");
        }
        if (0 < this.getNNormalIndices()) {
            MFInt32 normalIndex = this.getNormalIndexField();
            printStream.println(indentString + "\t" + "normalIndex [");
            normalIndex.outputIndex(printStream, indentString + "\t\t");
            printStream.println(indentString + "\t" + "]");
        }
        if (0 < this.getNTexCoordIndices()) {
            MFInt32 texCoordIndex = this.getTexCoordIndexField();
            printStream.println(indentString + "\t" + "texCoordIndex [");
            texCoordIndex.outputIndex(printStream, indentString + "\t\t");
            printStream.println(indentString + "\t" + "]");
        }
    }

    public void getNormalFromVertices(float[][] vpoint, float[] vector) {
        vector[0] = (vpoint[1][1] - vpoint[0][1]) * (vpoint[2][2] - vpoint[1][2]) - (vpoint[1][2] - vpoint[0][2]) * (vpoint[2][1] - vpoint[1][1]);
        vector[1] = (vpoint[1][2] - vpoint[0][2]) * (vpoint[2][0] - vpoint[1][0]) - (vpoint[1][0] - vpoint[0][0]) * (vpoint[2][2] - vpoint[1][2]);
        vector[2] = (vpoint[1][0] - vpoint[0][0]) * (vpoint[2][1] - vpoint[1][1]) - (vpoint[1][1] - vpoint[0][1]) * (vpoint[2][0] - vpoint[1][0]);
        float mag = (float)Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
        vector[0] = vector[0] / mag;
        vector[1] = vector[1] / mag;
        vector[2] = vector[2] / mag;
    }

    public boolean generateNormals() {
        NormalNode normal = this.getNormalNodes();
        if (normal != null) {
            return false;
        }
        CoordinateNode coordinate = this.getCoordinateNodes();
        if (coordinate == null) {
            return false;
        }
        normal = new NormalNode();
        int nPolygon = 0;
        int nVertex = 0;
        float[][] vpoint = new float[3][3];
        float[] vector = new float[3];
        int nCoordIndexes = this.getNCoordIndices();
        for (int nCoordIndex = 0; nCoordIndex < nCoordIndexes; ++nCoordIndex) {
            int coordIndex = this.getCoordIndex(nCoordIndex);
            if (coordIndex != -1) {
                if (nVertex < 3) {
                    coordinate.getPoint(coordIndex, vpoint[nVertex]);
                }
                ++nVertex;
                continue;
            }
            this.getNormalFromVertices(vpoint, vector);
            normal.addVector(vector);
            nVertex = 0;
            ++nPolygon;
        }
        this.addChildNode(normal);
        this.setNormalPerVertex(false);
        return true;
    }

    public void setExtents(SFVec3f maxExtents, SFVec3f minExtents, float[] vpoint) {
        if (maxExtents.getX() < vpoint[0]) {
            maxExtents.setX(vpoint[0]);
        }
        if (maxExtents.getY() < vpoint[1]) {
            maxExtents.setY(vpoint[1]);
        }
        if (maxExtents.getZ() < vpoint[2]) {
            maxExtents.setZ(vpoint[2]);
        }
        if (minExtents.getX() > vpoint[0]) {
            minExtents.setX(vpoint[0]);
        }
        if (minExtents.getY() > vpoint[1]) {
            minExtents.setY(vpoint[1]);
        }
        if (minExtents.getZ() > vpoint[2]) {
            minExtents.setZ(vpoint[2]);
        }
    }

    public int getNPolygons() {
        CoordinateNode coordinate = this.getCoordinateNodes();
        if (coordinate == null) {
            return 0;
        }
        int nCoordIndex = 0;
        for (int n = 0; n < this.getNCoordIndices(); ++n) {
            if (this.getCoordIndex(n) != -1 && n != this.getNCoordIndices() - 1) continue;
            ++nCoordIndex;
        }
        return nCoordIndex;
    }

    public void getRotateMatrixFromNormal(float[] normal, SFMatrix matrix) {
        SFMatrix mx = new SFMatrix();
        SFMatrix my = new SFMatrix();
        float[][] mxValue = new float[4][4];
        float[][] myValue = new float[4][4];
        mx.getValue(mxValue);
        my.getValue(myValue);
        float d = (float)Math.sqrt(normal[1] * normal[1] + normal[2] * normal[2]);
        if (d != 0.0f) {
            float cosa = normal[2] / d;
            float sina = normal[1] / d;
            mxValue[0][0] = 1.0f;
            mxValue[0][1] = 0.0f;
            mxValue[0][2] = 0.0f;
            mxValue[1][0] = 0.0f;
            mxValue[1][1] = cosa;
            mxValue[1][2] = sina;
            mxValue[2][0] = 0.0f;
            mxValue[2][1] = -sina;
            mxValue[2][2] = cosa;
        }
        float cosb = d;
        float sinb = normal[0];
        myValue[0][0] = cosb;
        myValue[0][1] = 0.0f;
        myValue[0][2] = sinb;
        myValue[1][0] = 0.0f;
        myValue[1][1] = 1.0f;
        myValue[1][2] = 0.0f;
        myValue[2][0] = -sinb;
        myValue[2][1] = 0.0f;
        myValue[2][2] = cosb;
        mx.setValue(mxValue);
        my.setValue(myValue);
        matrix.init();
        matrix.add(my);
        matrix.add(mx);
    }

    public boolean generateTextureCoordinate() {
        TextureCoordinateNode texCoord = this.getTextureCoordinateNodes();
        if (texCoord != null) {
            return false;
        }
        CoordinateNode coordinate = this.getCoordinateNodes();
        if (coordinate == null) {
            return false;
        }
        texCoord = new TextureCoordinateNode();
        int nPolygon = this.getNPolygons();
        float[][] normal = new float[nPolygon][3];
        SFVec3f[] center = new SFVec3f[nPolygon];
        SFVec3f[] maxExtents = new SFVec3f[nPolygon];
        SFVec3f[] minExtents = new SFVec3f[nPolygon];
        for (int n = 0; n < nPolygon; ++n) {
            center[n] = new SFVec3f();
            maxExtents[n] = new SFVec3f();
            minExtents[n] = new SFVec3f();
        }
        float[][] vpoint = new float[3][3];
        float[] coord = new float[3];
        int vertexn = 0;
        boolean bPolygonBegin = true;
        int polyn = 0;
        int nCoordIndexes = this.getNCoordIndices();
        for (int n = 0; n < nCoordIndexes; ++n) {
            int coordIndex = this.getCoordIndex(n);
            if (coordIndex != -1) {
                if (vertexn < 3) {
                    coordinate.getPoint(coordIndex, vpoint[vertexn]);
                }
                float[] point = new float[3];
                coordinate.getPoint(coordIndex, point);
                if (bPolygonBegin) {
                    maxExtents[polyn].setValue(point);
                    minExtents[polyn].setValue(point);
                    center[polyn].setValue(point);
                    bPolygonBegin = false;
                } else {
                    this.setExtents(maxExtents[polyn], minExtents[polyn], point);
                    center[polyn].add(point);
                }
                ++vertexn;
                continue;
            }
            this.getNormalFromVertices(vpoint, normal[polyn]);
            center[polyn].scale(1.0f / (float)vertexn);
            maxExtents[polyn].sub(center[polyn]);
            minExtents[polyn].sub(center[polyn]);
            vertexn = 0;
            bPolygonBegin = true;
            ++polyn;
        }
        SFMatrix matrix = new SFMatrix();
        bPolygonBegin = true;
        polyn = 0;
        float ylength = 0.0f;
        float xlength = 0.0f;
        float maxy = 0.0f;
        float maxx = 0.0f;
        float miny = 0.0f;
        float minx = 0.0f;
        for (int n = 0; n < nCoordIndexes; ++n) {
            int coordIndex = this.getCoordIndex(n);
            if (coordIndex != -1) {
                if (bPolygonBegin) {
                    this.getRotateMatrixFromNormal(normal[polyn], matrix);
                    matrix.multi(minExtents[polyn]);
                    matrix.multi(maxExtents[polyn]);
                    minx = minExtents[polyn].getX();
                    miny = minExtents[polyn].getY();
                    maxx = maxExtents[polyn].getX();
                    maxy = maxExtents[polyn].getY();
                    xlength = Math.abs(maxExtents[polyn].getX() - minExtents[polyn].getX());
                    ylength = Math.abs(maxExtents[polyn].getY() - minExtents[polyn].getY());
                    if (xlength == 0.0f || ylength == 0.0f) {
                        return false;
                    }
                    bPolygonBegin = false;
                }
                coordinate.getPoint(coordIndex, coord);
                coord[0] = coord[0] - center[polyn].getX();
                coord[1] = coord[1] - center[polyn].getY();
                coord[2] = coord[2] - center[polyn].getZ();
                matrix.multi(coord);
                coord[0] = Math.abs(coord[0] - minx) / xlength;
                coord[1] = Math.abs(coord[1] - miny) / ylength;
                texCoord.addPoint(coord);
                continue;
            }
            bPolygonBegin = true;
            ++polyn;
        }
        this.addChildNode(texCoord);
        return true;
    }

    public void updateBoundingBox() {
        if (this.isInitialized()) {
            return;
        }
        CoordinateNode coordinate = this.getCoordinateNodes();
        if (coordinate == null) {
            this.setBoundingBoxCenter(0.0f, 0.0f, 0.0f);
            this.setBoundingBoxSize(-1.0f, -1.0f, -1.0f);
            return;
        }
        BoundingBox bbox = new BoundingBox();
        float[] point = new float[3];
        int nCoordinatePoint = coordinate.getNPoints();
        for (int n = 0; n < nCoordinatePoint; ++n) {
            coordinate.getPoint(n, point);
            bbox.addPoint(point);
        }
        this.setBoundingBoxCenter(bbox.getCenter());
        this.setBoundingBoxSize(bbox.getSize());
    }
}

