/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.mainpanel.Desk;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.vecmath.Color3f;
import org.apache.log4j.Logger;

public class ColorButton
extends JButton {
    private Logger logger = Logger.getLogger(ColorButton.class.getName());

    public ColorButton(String text, Color color) {
        super(text);
        this.setBackground(color);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JColorChooser colorchooser = new JColorChooser();
                Color col = ColorButton.this.getBackground();
                Color color = JColorChooser.showDialog(Desk.getDesktop(), "Choose", col);
                if (color != null) {
                    ColorButton.this.setBackground(color);
                    ColorButton.this.setForeground(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                }
            }
        });
    }

    public ColorButton(String text) {
        super(text);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JColorChooser colorchooser = new JColorChooser();
                Color col = ColorButton.this.getBackground();
                Color color = JColorChooser.showDialog(null, "Choose", col);
                if (color != null) {
                    ColorButton.this.setBackground(color);
                    ColorButton.this.setForeground(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                }
            }
        });
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Color getColor() {
        return this.getBackground();
    }

    public Color3f getColor3f() {
        Color color = this.getBackground();
        return new Color3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setColor3f(Color3f color3f) {
        this.setColorf(color3f.x, color3f.y, color3f.z);
    }

    public void setColorf(float r, float g, float b2) {
        this.setBackground(new Color(r, g, b2));
        this.setForeground(new Color(1.0f - r, 1.0f - g, 1.0f - b2));
    }
}

