/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.jdom;

import ciss.phase_viewer.jdom.MyElement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLUtils {
    private static Logger logger = Logger.getLogger(XMLUtils.class.getName());

    private XMLUtils() {
    }

    public static Element getContent(Document doc, String ident) {
        List list = null;
        try {
            list = doc.getContent();
        }
        catch (IllegalStateException exc) {
            return null;
        }
        if (list == null || list.size() == 0) {
            Element host = new Element(ident);
            doc.addContent(host);
            return host;
        }
        for (int i = 0; i < list.size(); ++i) {
            Element elem;
            Object obj = list.get(i);
            if (!(obj instanceof Element) || !(elem = (Element)obj).getName().equals(ident)) continue;
            return elem;
        }
        Element host = new Element(ident);
        doc.addContent(host);
        return host;
    }

    public static Document getDocumentFromURL(URL url) {
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        if (url == null) {
            return null;
        }
        try {
            doc = builder.build(url);
        }
        catch (JDOMException jde) {
            logger.error("failed to parse " + url);
            logger.error("unrecoverable error.");
            jde.printStackTrace();
            return null;
        }
        catch (IOException ioe) {
            logger.error("failed to parse " + url);
            logger.error("unrecoverable error.");
            ioe.printStackTrace();
            return null;
        }
        return doc;
    }

    public static Document getDocumentFromFile(File file) {
        Document doc = null;
        if (file == null || !file.exists()) {
            return null;
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(file);
        }
        catch (Exception jde) {
            logger.error("failed to parse " + file);
            logger.error("unrecoverable error.");
            jde.printStackTrace();
            return null;
        }
        return doc;
    }

    public static void saveDocumentTo(Document doc, String file) {
        XMLUtils.saveDocumentTo(doc, new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDocumentTo(Document doc, File file) {
        FileWriter writer = null;
        logger.debug("saving document to: " + file.getAbsolutePath());
        if (file.exists() && !file.canWrite()) {
            return;
        }
        try {
            writer = new FileWriter(file);
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            outputter.output(doc, (Writer)writer);
        }
        catch (IOException ioe) {
            logger.warn("cannot save to file " + file.getAbsolutePath());
        }
        catch (NullPointerException npe) {
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static Element[] getElementsFromTableModel(TableModel model, String rowname) {
        int numrow = model.getRowCount();
        Element[] ret = new Element[numrow];
        if (model == null) {
            logger.error("'table model' is null.");
            return null;
        }
        int numcol = model.getColumnCount();
        for (int i = 0; i < numrow; ++i) {
            Element elemroot = new Element(rowname);
            for (int j = 0; j < numcol; ++j) {
                String colname = model.getColumnName(j);
                Element element = new Element(colname);
                Object obj = model.getValueAt(i, j);
                String sobj = "";
                if (obj instanceof String) {
                    sobj = (String)obj;
                } else if (obj instanceof Boolean) {
                    sobj = ((Boolean)obj).toString();
                }
                element.addContent(MyElement.encode(sobj));
                elemroot.addContent(element);
            }
            ret[i] = elemroot;
        }
        return ret;
    }
}

