/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements.bond;

import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.scenegraphelements.bond.BondInfo;
import ciss.phase_viewer.common.ElementDef;
import ciss.phase_viewer.common.ElementInfo;
import java.util.Arrays;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BondCalculator {
    private static Logger logger = Logger.getLogger(BondCalculator.class.getName());
    private int NumAt;
    private int NumBondMax;
    private int NumBond;
    private double rbond;
    private J3DDataManager mACVD;
    private ConfigDataManager mCD;
    private double[][] xyz;
    private double[][] Hatoms;
    private double[][][] HbondCandidates;
    private double[] HbondRmax;
    private double[][] hxyz;
    private int[] map;
    private double[] bigCell;
    private double[] smallCell;
    private int[] ndiv;
    private double[][] xyz_buff;
    private double[] covalentRadius;
    private double rbondMax;
    private Vector[][][] cell_atom_map;
    private String[] elements;
    private boolean[][] ignore;
    private Vector bonds;

    public BondCalculator() {
    }

    public BondCalculator(J3DDataManager mACVD, ConfigDataManager mCD) {
        this.mACVD = mACVD;
        this.mCD = mCD;
        this.NumAt = mCD.getNumAt();
        this.NumBondMax = this.NumAt * (this.NumAt - 1) / 2;
    }

    public int getNumBond() {
        return this.NumBond;
    }

    public int getNumBondMax() {
        return this.NumBondMax;
    }

    private boolean prepareForHbond() {
        this.map = new int[this.mCD.getNumAt()];
        ElementInfo einfo = ElementInfo.getElementInfo();
        ElementDef[] candidates = einfo.getHBondDonorAcceptorCandidates();
        if (candidates == null || candidates.length == 0) {
            return false;
        }
        String[] elements = this.mCD.getElements();
        Vector<double[]> vec = new Vector<double[]>();
        int count = 0;
        for (int i = 0; i < elements.length; ++i) {
            if (!elements[i].equals("H")) continue;
            vec.addElement(this.xyz[i]);
            this.map[i] = count++;
        }
        if (vec.size() == 0) {
            logger.debug("found no H atoms");
            return false;
        }
        this.Hatoms = new double[vec.size()][];
        logger.debug("num. H atoms: " + this.Hatoms.length);
        vec.copyInto((Object[])this.Hatoms);
        vec.clear();
        this.HbondCandidates = new double[candidates.length][][];
        this.HbondRmax = new double[candidates.length];
        boolean found = false;
        this.rbondMax = -1.0E7;
        double lenmax = this.mCD.getLenMax();
        for (int i = 0; i < candidates.length; ++i) {
            for (int j = 0; j < elements.length; ++j) {
                if (!candidates[i].getSymbol().equals(elements[j])) continue;
                vec.addElement(this.xyz[j]);
                this.map[j] = count++;
            }
            if (vec.size() != 0) {
                this.HbondCandidates[i] = new double[vec.size()][];
                this.HbondRmax[i] = candidates[i].getMaxHbondDistance() / lenmax;
                if (this.HbondRmax[i] > this.rbondMax) {
                    this.rbondMax = this.HbondRmax[i];
                }
                vec.copyInto((Object[])this.HbondCandidates[i]);
                found = true;
            }
            vec.clear();
        }
        return found;
    }

    private void preProcessForHbond() {
        int j;
        int i;
        int j2;
        int i2;
        double[] min = new double[3];
        double[] max = new double[3];
        for (int i3 = 0; i3 < 3; ++i3) {
            min[i3] = 1.0E7;
            max[i3] = -1.0E7;
        }
        int numat2consider = 0;
        for (i2 = 0; i2 < this.HbondCandidates.length; ++i2) {
            if (this.HbondCandidates[i2] == null) continue;
            for (j2 = 0; j2 < this.HbondCandidates[i2].length; ++j2) {
                for (int k = 0; k < 3; ++k) {
                    if (this.HbondCandidates[i2][j2][k] > max[k]) {
                        max[k] = this.HbondCandidates[i2][j2][k];
                    }
                    if (!(this.HbondCandidates[i2][j2][k] < min[k])) continue;
                    min[k] = this.HbondCandidates[i2][j2][k];
                }
                ++numat2consider;
            }
        }
        for (i2 = 0; i2 < this.Hatoms.length; ++i2) {
            for (j2 = 0; j2 < this.Hatoms[i2].length; ++j2) {
                if (this.Hatoms[i2][j2] > max[j2]) {
                    max[j2] = this.Hatoms[i2][j2];
                }
                if (!(this.Hatoms[i2][j2] < min[j2])) continue;
                min[j2] = this.Hatoms[i2][j2];
            }
            ++numat2consider;
        }
        this.bigCell = new double[3];
        for (i2 = 0; i2 < 3; ++i2) {
            this.bigCell[i2] = max[i2] - min[i2] + 0.01;
        }
        this.NumAt = numat2consider;
        this.xyz_buff = new double[numat2consider][3];
        this.hxyz = new double[numat2consider][3];
        this.covalentRadius = new double[numat2consider];
        int count = 0;
        for (i = 0; i < this.Hatoms.length; ++i) {
            for (j = 0; j < 3; ++j) {
                this.xyz_buff[count][j] = this.Hatoms[i][j] - min[j];
                this.hxyz[count][j] = this.Hatoms[i][j];
                this.covalentRadius[count] = 0.0;
            }
            ++count;
        }
        for (i = 0; i < this.HbondCandidates.length; ++i) {
            if (this.HbondCandidates[i] == null) continue;
            for (j = 0; j < this.HbondCandidates[i].length; ++j) {
                for (int k = 0; k < 3; ++k) {
                    this.xyz_buff[count][k] = this.HbondCandidates[i][j][k] - min[k];
                    this.hxyz[count][k] = this.HbondCandidates[i][j][k];
                    this.covalentRadius[count] = this.HbondRmax[i];
                }
                ++count;
            }
        }
        this.ndiv = new int[3];
        this.smallCell = new double[3];
        logger.debug("rbondMax: " + this.rbondMax);
        for (i = 0; i < 3; ++i) {
            this.ndiv[i] = (int)(this.bigCell[i] / this.rbondMax) + 1;
            this.smallCell[i] = this.bigCell[i] / (double)this.ndiv[i];
        }
        logger.debug("ndiv: " + this.ndiv[0] + ", " + this.ndiv[1] + ", " + this.ndiv[2]);
        logger.debug("smallCell: " + this.smallCell[0] + ", " + this.smallCell[1] + ", " + this.smallCell[2]);
        this.cell_atom_map = new Vector[this.ndiv[0]][this.ndiv[1]][this.ndiv[2]];
        for (int i1 = 0; i1 < this.ndiv[0]; ++i1) {
            for (int i22 = 0; i22 < this.ndiv[1]; ++i22) {
                for (int i3 = 0; i3 < this.ndiv[2]; ++i3) {
                    this.cell_atom_map[i1][i22][i3] = null;
                }
            }
        }
        for (i = 0; i < this.xyz_buff.length; ++i) {
            int i1 = (int)(this.xyz_buff[i][0] / this.smallCell[0]);
            int i23 = (int)(this.xyz_buff[i][1] / this.smallCell[1]);
            int i3 = (int)(this.xyz_buff[i][2] / this.smallCell[2]);
            if (this.cell_atom_map[i1][i23][i3] == null) {
                this.cell_atom_map[i1][i23][i3] = new Vector();
            }
            logger.debug("i1, i2, i3: " + i1 + ", " + i23 + ", " + i3);
            this.cell_atom_map[i1][i23][i3].addElement(new Integer(i));
        }
    }

    private void preProcess() {
        int j;
        int i;
        this.NumAt = this.mCD.getNumAt();
        double[] min = new double[3];
        double[] max = new double[3];
        for (i = 0; i < 3; ++i) {
            min[i] = 1.0E7;
            max[i] = -1.0E7;
        }
        for (i = 0; i < this.NumAt; ++i) {
            for (j = 0; j < 3; ++j) {
                if (this.xyz[i][j] > max[j]) {
                    max[j] = this.xyz[i][j];
                }
                if (!(this.xyz[i][j] < min[j])) continue;
                min[j] = this.xyz[i][j];
            }
        }
        this.bigCell = new double[3];
        for (i = 0; i < 3; ++i) {
            this.bigCell[i] = max[i] - min[i] + 0.01;
        }
        this.xyz_buff = new double[this.NumAt][3];
        for (i = 0; i < this.NumAt; ++i) {
            for (j = 0; j < 3; ++j) {
                this.xyz_buff[i][j] = this.xyz[i][j] - min[j];
            }
        }
        this.covalentRadius = new double[this.NumAt];
        int NumEl = this.mACVD.getNumEl();
        this.elements = this.mCD.getElements();
        String[] elementString = new String[NumEl];
        double[] covRad = new double[NumEl];
        double lenMax = this.mCD.getLenMax();
        double bondFactor = this.mACVD.getBondFactor();
        for (int jele = 0; jele < NumEl; ++jele) {
            elementString[jele] = this.mACVD.getElement()[jele];
            covRad[jele] = this.mACVD.getCovRad()[jele];
        }
        this.rbondMax = -100000.0;
        Vector covrads = new Vector();
        for (i = 0; i < this.NumAt; ++i) {
            this.covalentRadius[i] = 0.0;
            for (int jele = 0; jele < NumEl; ++jele) {
                if (this.elements[i] == null || this.elements[i].trim().length() == 0 || !elementString[jele].equals(this.elements[i])) continue;
                this.covalentRadius[i] = bondFactor * covRad[jele] / lenMax;
            }
        }
        for (i = 0; i < this.covalentRadius.length; ++i) {
            if (!(this.covalentRadius[i] > this.rbondMax)) continue;
            this.rbondMax = this.covalentRadius[i];
        }
        if (this.rbondMax <= 0.0) {
            return;
        }
        this.rbondMax *= 2.0;
        this.ndiv = new int[3];
        this.smallCell = new double[3];
        logger.debug("rbondMax: " + this.rbondMax);
        for (i = 0; i < 3; ++i) {
            this.ndiv[i] = (int)(this.bigCell[i] / this.rbondMax) + 1;
            this.smallCell[i] = this.bigCell[i] / (double)this.ndiv[i];
        }
        logger.debug("ndiv: " + this.ndiv[0] + ", " + this.ndiv[1] + ", " + this.ndiv[2]);
        logger.debug("smallCell: " + this.smallCell[0] + ", " + this.smallCell[1] + ", " + this.smallCell[2]);
        this.cell_atom_map = new Vector[this.ndiv[0]][this.ndiv[1]][this.ndiv[2]];
        for (int i1 = 0; i1 < this.ndiv[0]; ++i1) {
            for (int i2 = 0; i2 < this.ndiv[1]; ++i2) {
                for (int i3 = 0; i3 < this.ndiv[2]; ++i3) {
                    this.cell_atom_map[i1][i2][i3] = null;
                }
            }
        }
        for (int ii = 0; ii < this.NumAt; ++ii) {
            int i1 = (int)(this.xyz_buff[ii][0] / this.smallCell[0]);
            int i2 = (int)(this.xyz_buff[ii][1] / this.smallCell[1]);
            int i3 = (int)(this.xyz_buff[ii][2] / this.smallCell[2]);
            if (this.cell_atom_map[i1][i2][i3] == null) {
                this.cell_atom_map[i1][i2][i3] = new Vector();
            }
            logger.debug("ii, i1, i2, i3: " + i1 + ", " + i2 + ", " + i3 + ", " + ii);
            this.cell_atom_map[i1][i2][i3].addElement(new Integer(ii));
        }
    }

    public void setIgnore(boolean[][] ignore) {
        this.ignore = ignore;
    }

    public Vector getBonds() {
        return this.bonds;
    }

    public void doHbond(double[][] xyz) {
        this.xyz = xyz;
        if (!this.prepareForHbond()) {
            logger.debug("no Hbonds");
            return;
        }
        this.preProcessForHbond();
        this.bonds = new Vector();
        if (this.rbondMax <= 0.0) {
            return;
        }
        for (int i = 0; i < this.Hatoms.length; ++i) {
            Vector<BondInfo> bondInfos = new Vector<BondInfo>();
            int i1 = (int)(this.xyz_buff[i][0] / this.smallCell[0]);
            int i2 = (int)(this.xyz_buff[i][1] / this.smallCell[1]);
            int i3 = (int)(this.xyz_buff[i][2] / this.smallCell[2]);
            Vector centerCell = this.cell_atom_map[i1][i2][i3];
            if (centerCell == null) continue;
            logger.debug("num. atoms in cell: " + centerCell.size());
            int ind1 = i;
            for (int ii1 = i1 - 1; ii1 <= i1 + 1; ++ii1) {
                for (int ii2 = i2 - 1; ii2 <= i2 + 1; ++ii2) {
                    for (int ii3 = i3 - 1; ii3 <= i3 + 1; ++ii3) {
                        Vector vec;
                        if (ii1 < 0 || ii2 < 0 || ii3 < 0 || ii1 >= this.ndiv[0] || ii2 >= this.ndiv[1] || ii3 >= this.ndiv[2] || (vec = this.cell_atom_map[ii1][ii2][ii3]) == null) continue;
                        for (int ic2 = 0; ic2 < vec.size(); ++ic2) {
                            int ind2 = (Integer)vec.get(ic2);
                            if (ind2 < this.Hatoms.length || this.ignore != null && this.ignore[this.map[ind1]][this.map[ind2]]) continue;
                            double rbond2 = Math.pow(this.covalentRadius[ind2], 2.0);
                            double r2 = Math.pow(this.xyz_buff[ind1][0] - this.xyz_buff[ind2][0], 2.0) + Math.pow(this.xyz_buff[ind1][1] - this.xyz_buff[ind2][1], 2.0) + Math.pow(this.xyz_buff[ind1][2] - this.xyz_buff[ind2][2], 2.0);
                            if (!(r2 < rbond2) || r2 == 0.0) continue;
                            logger.debug("neighboring cell: rbond2, r2 " + rbond2 + ", " + r2);
                            logger.debug("and their indeces: " + ind1 + ", " + ind2);
                            double[] NearestNeighbor_ = new double[]{this.hxyz[ind1][0], this.hxyz[ind1][1], this.hxyz[ind1][2], this.hxyz[ind2][0], this.hxyz[ind2][1], this.hxyz[ind2][2]};
                            BondInfo binf = new BondInfo(ind1, ind2, NearestNeighbor_);
                            binf.setBondLengthSquared(r2);
                            binf.setCriticalDistanceSquared(rbond2);
                            bondInfos.add(binf);
                        }
                    }
                }
            }
            if (bondInfos.size() < 2) {
                bondInfos.clear();
                continue;
            }
            Object[] bi = new BondInfo[bondInfos.size()];
            bondInfos.copyInto(bi);
            Arrays.sort(bi);
            double lenmax = this.mCD.getLenMax();
            logger.debug("bi 0 and 1 " + ((BondInfo)bi[0]).getBondLength() * lenmax + " " + ((BondInfo)bi[1]).getBondLength() * lenmax);
            this.bonds.addElement(bi[1]);
        }
    }

    public void doIt(double[][] xyz) {
        int i3;
        int i2;
        int i1;
        this.xyz = xyz;
        this.preProcess();
        this.bonds = new Vector();
        if (this.rbondMax <= 0.0) {
            return;
        }
        boolean[][][] passed = new boolean[this.ndiv[0]][this.ndiv[1]][this.ndiv[2]];
        for (i1 = 0; i1 < this.ndiv[0]; ++i1) {
            for (i2 = 0; i2 < this.ndiv[1]; ++i2) {
                for (i3 = 0; i3 < this.ndiv[2]; ++i3) {
                    passed[i1][i2][i3] = false;
                }
            }
        }
        for (i1 = 0; i1 < this.ndiv[0]; ++i1) {
            for (i2 = 0; i2 < this.ndiv[1]; ++i2) {
                for (i3 = 0; i3 < this.ndiv[2]; ++i3) {
                    int ic1;
                    passed[i1][i2][i3] = true;
                    Vector centerCell = this.cell_atom_map[i1][i2][i3];
                    if (centerCell == null) continue;
                    logger.debug("num. atoms in cell: " + centerCell.size());
                    for (ic1 = 0; ic1 < centerCell.size() - 1; ++ic1) {
                        for (int ic2 = ic1 + 1; ic2 < centerCell.size(); ++ic2) {
                            int ind1 = (Integer)centerCell.get(ic1);
                            int ind2 = (Integer)centerCell.get(ic2);
                            if (this.ignore != null && this.ignore[ind1][ind2]) continue;
                            double rbond2 = Math.pow(this.covalentRadius[ind1] + this.covalentRadius[ind2], 2.0);
                            double r2 = Math.pow(this.xyz_buff[ind1][0] - this.xyz_buff[ind2][0], 2.0) + Math.pow(this.xyz_buff[ind1][1] - this.xyz_buff[ind2][1], 2.0) + Math.pow(this.xyz_buff[ind1][2] - this.xyz_buff[ind2][2], 2.0);
                            logger.debug("foobar: rbond2, r2 " + rbond2 + ", " + r2);
                            if (!(r2 < rbond2)) continue;
                            double[] NearestNeighbor_ = new double[]{xyz[ind1][0], xyz[ind1][1], xyz[ind1][2], xyz[ind2][0], xyz[ind2][1], xyz[ind2][2]};
                            BondInfo binf = new BondInfo(ind1, ind2, NearestNeighbor_);
                            binf.setCriticalDistanceSquared(rbond2);
                            this.bonds.add(binf);
                        }
                    }
                    for (ic1 = 0; ic1 < centerCell.size(); ++ic1) {
                        int ind1 = (Integer)centerCell.get(ic1);
                        for (int ii1 = i1 - 1; ii1 <= i1 + 1; ++ii1) {
                            for (int ii2 = i2 - 1; ii2 <= i2 + 1; ++ii2) {
                                for (int ii3 = i3 - 1; ii3 <= i3 + 1; ++ii3) {
                                    Vector vec;
                                    if (ii1 < 0 || ii2 < 0 || ii3 < 0 || ii1 >= this.ndiv[0] || ii2 >= this.ndiv[1] || ii3 >= this.ndiv[2] || passed[ii1][ii2][ii3] || (vec = this.cell_atom_map[ii1][ii2][ii3]) == null || ii1 == 0 && ii2 == 0 && ii3 == 0) continue;
                                    for (int ic2 = 0; ic2 < vec.size(); ++ic2) {
                                        int ind2 = (Integer)vec.get(ic2);
                                        if (this.ignore != null && this.ignore[ind1][ind2]) continue;
                                        double rbond2 = Math.pow(this.covalentRadius[ind1] + this.covalentRadius[ind2], 2.0);
                                        double r2 = Math.pow(this.xyz_buff[ind1][0] - this.xyz_buff[ind2][0], 2.0) + Math.pow(this.xyz_buff[ind1][1] - this.xyz_buff[ind2][1], 2.0) + Math.pow(this.xyz_buff[ind1][2] - this.xyz_buff[ind2][2], 2.0);
                                        if (!(r2 < rbond2) || r2 == 0.0) continue;
                                        logger.debug("ind1 & 2: " + ind1 + ", " + ind2);
                                        logger.debug("i1, i2, and i3: " + i1 + ", " + i2 + ", " + i3);
                                        logger.debug("ii1, ii2, and ii3: " + ii1 + ", " + ii2 + ", " + ii3);
                                        double[] NearestNeighbor_ = new double[]{xyz[ind1][0], xyz[ind1][1], xyz[ind1][2], xyz[ind2][0], xyz[ind2][1], xyz[ind2][2]};
                                        BondInfo binf = new BondInfo(ind1, ind2, NearestNeighbor_);
                                        binf.setCriticalDistanceSquared(rbond2);
                                        this.bonds.addElement(binf);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        logger.debug("num. bonds: " + this.bonds.size());
    }
}

