/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.fbz;

import ciss.phase_viewer.acviewer.CylinderCreator;
import ciss.phase_viewer.acviewer.fbz.Kpoint;
import ciss.phase_viewer.acviewer.fbz.KpointGenerator;
import ciss.phase_viewer.acviewer.fbz.KpointsListener;
import ciss.phase_viewer.acviewer.fbz.SymmetryPointBG;
import ciss.phase_viewer.acviewer.fbz.SymmetryPointSet;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzAttributes;
import ciss.phase_viewer.acviewer.geom.BoundPlane;
import ciss.phase_viewer.acviewer.geom.Plane;
import ciss.phase_viewer.acviewer.geom.Side;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleFanArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;

public class WignerSeitzCell
extends BranchGroup {
    private Logger logger = Logger.getLogger(WignerSeitzCell.class.getName());
    private Point3f avec;
    private Point3f bvec;
    private Point3f cvec;
    private WignerSeitzAttributes wsattrs;
    private Vector selectedSymmetryPoints = new Vector();
    private Vector kpointListeners = new Vector();
    private String parentDir = System.getProperty("user.dir");
    private KpointGenerator kpointGenerator;
    private Vector symmetryLine = new Vector();
    private Vector selectedSymmetryPointsCache;
    private Point3f jusin;
    private Vector vertices = new Vector();
    private Vector planes = new Vector();
    private Transform3D smallTransform;
    private DecimalFormat format = new DecimalFormat("0.00000");
    private String bandkptin = "bandkpt.in";
    private BranchGroup bgaxis;
    private BranchGroup bgplane;
    private BranchGroup bgedge;
    private SymmetryPointSet symmetryPoints;

    public WignerSeitzCell(Point3f avec, Point3f bvec, Point3f cvec) {
        this.avec = avec;
        this.bvec = bvec;
        this.cvec = cvec;
        this.wsattrs = new WignerSeitzAttributes();
        this.init();
        try {
            this.createWSCell();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public WignerSeitzCell(Point3f avec, Point3f bvec, Point3f cvec, String parentDir) {
        this.avec = avec;
        this.bvec = bvec;
        this.cvec = cvec;
        this.parentDir = parentDir;
        this.wsattrs = new WignerSeitzAttributes();
        this.init();
        try {
            this.createWSCell();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public WignerSeitzCell(Point3f avec, Point3f bvec, Point3f cvec, String parentDir, KpointGenerator kpointGenerator) {
        this.avec = avec;
        this.bvec = bvec;
        this.cvec = cvec;
        this.parentDir = parentDir;
        this.kpointGenerator = kpointGenerator;
        this.wsattrs = new WignerSeitzAttributes();
        this.init();
        try {
            this.createWSCell();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public WignerSeitzCell(Point3f avec, Point3f bvec, Point3f cvec, WignerSeitzAttributes wsattrs) {
        this.avec = avec;
        this.bvec = bvec;
        this.cvec = cvec;
        this.wsattrs = wsattrs;
        this.init();
        try {
            this.createWSCell();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void setKpointGenerator(KpointGenerator kpointGenerator) {
        this.kpointGenerator = kpointGenerator;
    }

    public void doSymmetricPoint(SymmetryPointBG symmetryPoint) {
        if (this.selectedSymmetryPoints.size() == 0) {
            this.addSymmetricPoint(symmetryPoint);
            return;
        }
        if (this.selectedSymmetryPoints.get(this.selectedSymmetryPoints.size() - 1) == symmetryPoint) {
            this.removeSymmetricPoint(symmetryPoint);
        } else {
            this.addSymmetricPoint(symmetryPoint);
        }
    }

    public Kpoint[] getSelectedKpoints() {
        Vector<Kpoint> retvec = new Vector<Kpoint>();
        for (int i = 0; i < this.selectedSymmetryPoints.size(); ++i) {
            SymmetryPointBG symp = (SymmetryPointBG)((Object)this.selectedSymmetryPoints.get(i));
            Kpoint kp = new Kpoint(symp);
            retvec.addElement(kp);
        }
        Object[] ret = new Kpoint[retvec.size()];
        retvec.copyInto(ret);
        return ret;
    }

    public void addSymmetricPoint(SymmetryPointBG symmetryPoint) {
        this.selectedSymmetryPoints.add(symmetryPoint);
        this.addSymmetryLine();
        Kpoint kp = new Kpoint(symmetryPoint);
        for (int i = 0; i < this.kpointListeners.size(); ++i) {
            ((KpointsListener)this.kpointListeners.get(i)).kpointAdded(kp);
        }
    }

    public void removeSymmetricPoint(SymmetryPointBG symmetryPoint) {
        ((SymmetryPointBG)((Object)this.selectedSymmetryPoints.get(this.selectedSymmetryPoints.size() - 1))).setSelected(false);
        if (this.selectedSymmetryPoints.size() >= 2) {
            ((SymmetryPointBG)((Object)this.selectedSymmetryPoints.get(this.selectedSymmetryPoints.size() - 2))).setSelected(true);
        }
        this.selectedSymmetryPoints.remove(this.selectedSymmetryPoints.size() - 1);
        this.removeSymmetryLine();
        Kpoint kp = new Kpoint(symmetryPoint);
        for (int i = 0; i < this.kpointListeners.size(); ++i) {
            ((KpointsListener)this.kpointListeners.get(i)).kpointRemoved(kp);
        }
    }

    public void addKPointListener(KpointsListener kpointListener) {
        this.kpointListeners.addElement(kpointListener);
    }

    public void removeKPointListener(KpointsListener kpointListener) {
        this.kpointListeners.remove(kpointListener);
    }

    private void addSymmetryLine() {
        if (this.selectedSymmetryPoints.size() == 0) {
            return;
        }
        SymmetryPointBG sym = (SymmetryPointBG)((Object)this.selectedSymmetryPoints.get(this.selectedSymmetryPoints.size() - 1));
        sym.setSelected(true);
        if (this.selectedSymmetryPoints.size() == 1) {
            return;
        }
        SymmetryPointBG prevsym = (SymmetryPointBG)((Object)this.selectedSymmetryPoints.get(this.selectedSymmetryPoints.size() - 2));
        prevsym.setSelected(false);
        Vector3f prevpos = prevsym.getPos();
        Vector3f pos = sym.getPos();
        LineArray lineArray = new LineArray(2, 5);
        lineArray.setCoordinate(0, new Point3f((Tuple3f)prevpos));
        lineArray.setColor(0, this.wsattrs.symmetricLineColor);
        lineArray.setCoordinate(1, new Point3f((Tuple3f)pos));
        lineArray.setColor(1, this.wsattrs.symmetricLineColor);
        LineAttributes lattr = new LineAttributes();
        lattr.setLineWidth(this.wsattrs.symmetricLineWidth);
        Appearance app = new Appearance();
        app.setLineAttributes(lattr);
        Shape3D s3d = new Shape3D();
        try {
            lineArray.setCapability(18);
        }
        catch (RestrictedAccessException rae) {
            // empty catch block
        }
        s3d.setGeometry((Geometry)lineArray);
        s3d.setAppearance(app);
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        bg.addChild((Node)s3d);
        this.addChild((Node)bg);
        this.symmetryLine.add(bg);
    }

    public void removeAllSymmetryLines() {
        int i;
        for (i = 0; i < this.symmetryLine.size(); ++i) {
            BranchGroup b = (BranchGroup)this.symmetryLine.get(i);
            b.detach();
            Object var2_2 = null;
        }
        for (i = 0; i < this.selectedSymmetryPoints.size(); ++i) {
            ((SymmetryPointBG)((Object)this.selectedSymmetryPoints.get(i))).setSelected(false);
        }
        this.symmetryLine.removeAllElements();
        this.selectedSymmetryPoints.removeAllElements();
        for (i = 0; i < this.kpointListeners.size(); ++i) {
            ((KpointsListener)this.kpointListeners.get(i)).kpointsInitialized();
        }
    }

    private void cacheSelectedSymmetryPoints() {
        this.selectedSymmetryPointsCache = new Vector();
        for (int i = 0; i < this.selectedSymmetryPoints.size(); ++i) {
            this.selectedSymmetryPointsCache.addElement(this.selectedSymmetryPoints.get(i));
        }
    }

    private void removeSymmetryLine() {
        if (this.symmetryLine.size() == 0) {
            return;
        }
        BranchGroup b = (BranchGroup)this.symmetryLine.get(this.symmetryLine.size() - 1);
        this.symmetryLine.remove(this.symmetryLine.size() - 1);
        b.detach();
        b = null;
    }

    public void setAttributes(WignerSeitzAttributes wsattrs) {
        this.wsattrs = wsattrs;
    }

    public WignerSeitzAttributes getAttributes() {
        return this.wsattrs;
    }

    public BoundPlane[] getPlanes() {
        if (this.planes == null || this.planes.size() == 0) {
            return null;
        }
        Vector<BoundPlane> tmpvec = new Vector<BoundPlane>();
        for (int i = 0; i < this.planes.size(); ++i) {
            BoundPlane plane = (BoundPlane)this.planes.get(i);
            if (plane.getVertices().length < 3) continue;
            tmpvec.add(plane);
        }
        Object[] pls = new BoundPlane[tmpvec.size()];
        tmpvec.copyInto(pls);
        return pls;
    }

    private void init() {
        int i;
        this.setCapability(17);
        this.setCapability(14);
        this.setCapability(13);
        this.smallTransform = new Transform3D();
        this.smallTransform.rotX(0.09425720532822662);
        this.smallTransform.rotY(0.038627722286853475);
        this.smallTransform.rotZ(0.054798406656022904);
        this.smallTransform.transform(this.avec);
        this.smallTransform.transform(this.bvec);
        this.smallTransform.transform(this.cvec);
        float bigx = -1000.0f;
        float bigy = -1000.0f;
        float bigz = -1000.0f;
        bigx = this.avec.x;
        if (this.bvec.x > bigx) {
            bigx = this.bvec.x;
        }
        if (this.cvec.x > bigx) {
            bigx = this.cvec.x;
        }
        if (this.bvec.y > (bigy = this.avec.y)) {
            bigy = this.bvec.y;
        }
        if (this.cvec.y > bigy) {
            bigy = this.cvec.y;
        }
        if (this.bvec.z > (bigz = this.avec.z)) {
            bigz = this.bvec.z;
        }
        if (this.cvec.z > bigz) {
            bigz = this.cvec.z;
        }
        bigx = 10.0f;
        bigy = 10.0f;
        bigz = 10.0f;
        Point3f initx = new Point3f(bigx, 0.0f, 0.0f);
        Point3f inity = new Point3f(0.0f, bigy, 0.0f);
        Point3f initz = new Point3f(0.0f, 0.0f, bigz);
        Point3f[] initialVertices = new Point3f[8];
        for (i = 0; i < initialVertices.length; ++i) {
            initialVertices[i] = new Point3f(0.0f, 0.0f, 0.0f);
        }
        initialVertices[0].add((Tuple3f)initx);
        initialVertices[0].sub((Tuple3f)inity);
        initialVertices[0].sub((Tuple3f)initz);
        initialVertices[1].add((Tuple3f)initx);
        initialVertices[1].add((Tuple3f)inity);
        initialVertices[1].sub((Tuple3f)initz);
        initialVertices[2].sub((Tuple3f)initx);
        initialVertices[2].add((Tuple3f)inity);
        initialVertices[2].sub((Tuple3f)initz);
        initialVertices[3].sub((Tuple3f)initx);
        initialVertices[3].sub((Tuple3f)inity);
        initialVertices[3].sub((Tuple3f)initz);
        initialVertices[4].add((Tuple3f)initx);
        initialVertices[4].sub((Tuple3f)inity);
        initialVertices[4].add((Tuple3f)initz);
        initialVertices[5].add((Tuple3f)initx);
        initialVertices[5].add((Tuple3f)inity);
        initialVertices[5].add((Tuple3f)initz);
        initialVertices[6].sub((Tuple3f)initx);
        initialVertices[6].add((Tuple3f)inity);
        initialVertices[6].add((Tuple3f)initz);
        initialVertices[7].sub((Tuple3f)initx);
        initialVertices[7].sub((Tuple3f)inity);
        initialVertices[7].add((Tuple3f)initz);
        for (i = 0; i < initialVertices.length; ++i) {
            this.vertices.addElement(initialVertices[i]);
        }
        BoundPlane plane1 = new BoundPlane();
        plane1.setVertices(new Point3f[]{initialVertices[0], initialVertices[1], initialVertices[2], initialVertices[3]});
        plane1.generateNormal();
        BoundPlane plane2 = new BoundPlane();
        plane2.setVertices(new Point3f[]{initialVertices[4], initialVertices[5], initialVertices[6], initialVertices[7]});
        plane2.generateNormal();
        BoundPlane plane3 = new BoundPlane();
        plane3.setVertices(new Point3f[]{initialVertices[0], initialVertices[1], initialVertices[5], initialVertices[4]});
        plane3.generateNormal();
        BoundPlane plane4 = new BoundPlane();
        plane4.setVertices(new Point3f[]{initialVertices[3], initialVertices[2], initialVertices[6], initialVertices[7]});
        plane4.generateNormal();
        BoundPlane plane5 = new BoundPlane();
        plane5.setVertices(new Point3f[]{initialVertices[5], initialVertices[1], initialVertices[2], initialVertices[6]});
        plane5.generateNormal();
        BoundPlane plane6 = new BoundPlane();
        plane6.setVertices(new Point3f[]{initialVertices[0], initialVertices[3], initialVertices[7], initialVertices[4]});
        plane6.generateNormal();
        this.planes.addElement(plane1);
        this.planes.addElement(plane2);
        this.planes.addElement(plane3);
        this.planes.addElement(plane4);
        this.planes.addElement(plane5);
        this.planes.addElement(plane6);
    }

    private void createWSCell() {
        this.createPlanes();
        this.drawWSCell();
        this.loadFromFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromFile() {
        Object[] kpts = null;
        if (this.kpointGenerator != null) {
            kpts = this.kpointGenerator.getKpointsFrom("");
        }
        File foo = new File(this.parentDir + System.getProperty("file.separator") + this.bandkptin);
        if (this.symmetryPoints == null) {
            return;
        }
        if (kpts == null && foo.exists()) {
            BufferedReader reader = null;
            Vector<Kpoint> tmpvec = new Vector<Kpoint>();
            try {
                reader = new BufferedReader(new FileReader(foo));
                String l = "";
                reader.readLine();
                reader.readLine();
                reader.readLine();
                reader.readLine();
                while ((l = reader.readLine()) != null) {
                    String[] kps;
                    String symbol = "";
                    int nx = 0;
                    int ny = 0;
                    int nz = 0;
                    int denom = 1;
                    String[] sphash = l.split("#");
                    if (sphash.length == 2) {
                        symbol = sphash[1].trim();
                    }
                    if ((kps = sphash[0].trim().split("\\s+")) == null || kps.length < 4) continue;
                    nx = Integer.parseInt(kps[0].trim());
                    ny = Integer.parseInt(kps[1].trim());
                    nz = Integer.parseInt(kps[2].trim());
                    denom = Integer.parseInt(kps[3]);
                    float fx = (float)nx / (float)denom;
                    float fy = (float)ny / (float)denom;
                    float fz = (float)nz / (float)denom;
                    Point3f kp = new Point3f(fx, fy, fz);
                    Kpoint kpoi = new Kpoint(new float[]{fx, fy, fz});
                    kpoi.setSymbol(symbol);
                    tmpvec.add(kpoi);
                }
                kpts = new Kpoint[tmpvec.size()];
                tmpvec.copyInto(kpts);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (kpts == null) {
            return;
        }
        for (int j = 0; j < kpts.length; ++j) {
            Kpoint kp = kpts[j];
            for (int i = 0; i < this.symmetryPoints.numChildren(); ++i) {
                SymmetryPointBG sym = this.symmetryPoints.getSymmetryPoint(i);
                if (!sym.getScaledPos().epsilonEquals((Tuple3f)kp.getPoint3f(), 0.001f)) continue;
                sym.setSymbol(kp.getSymbol());
                this.doSymmetricPoint(sym);
            }
        }
    }

    private void createPlanes() {
        int i;
        float verySmall = 1.0E-4f;
        int n = 1;
        Vector<Plane> normals = new Vector<Plane>();
        for (int i2 = -n; i2 <= n; ++i2) {
            for (int j = -n; j <= n; ++j) {
                for (int k = -n; k <= n; ++k) {
                    if (i2 == 0 && j == 0 && k == 0) continue;
                    Point3f av = new Point3f();
                    Point3f bv = new Point3f();
                    Point3f cv = new Point3f();
                    av.scale((float)i2, (Tuple3f)this.avec);
                    bv.scale((float)j, (Tuple3f)this.bvec);
                    cv.scale((float)k, (Tuple3f)this.cvec);
                    Point3f vector = new Point3f();
                    vector.add((Tuple3f)av);
                    vector.add((Tuple3f)bv);
                    vector.add((Tuple3f)cv);
                    Point3f origin = new Point3f(vector);
                    origin.scale(0.5f);
                    Plane normalPlane = new Plane(vector, origin);
                    normals.add(normalPlane);
                }
            }
        }
        Object[] normalPlanes = new Plane[normals.size()];
        normals.copyInto(normalPlanes);
        Arrays.sort(normalPlanes);
        for (i = 0; i < normalPlanes.length; ++i) {
            int l;
            Object normalPlane = normalPlanes[i];
            Object[] bplanes = new BoundPlane[this.planes.size()];
            this.planes.copyInto(bplanes);
            boolean cros = false;
            for (int l2 = 0; l2 < bplanes.length; ++l2) {
                Point3f[] bpv = ((BoundPlane)bplanes[l2]).getVertices();
                for (int m = 0; m < bpv.length; ++m) {
                    if (!(((Plane)normalPlane).getDistanceFrom(bpv[m]) < verySmall)) continue;
                    cros = true;
                }
            }
            if (!cros) continue;
            BoundPlane newPlane = new BoundPlane();
            for (l = 0; l < this.planes.size(); ++l) {
                BoundPlane plane = (BoundPlane)this.planes.get(l);
                plane.sortVertices();
                Side[] sides = plane.getSides();
                if (sides == null || sides.length == 0) continue;
                for (int m = 0; m < sides.length; ++m) {
                    Point3f p1 = sides[m].getPoint1();
                    Point3f p2 = sides[m].getPoint2();
                    float d1 = ((Plane)normalPlane).getDistanceFrom(p1);
                    float d2 = ((Plane)normalPlane).getDistanceFrom(p2);
                    if (!(d1 > verySmall && d2 < verySmall) && (!(d1 < verySmall) || !(d2 > verySmall))) continue;
                    float ad1 = Math.abs(d1);
                    float ad2 = Math.abs(d2);
                    float scale = ad1 / (ad1 + ad2);
                    Point3f p3 = new Point3f();
                    Point3f tmp = new Point3f();
                    tmp.sub((Tuple3f)p2, (Tuple3f)p1);
                    p3.scaleAdd(scale, (Tuple3f)tmp, (Tuple3f)p1);
                    p3.x = Float.parseFloat(this.format.format(p3.x));
                    p3.y = Float.parseFloat(this.format.format(p3.y));
                    p3.z = Float.parseFloat(this.format.format(p3.z));
                    this.logger.debug("new vertex from plane " + l + ": " + p3);
                    plane.addVertex(p3);
                    newPlane.addVertex(p3);
                    this.vertices.add(p3);
                }
                Point3f[] vers = plane.getVertices();
                for (int m = 0; m < vers.length; ++m) {
                    float dis = ((Plane)normalPlane).getDistanceFrom(vers[m]);
                    if (!(dis > verySmall)) continue;
                    plane.removeVertex(vers[m]);
                    for (int nn = 0; nn < this.vertices.size(); ++nn) {
                        Point3f tmp3f = (Point3f)this.vertices.get(nn);
                        if (!tmp3f.epsilonEquals((Tuple3f)vers[m], verySmall)) continue;
                        this.vertices.remove(nn);
                    }
                }
            }
            if (newPlane.getVertices().length < 2) continue;
            newPlane.sortVertices();
            this.planes.addElement(newPlane);
            for (l = 0; l < this.planes.size(); ++l) {
                BoundPlane plane = (BoundPlane)this.planes.get(l);
                Side[] sds = plane.getSides();
                if (sds == null || sds.length < 3) continue;
                Point3f[] verts = plane.getVertices();
                boolean found = false;
                block11: for (int m = 0; m < verts.length; ++m) {
                    for (int nn = 0; nn < this.vertices.size(); ++nn) {
                        Point3f tmp3f = (Point3f)this.vertices.get(nn);
                        if (!tmp3f.epsilonEquals((Tuple3f)verts[m], verySmall)) continue;
                        found = true;
                        continue block11;
                    }
                }
            }
            for (l = 0; l < this.planes.size(); ++l) {
                ((BoundPlane)this.planes.get(l)).sortVertices();
            }
        }
        for (i = this.planes.size() - 1; i >= 0; --i) {
            if (((BoundPlane)this.planes.get(i)).getVertices().length > 2) continue;
            this.logger.debug("removing plane...");
            this.planes.remove(i);
        }
        for (i = this.planes.size() - 1; i >= 0; --i) {
            ((BoundPlane)this.planes.get(i)).generateNormal();
            ((BoundPlane)this.planes.get(i)).generateOrigin();
        }
    }

    private void drawWSCell() {
        this.smallTransform.invert();
        for (int i = 0; i < this.planes.size(); ++i) {
            BoundPlane pl = (BoundPlane)this.planes.get(i);
            Point3f[] verts = pl.getVertices();
            for (int j = 0; j < verts.length; ++j) {
                this.smallTransform.transform(verts[j]);
            }
        }
        this.smallTransform.transform(this.avec);
        this.smallTransform.transform(this.bvec);
        this.smallTransform.transform(this.cvec);
        if (this.wsattrs.drawEdge) {
            this.createBGEdges();
        }
        if (this.wsattrs.drawPlane) {
            this.createBGPlane();
        }
        if (this.wsattrs.drawAxis) {
            this.createBGAxis();
        }
        if (this.wsattrs.drawSymmetryPoints && this.wsattrs.isReciprocalSpace) {
            this.createSymmetryPoints();
        }
    }

    public void recreate() {
        this.logger.debug("recreating WSCell.");
        try {
            if (this.bgaxis != null) {
                this.bgaxis.detach();
            }
            if (this.bgplane != null) {
                this.bgplane.detach();
            }
            if (this.bgedge != null) {
                this.bgedge.detach();
            }
            this.cacheSelectedSymmetryPoints();
            this.removeAllSymmetryLines();
            if (this.symmetryPoints != null) {
                this.symmetryPoints.detach();
            }
            this.wsattrs.loadFromProps();
            if (this.wsattrs.drawEdge) {
                this.createBGEdges();
            }
            if (this.wsattrs.drawPlane) {
                this.createBGPlane();
            }
            if (this.wsattrs.drawAxis) {
                this.createBGAxis();
            }
            if (this.wsattrs.drawSymmetryPoints && this.wsattrs.isReciprocalSpace) {
                this.createSymmetryPoints();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (this.selectedSymmetryPointsCache != null) {
            for (int i = 0; i < this.selectedSymmetryPointsCache.size(); ++i) {
                SymmetryPointBG test2 = (SymmetryPointBG)((Object)this.selectedSymmetryPointsCache.get(i));
                for (int j = 0; j < this.symmetryPoints.numChildren(); ++j) {
                    if (!this.symmetryPoints.getSymmetryPoint(j).getPos().epsilonEquals((Tuple3f)test2.getPos(), 0.001f)) continue;
                    this.doSymmetricPoint(this.symmetryPoints.getSymmetryPoint(j));
                }
            }
        }
    }

    public void addPoint(SymmetryPointBG point) {
        this.addChild((Node)point);
    }

    private void createSymmetryPoints() {
        Point3f[] lat = new Point3f[]{this.avec, this.bvec, this.cvec};
        this.symmetryPoints = new SymmetryPointSet();
        this.symmetryPoints.setCapability(12);
        this.symmetryPoints.setCapability(17);
        if (this.wsattrs.gammaIsSymmetric) {
            SymmetryPointBG gamma = new SymmetryPointBG(new Vector3f(0.0f, 0.0f, 0.0f), lat, this.wsattrs);
            this.symmetryPoints.addChild((Node)gamma);
        }
        for (int i = 0; i < this.planes.size(); ++i) {
            BoundPlane plane = (BoundPlane)this.planes.get(i);
            Point3f[] vertices = plane.getVertices();
            Point3f midpoint = new Point3f();
            for (int j = 0; j < vertices.length; ++j) {
                vertices[j].x = Float.parseFloat(this.format.format(vertices[j].x));
                vertices[j].y = Float.parseFloat(this.format.format(vertices[j].y));
                vertices[j].z = Float.parseFloat(this.format.format(vertices[j].z));
                midpoint.x += vertices[j].x;
                midpoint.y += vertices[j].y;
                midpoint.z += vertices[j].z;
                if (!this.wsattrs.vertexIsSymmetric) continue;
                SymmetryPointBG symmvert = new SymmetryPointBG(new Vector3f((Tuple3f)vertices[j]), lat, this.wsattrs);
                this.symmetryPoints.addChild((Node)symmvert);
            }
            midpoint.x /= (float)vertices.length;
            midpoint.y /= (float)vertices.length;
            midpoint.z /= (float)vertices.length;
            if (this.wsattrs.centerOfPlaneIsSymmetric) {
                SymmetryPointBG symm = new SymmetryPointBG(new Vector3f((Tuple3f)midpoint), lat, this.wsattrs);
                this.symmetryPoints.addChild((Node)symm);
            }
            plane.sortVertices();
            Side[] side = plane.getSides();
            if (side == null || side.length < 3) continue;
            for (int j = 0; j < side.length; ++j) {
                Point3f p1 = side[j].getPoint1();
                Point3f p2 = side[j].getPoint2();
                Vector3f mid = new Vector3f((p1.x + p2.x) * 0.5f, (p1.y + p2.y) * 0.5f, (p1.z + p2.z) * 0.5f);
                this.logger.debug("p1, p2, mid: " + p1 + ", " + p2 + ", " + mid);
                if (!this.wsattrs.centerOfEdgeIsSymmetric) continue;
                SymmetryPointBG symmside = new SymmetryPointBG(mid, lat, this.wsattrs);
                this.symmetryPoints.addChild((Node)symmside);
            }
        }
        this.addChild((Node)this.symmetryPoints);
    }

    private void createBGPlane() {
        BranchGroup group = new BranchGroup();
        group.setCapability(17);
        Vector<Point3f> wsverts = new Vector<Point3f>();
        Vector<Point3f> normals = new Vector<Point3f>();
        Vector<Integer> stripCount = new Vector<Integer>();
        int countstrip = 0;
        for (int i = 0; i < this.planes.size(); ++i) {
            BoundPlane plane = (BoundPlane)this.planes.get(i);
            Point3f[] verts = plane.getVertices();
            if (verts.length < 3) continue;
            for (int j = 0; j < verts.length; ++j) {
                this.logger.debug("adding vertex " + verts[j] + " to plane " + i);
                wsverts.addElement(verts[j]);
                ++countstrip;
            }
            stripCount.addElement(new Integer(countstrip));
            normals.addElement(plane.getNormalVector());
            countstrip = 0;
        }
        int[] strcount = new int[stripCount.size()];
        for (int i = 0; i < strcount.length; ++i) {
            strcount[i] = (Integer)stripCount.elementAt(i);
        }
        TriangleFanArray garray = new TriangleFanArray(wsverts.size(), 7, strcount);
        garray.setCapability(3);
        Appearance app = new Appearance();
        app.setCapability(11);
        app.setCapability(15);
        app.setCapability(9);
        TransparencyAttributes tattr = new TransparencyAttributes();
        tattr.setCapability(2);
        tattr.setTransparency(this.wsattrs.planeTransparency);
        if (this.wsattrs.planeTransparency == 0.0f) {
            tattr.setTransparencyMode(4);
        } else {
            tattr.setTransparencyMode(2);
        }
        app.setTransparencyAttributes(tattr);
        PolygonAttributes pattr = new PolygonAttributes();
        pattr.setCullFace(0);
        pattr.setPolygonMode(2);
        pattr.setBackFaceNormalFlip(true);
        app.setPolygonAttributes(pattr);
        int count = 0;
        for (int i = 0; i < strcount.length; ++i) {
            int numstr = strcount[i];
            Color3f c3f = this.wsattrs.planeColor;
            Point3f norm = (Point3f)normals.get(i);
            for (int j = 0; j < numstr; ++j) {
                Point3f p3 = (Point3f)wsverts.get(count);
                garray.setCoordinate(count, p3);
                garray.setColor(count, c3f);
                ++count;
            }
        }
        Shape3D s3d = new Shape3D();
        s3d.setGeometry((Geometry)garray);
        s3d.setAppearance(app);
        group.addChild((Node)s3d);
        this.bgplane = group;
        this.addChild((Node)group);
    }

    private void createBGEdges() {
        BranchGroup edges = new BranchGroup();
        edges.setCapability(17);
        CylinderCreator cylindercreate = new CylinderCreator();
        for (int i = 0; i < this.planes.size(); ++i) {
            BoundPlane pl = (BoundPlane)this.planes.get(i);
            Side[] sides = pl.getSides();
            if (sides == null) continue;
            Appearance app = new Appearance();
            Material material = new Material();
            material.setDiffuseColor(this.wsattrs.edgeColor);
            material.setShininess(120.0f);
            app.setMaterial(material);
            for (int j = 0; j < sides.length; ++j) {
                Point3f p1 = sides[j].getPoint1();
                Point3f p2 = sides[j].getPoint2();
                Point3d d1 = new Point3d(p1);
                Point3d d2 = new Point3d(p2);
                edges.addChild((Node)cylindercreate.create(d1, d2, this.wsattrs.edgeWidth, app));
            }
        }
        this.bgedge = edges;
        this.addChild((Node)edges);
    }

    private void createBGAxis() {
        Point3d gam = new Point3d();
        Point3d ad = new Point3d(this.avec);
        Point3d bd = new Point3d(this.bvec);
        Point3d cd = new Point3d(this.cvec);
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        Appearance app = new Appearance();
        Material material = new Material();
        material.setDiffuseColor(this.wsattrs.axisColor);
        material.setShininess(120.0f);
        app.setMaterial(material);
        CylinderCreator cylindercreate = new CylinderCreator();
        bg.addChild((Node)cylindercreate.create(gam, ad, this.wsattrs.axisWidth, (float)this.wsattrs.axisWidth * 4.0f, (float)this.wsattrs.axisWidth * 8.0f, app));
        bg.addChild((Node)cylindercreate.create(gam, bd, this.wsattrs.axisWidth, (float)this.wsattrs.axisWidth * 4.0f, (float)this.wsattrs.axisWidth * 8.0f, app));
        bg.addChild((Node)cylindercreate.create(gam, cd, this.wsattrs.axisWidth, (float)this.wsattrs.axisWidth * 4.0f, (float)this.wsattrs.axisWidth * 8.0f, app));
        this.bgaxis = bg;
        this.addChild((Node)bg);
    }
}

