/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.fbz;

import ciss.phase_viewer.acviewer.fbz.SymmetryPoint;
import ciss.phase_viewer.acviewer.fbz.SymmetryPointBG;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzCell;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.behaviors.PickMouseBehavior;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import org.apache.log4j.Logger;

public class SymmetryPointPicker
extends PickMouseBehavior {
    private Logger logger = Logger.getLogger(SymmetryPointPicker.class.getName());
    private WignerSeitzCell wscell;

    public SymmetryPointPicker(Canvas3D canvas, BranchGroup root, Bounds bounds, WignerSeitzCell wscell) {
        super(canvas, root, bounds);
        this.setSchedulingBounds(bounds);
        this.pickCanvas.setMode(512);
        this.wscell = wscell;
    }

    public void processStimulus(Enumeration criteria) {
        AWTEvent[] evt = null;
        int xpos = 0;
        int ypos = 0;
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            evt = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
        }
        if (evt == null) {
            return;
        }
        MouseEvent mevent = null;
        if (evt[0] instanceof MouseEvent) {
            mevent = (MouseEvent)evt[0];
        }
        if (mevent == null) {
            return;
        }
        if (mevent.getButton() == 1) {
            xpos = mevent.getPoint().x;
            ypos = mevent.getPoint().y;
            this.update(xpos, ypos);
        } else if (mevent.getButton() == 2) {
            this.wscell.removeAllSymmetryLines();
        }
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    private boolean update(int xpos, int ypos) {
        this.pickCanvas.setShapeLocation(xpos, ypos);
        PickResult[] result = this.pickCanvas.pickAllSorted();
        if (result == null) {
            this.logger.debug("SymmetryPointPicker returned null.");
            return false;
        }
        for (int i = 0; i < result.length; ++i) {
            Primitive pri = (Primitive)result[i].getNode(4);
            if (pri == null || !(pri instanceof SymmetryPoint)) continue;
            SymmetryPoint obj = (SymmetryPoint)pri;
            SymmetryPointBG bg = obj.getParentBG();
            this.logger.debug("symm. point: " + (Object)((Object)bg));
            this.wscell.doSymmetricPoint(bg);
            return true;
        }
        return false;
    }

    public void updateScene(int xpos, int ypos) {
    }
}

