/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.XYDataset;
import org.jfree.data.XisSymbolic;
import org.jfree.data.YisSymbolic;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.util.PublicCloneable;

public class SymbolicXYItemLabelGenerator
implements XYItemLabelGenerator,
XYToolTipGenerator,
Cloneable,
PublicCloneable,
Serializable {
    public String generateToolTip(XYDataset data, int series, int item) {
        String x;
        Number n;
        String y;
        if (data instanceof YisSymbolic) {
            y = ((YisSymbolic)((Object)data)).getYSymbolicValue(series, item);
        } else {
            n = data.getYValue(series, item);
            y = Double.toString(SymbolicXYItemLabelGenerator.round(n.doubleValue(), 2));
        }
        if (data instanceof XisSymbolic) {
            x = ((XisSymbolic)((Object)data)).getXSymbolicValue(series, item);
        } else if (data instanceof TimeSeriesCollection) {
            RegularTimePeriod p = ((TimeSeriesCollection)data).getSeries(series).getTimePeriod(item);
            x = p.toString();
        } else {
            n = data.getXValue(series, item);
            x = Double.toString(SymbolicXYItemLabelGenerator.round(n.doubleValue(), 2));
        }
        return "X: " + x + ", Y: " + y;
    }

    public String generateItemLabel(XYDataset dataset, int series, int category) {
        return null;
    }

    private static double round(double value, int nb) {
        if (nb <= 0) {
            return Math.floor(value + 0.5);
        }
        double p = Math.pow(10.0, nb);
        double tempval = Math.floor(value * p + 0.5);
        return tempval / p;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return o instanceof SymbolicXYItemLabelGenerator;
    }
}

