/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.MoFile;
import AbinitMp.Common.BaseWindow;
import AbinitMp.Display.ColorMap;
import AbinitMp.Display.IsosurfaceValue;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyComboBox;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyRadioButton;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Tool.MySlider;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.FileItem;
import AbinitMp.Viewer.MoGraphPanel;
import AbinitMp.Viewer.SectionAssignWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;

public class MoGraphWindow
extends BaseWindow {
    private AbinitMpViewer viewer;
    private MoGraphPanel graphPanel;
    private ImageIcon plusIcon;
    private ImageIcon plusOnIcon;
    private ImageIcon minusIcon;
    private ImageIcon minusOnIcon;
    private JButton plusButton;
    private JButton minusButton;
    private JLabel energyLabel;
    private MyComboBox lineWidthComboBox;
    private MyComboBox colorComboBox;
    private int scaleFlag = 0;
    private JViewport viewport;
    private JScrollBar scrollbar;
    private JTextField valueText;
    private JTextField moNoText;
    private MyButton colorMinusButton;
    private MyButton colorPlusButton;
    private MySlider transSlider;
    private IsosurfaceValue isosurfaceValue;
    private MoGraphWindow me;
    private MoFile moFile;
    private FileItem fileItem;
    private MyRadioButton bboxOnRadioButton;
    private MyRadioButton bboxOffRadioButton;
    private MyButton bboxColorButton;
    private String[] colorLabel = new String[]{"Color(-,+)", "Color(+,-)", "Min,Max"};
    private int colorLableFlag = 0;
    private int displayMoNo;
    private SectionAssignWindow sectionAssignWindow;
    private JTextField minText;
    private JTextField maxText;

    public MoGraphWindow(AbinitMpViewer abinitMpViewer, FileItem fileItem) {
        super(MyResourceBundle.getResourceString("MoGraphWindow.Title"));
        Serializable serializable;
        this.viewer = abinitMpViewer;
        this.fileItem = fileItem;
        this.moFile = (MoFile)fileItem.file;
        this.isosurfaceValue = fileItem.isosurfaceValue;
        this.isosurfaceValue.value = 0.05f;
        this.isosurfaceValue.transparency = 50;
        this.me = this;
        Container container = this.getContentPane();
        container.remove(this.messagePanel);
        this.getJMenuBar().add(this.addMenuItem("MoGraphWindow.fileMenuTitle", "MoGraphWindow.fileMenu", (Action)new fileListener()));
        this.graphPanel = new MoGraphPanel(this, fileItem);
        JScrollPane jScrollPane = new JScrollPane(this.graphPanel, 22, 32);
        this.viewport = jScrollPane.getViewport();
        this.scrollbar = jScrollPane.getVerticalScrollBar();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)jScrollPane, "Center");
        FlowLayout flowLayout = new FlowLayout(0);
        MyPanel myPanel = new MyPanel(flowLayout);
        String string = "MO " + this.moFile.moNumber[0] + "-" + this.moFile.moNumber[this.moFile.moNumber.length - 1] + "  ";
        myPanel.add(new JLabel(string));
        if (this.moFile.homo != -1) {
            string = "HOMO : " + this.moFile.homo;
            serializable = new JLabel(string);
            serializable.setForeground(Color.red);
            myPanel.add((Component)serializable);
        }
        if (this.moFile.lumo != -1) {
            string = "LUMO : " + this.moFile.lumo;
            serializable = new JLabel(string);
            serializable.setForeground(Color.blue);
            myPanel.add((Component)serializable);
        }
        this.plusIcon = new ImageIcon(this.getClass().getResource("/AbinitMp/images/plus.gif"));
        this.minusIcon = new ImageIcon(this.getClass().getResource("/AbinitMp/images/minus.gif"));
        this.plusButton = new JButton(this.plusIcon);
        this.minusButton = new JButton(this.minusIcon);
        serializable = new Insets(0, 0, 0, 0);
        this.plusButton.setMargin((Insets)serializable);
        this.minusButton.setMargin((Insets)serializable);
        myPanel.add(this.plusButton);
        myPanel.add(this.minusButton);
        this.plusButton.addActionListener(new plusListener());
        this.minusButton.addActionListener(new minusListener());
        JPanel jPanel = new JPanel(flowLayout);
        jPanel.add(new JLabel("Line Width "));
        MyComboBox myComboBox = new MyComboBox(new String[]{"1", "3", "5"});
        myComboBox.setSelectedIndex(1);
        jPanel.add(myComboBox);
        myComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                MoGraphWindow.this.graphPanel.setHeight(jComboBox.getSelectedIndex() * 2 + 1);
            }
        });
        this.energyLabel = new JLabel();
        jPanel.add(this.energyLabel);
        GridBagLayoutPanel gridBagLayoutPanel = new GridBagLayoutPanel();
        gridBagLayoutPanel.setBorder(new TitledBorder(MyResourceBundle.getResourceString("MoGraphWindow.parameterTitle")));
        JPanel jPanel2 = new JPanel(flowLayout);
        this.moNoText = new JTextField();
        this.moNoText.setPreferredSize(new Dimension(50, 25));
        this.valueText = new JTextField();
        this.valueText.setPreferredSize(new Dimension(50, 25));
        this.valueText.setText(Float.toString(this.isosurfaceValue.value));
        jPanel2.add(new MyLabel(MyResourceBundle.getResourceString("MoGraphWindow.moNo")));
        jPanel2.add(this.moNoText);
        jPanel2.add(new MyLabel(MyResourceBundle.getResourceString("MoGraphWindow.value")));
        jPanel2.add(this.valueText);
        gridBagLayoutPanel.layoutObject(jPanel2, 0, 0, 20, 1, 1.0, 0.0);
        this.colorComboBox = new MyComboBox(this.colorLabel);
        this.colorComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    if (Integer.parseInt(MoGraphWindow.this.moNoText.getText()) == MoGraphWindow.this.displayMoNo && itemEvent.getStateChange() == 1) {
                        MoGraphWindow.this.drawMo();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        colorListener colorListener2 = new colorListener();
        gridBagLayoutPanel.layoutObject(this.colorComboBox, 0, 2, 5, 1, 1.0, 0.0);
        JPanel jPanel3 = new JPanel(flowLayout);
        this.colorMinusButton = new MyButton();
        this.colorMinusButton.setPreferredSize(new Dimension(20, 25));
        this.colorMinusButton.setBackground(this.isosurfaceValue.colorMinus.get());
        this.colorMinusButton.addActionListener(colorListener2);
        this.colorPlusButton = new MyButton();
        this.colorPlusButton.setPreferredSize(new Dimension(20, 25));
        this.colorPlusButton.setBackground(this.isosurfaceValue.colorPlus.get());
        this.colorPlusButton.addActionListener(colorListener2);
        jPanel3.add(this.colorMinusButton);
        jPanel3.add(this.colorPlusButton);
        jPanel3.add(new JLabel("Min"));
        this.minText = new JTextField("-0.1");
        this.minText.setPreferredSize(new Dimension(40, 25));
        this.maxText = new JTextField("0.1");
        this.maxText.setPreferredSize(new Dimension(40, 25));
        jPanel3.add(this.minText);
        jPanel3.add(new JLabel("Max"));
        jPanel3.add(this.maxText);
        gridBagLayoutPanel.layoutObject(jPanel3, 6, 2, 0, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(new MyLabel(MyResourceBundle.getResourceString("MoGraphWindow.transparency")), 0, 3, 5, 1, 1.0, 0.0);
        MyPanel myPanel2 = new MyPanel();
        this.transSlider = new MySlider(0, 100, 0);
        this.transSlider.setPreferredSize(new Dimension(120, 40));
        this.transSlider.setPaintTicks(true);
        this.transSlider.setMajorTickSpacing(50);
        this.transSlider.setPaintTrack(true);
        this.transSlider.setPaintLabels(true);
        this.transSlider.getLabelTable().put(new Integer(100), new MyLabel("100", 0));
        this.transSlider.setLabelTable(this.transSlider.getLabelTable());
        MyLabel myLabel = new MyLabel("0");
        myLabel.setPreferredSize(new Dimension(25, 28));
        this.transSlider.addChangeListener(new SliderListener(myLabel));
        this.transSlider.setValue(this.isosurfaceValue.transparency);
        myPanel2.add(this.transSlider);
        myPanel2.add(myLabel);
        gridBagLayoutPanel.layoutObject(myPanel2, 5, 3, 10, 1, 1.0, 0.0);
        this.bboxOnRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("on"));
        this.bboxOffRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("off"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.bboxOnRadioButton);
        buttonGroup.add(this.bboxOffRadioButton);
        MyPanel myPanel3 = new MyPanel(flowLayout);
        this.bboxOffRadioButton.setSelected(true);
        this.bboxColorButton = new MyButton();
        this.bboxColorButton.setPreferredSize(new Dimension(40, 25));
        this.bboxColorButton.setBackground(this.isosurfaceValue.bboxColor.get());
        this.bboxColorButton.addActionListener(colorListener2);
        myPanel3.add(this.bboxOnRadioButton);
        myPanel3.add(this.bboxColorButton);
        myPanel3.add(this.bboxOffRadioButton);
        gridBagLayoutPanel.layoutObject(new MyLabel(MyResourceBundle.getResourceString("MoGraphWindow.boundingBox")), 0, 4, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(myPanel3, 5, 4, 10, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(new MyLabel(MyResourceBundle.getResourceString("section")), 0, 5, 5, 1, 1.0, 0.0);
        MyPanel myPanel4 = new MyPanel();
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("set"));
        myPanel4.add(myButton);
        gridBagLayoutPanel.layoutObject(myPanel4, 5, 5, 10, 1, 1.0, 0.0);
        myButton.addActionListener(new sectionListener());
        GridBagLayoutPanel gridBagLayoutPanel2 = new GridBagLayoutPanel();
        JPanel jPanel4 = new JPanel(new FlowLayout(1));
        MyButton myButton2 = new MyButton(MyResourceBundle.getResourceString("draw"));
        myButton2.addActionListener(new drawListener());
        jPanel4.add(myButton2);
        gridBagLayoutPanel2.layoutObject(jPanel4, 0, 5, 0, 1, 1.0, 0.0);
        GridBagLayoutPanel gridBagLayoutPanel3 = new GridBagLayoutPanel();
        gridBagLayoutPanel3.layoutObject(myPanel, 0, 0, 1, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(jPanel, 0, 1, 1, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(gridBagLayoutPanel, 0, 2, 1, 4, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(gridBagLayoutPanel2, 0, 6, 1, 4, 1.0, 0.0);
        this.mainPanel.add((Component)gridBagLayoutPanel3, "South");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width > 2000) {
            dimension.width /= 2;
        }
        this.setBounds(dimension.width - 320, 0, 320, 770);
    }

    private void drawMo() {
        try {
            this.isosurfaceValue.moNo = Integer.parseInt(this.moNoText.getText());
            this.isosurfaceValue.value = Float.parseFloat(this.valueText.getText());
        }
        catch (Exception exception) {
            return;
        }
        this.isosurfaceValue.transparency = this.transSlider.getValue();
        this.isosurfaceValue.boundingBox = this.bboxOnRadioButton.isSelected();
        this.isosurfaceValue.bboxColor = new Color3f(this.bboxColorButton.getBackground());
        this.displayMoNo = this.isosurfaceValue.moNo;
        if (this.colorComboBox.getSelectedIndex() == 0) {
            this.isosurfaceValue.colorMinus = new Color3f(this.colorMinusButton.getBackground());
            this.isosurfaceValue.colorPlus = new Color3f(this.colorPlusButton.getBackground());
        } else if (this.colorComboBox.getSelectedIndex() == 1) {
            this.isosurfaceValue.colorMinus = new Color3f(this.colorPlusButton.getBackground());
            this.isosurfaceValue.colorPlus = new Color3f(this.colorMinusButton.getBackground());
        } else {
            ColorMap colorMap = new ColorMap(Float.parseFloat(this.minText.getText()), Float.parseFloat(this.maxText.getText()), 1, 2);
            this.isosurfaceValue.colorMinus = new Color3f(colorMap.getRgb(-this.isosurfaceValue.value));
            this.isosurfaceValue.colorPlus = new Color3f(colorMap.getRgb(this.isosurfaceValue.value));
        }
        this.moFile.readMoData(this.isosurfaceValue.moNo);
        this.viewer.createNode(this.fileItem, null);
        this.viewer.addMessageln("Display Isosurface MO No." + this.isosurfaceValue.moNo + " value " + this.isosurfaceValue.value);
    }

    public void setViewportSize(Dimension dimension) {
        float f = (float)(this.scrollbar.getValue() + this.scrollbar.getVisibleAmount() / 2) / (float)this.scrollbar.getMaximum();
        this.viewport.setViewSize(dimension);
        this.scrollbar.setValue((int)((float)this.scrollbar.getMaximum() * f - (float)(this.scrollbar.getVisibleAmount() / 2)));
    }

    public void displayEnergy(String string) {
        this.energyLabel.setText(string);
    }

    public void setMoNo(int n) {
        this.moNoText.setText(Integer.toString(n));
    }

    class minusListener
    extends AbstractAction {
        minusListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MoGraphWindow.this.graphPanel.scaleDown();
        }
    }

    class plusListener
    extends AbstractAction {
        plusListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MoGraphWindow.this.graphPanel.scaleUp();
        }
    }

    class fileListener
    extends AbstractAction {
        fileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("MoGraphWindow.fileMenu");
            char c = string.charAt(0);
            if (MoGraphWindow.this.getNemonic(stringArray[0]) == c) {
                MoGraphWindow.this.setVisible(false);
            }
        }
    }

    private class SliderListener
    implements ChangeListener {
        MyLabel tf;

        public SliderListener(MyLabel myLabel) {
            this.tf = myLabel;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MySlider mySlider = (MySlider)changeEvent.getSource();
            this.tf.setText(" " + mySlider.getValue());
        }
    }

    private class colorListener
    implements ActionListener {
        private colorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MyButton myButton = (MyButton)actionEvent.getSource();
            Color color = myButton.getBackground();
            color = JColorChooser.showDialog(MoGraphWindow.this.me, "Color", color);
            if (color != null) {
                myButton.setBackground(color);
            }
        }
    }

    private class sectionListener
    implements ActionListener {
        private sectionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (((MoGraphWindow)MoGraphWindow.this).fileItem.isosurfaceValue.sectionAssignWindow == null) {
                MoGraphWindow.this.sectionAssignWindow = new SectionAssignWindow(MoGraphWindow.this.viewer, MoGraphWindow.this.fileItem, MoGraphWindow.this.isosurfaceValue);
                ((MoGraphWindow)MoGraphWindow.this).fileItem.isosurfaceValue.sectionAssignWindow = MoGraphWindow.this.sectionAssignWindow;
            }
            MoGraphWindow.this.sectionAssignWindow.setVisible(true);
        }
    }

    private class drawListener
    implements ActionListener {
        private drawListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MoGraphWindow.this.drawMo();
        }
    }
}

