/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BoundedRangeModel;

public class FileReaderWithProgressBar
extends FileInputStream {
    private BoundedRangeModel m_model;
    private long m_bytesRead = 0L;
    private long m_fileLength;
    private long m_modelRange;
    private int m_modelMin;

    public FileReaderWithProgressBar(String string, BoundedRangeModel boundedRangeModel) throws FileNotFoundException {
        super(string);
        this.m_fileLength = new File(string).length();
        if (this.m_fileLength == 0L) {
            this.m_fileLength = 1L;
        }
        this.m_model = boundedRangeModel;
        this.m_modelMin = boundedRangeModel.getMinimum();
        this.m_modelRange = boundedRangeModel.getMaximum() - this.m_modelMin;
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.m_bytesRead;
        }
        this.updateModel();
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        if (n > 0) {
            this.m_bytesRead += (long)n;
        }
        this.updateModel();
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.m_bytesRead += (long)n3;
        }
        this.updateModel();
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this.m_bytesRead += l;
        this.updateModel();
        return l2;
    }

    private void updateModel() {
        long l = this.m_modelRange * this.m_bytesRead / this.m_fileLength;
        this.m_model.setValue(this.m_modelMin + (int)l);
    }
}

