/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.share.object;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.share.object.ShareNode;
import org.cybergarage.x3d.util.Debug;

public class ShareNodeAdd
extends ShareNode {
    public ShareNodeAdd() {
    }

    public ShareNodeAdd(Node node) {
        super(node);
    }

    public boolean writeData(ObjectOutputStream out) throws IOException {
        Debug.message("ShareNodeAdd::writeData");
        Node node = this.getNode();
        boolean isParentNodeRootNode = this.isParentNodeRootNode();
        String parentNodeName = this.getParentNodeName();
        Debug.message("  node = " + node);
        Debug.message("  parentNodeName = " + parentNodeName);
        Debug.message("  isParentNodeRootNode = " + isParentNodeRootNode);
        out.writeObject(node);
        out.writeObject(parentNodeName);
        out.writeBoolean(isParentNodeRootNode);
        return true;
    }

    public boolean readData(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Debug.message("ShareNodeAdd::readData");
        Node node = (Node)in.readObject();
        String parentNodeName = (String)in.readObject();
        boolean isParentNodeRootNode = in.readBoolean();
        Debug.message("  node = " + node);
        Debug.message("  parentNodeName = " + parentNodeName);
        Debug.message("  isParentNodeRootNode = " + isParentNodeRootNode);
        this.setParentNodeRootNodeFlag(isParentNodeRootNode);
        this.setParentNodeName(parentNodeName);
        this.setNode(node);
        return true;
    }

    public boolean update(SceneGraph sg) {
        Debug.message("ShareNodeAdd.update");
        if (sg == null) {
            return false;
        }
        boolean isParentNodeRootNode = this.isParentNodeRootNode();
        String parentNodeName = this.getParentNodeName();
        Node addNode = this.getNode();
        Debug.message("  addNode = " + addNode);
        Debug.message("  parentNodeName = " + parentNodeName);
        Debug.message("  isParentNodeRootNode = " + isParentNodeRootNode);
        if (addNode == null) {
            return false;
        }
        if (!isParentNodeRootNode) {
            Node parentNode = sg.findNode(parentNodeName);
            if (parentNode == null) {
                return false;
            }
            parentNode.addChildNode(addNode, false);
        } else {
            sg.addNode(addNode, false);
        }
        sg.initialize();
        sg.print();
        return true;
    }
}

