/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFFloat;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.field.SFInt32;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.ComposedGeometryNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NormalNode;
import org.cybergarage.x3d.node.TextureCoordinateNode;
import org.cybergarage.x3d.util.Debug;

public class ElevationGridNode
extends ComposedGeometryNode {
    private static final String setHeightEventInName = "height";
    private static final String xDimensionFieldName = "xDimension";
    private static final String zDimensionFieldName = "zDimension";
    private static final String xSpacingFieldName = "xSpacing";
    private static final String zSpacingFieldName = "zSpacing";
    private static final String heightFieldName = "height";
    private static final String creaseAngleFieldName = "creaseAngle";
    private SFFloat xSpacingField;
    private SFFloat zSpacingField;
    private SFInt32 xDimensionField;
    private SFInt32 zDimensionField;
    private SFFloat creaseAngleField;
    private MFFloat heightField;
    private MFFloat setHeightField;

    public ElevationGridNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.ELEVATIONGRID);
        this.xSpacingField = new SFFloat(0.0f);
        this.addField(xSpacingFieldName, this.xSpacingField);
        this.zSpacingField = new SFFloat(0.0f);
        this.addField(zSpacingFieldName, this.zSpacingField);
        this.xDimensionField = new SFInt32(0);
        this.addField(xDimensionFieldName, this.xDimensionField);
        this.zDimensionField = new SFInt32(0);
        this.addField(zDimensionFieldName, this.zDimensionField);
        this.creaseAngleField = new SFFloat(0.0f);
        this.creaseAngleField.setName(creaseAngleFieldName);
        this.addField(this.creaseAngleField);
        this.heightField = new MFFloat();
        this.addField("height", this.heightField);
        this.setHeightField = new MFFloat();
        this.addEventIn("height", this.setHeightField);
    }

    public ElevationGridNode(ElevationGridNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFFloat getSetHeightField() {
        if (!this.isInstanceNode()) {
            return this.setHeightField;
        }
        return (MFFloat)this.getEventIn("height");
    }

    public void addSetHeight(float value) {
        this.getSetHeightField().addValue(value);
    }

    public int getNSetHeights() {
        return this.getSetHeightField().getSize();
    }

    public void setSetHeight(int index, float value) {
        this.getSetHeightField().set1Value(index, value);
    }

    public void setSetHeights(String value) {
        this.getSetHeightField().setValues(value);
    }

    public void setSetHeights(String[] value) {
        this.getSetHeightField().setValues(value);
    }

    public float getSetHeight(int index) {
        return this.getSetHeightField().get1Value(index);
    }

    public void removeSetHeight(int index) {
        this.getSetHeightField().removeValue(index);
    }

    public SFFloat getXSpacingField() {
        if (!this.isInstanceNode()) {
            return this.xSpacingField;
        }
        return (SFFloat)this.getField(xSpacingFieldName);
    }

    public void setXSpacing(float value) {
        this.getXSpacingField().setValue(value);
    }

    public void setXSpacing(String value) {
        this.getXSpacingField().setValue(value);
    }

    public float getXSpacing() {
        return this.getXSpacingField().getValue();
    }

    public SFFloat getZSpacingField() {
        if (!this.isInstanceNode()) {
            return this.zSpacingField;
        }
        return (SFFloat)this.getField(zSpacingFieldName);
    }

    public void setZSpacing(float value) {
        this.getZSpacingField().setValue(value);
    }

    public void setZSpacing(String value) {
        this.getZSpacingField().setValue(value);
    }

    public float getZSpacing() {
        return this.getZSpacingField().getValue();
    }

    public SFInt32 getXDimensionField() {
        if (!this.isInstanceNode()) {
            return this.xDimensionField;
        }
        return (SFInt32)this.getField(xDimensionFieldName);
    }

    public void setXDimension(int value) {
        this.getXDimensionField().setValue(value);
    }

    public void setXDimension(String value) {
        this.getXDimensionField().setValue(value);
    }

    public int getXDimension() {
        return this.getXDimensionField().getValue();
    }

    public SFInt32 getZDimensionField() {
        if (!this.isInstanceNode()) {
            return this.zDimensionField;
        }
        return (SFInt32)this.getField(zDimensionFieldName);
    }

    public void setZDimension(int value) {
        this.getZDimensionField().setValue(value);
    }

    public void setZDimension(String value) {
        this.getZDimensionField().setValue(value);
    }

    public int getZDimension() {
        return this.getZDimensionField().getValue();
    }

    public SFFloat getCreaseAngleField() {
        if (!this.isInstanceNode()) {
            return this.creaseAngleField;
        }
        return (SFFloat)this.getField(creaseAngleFieldName);
    }

    public void setCreaseAngle(float value) {
        this.getCreaseAngleField().setValue(value);
    }

    public void setCreaseAngle(String value) {
        this.getCreaseAngleField().setValue(value);
    }

    public float getCreaseAngle() {
        return this.getCreaseAngleField().getValue();
    }

    public MFFloat getHeightField() {
        if (!this.isInstanceNode()) {
            return this.heightField;
        }
        return (MFFloat)this.getField("height");
    }

    public void addHeight(float value) {
        this.getHeightField().addValue(value);
    }

    public int getNHeights() {
        return this.getHeightField().getSize();
    }

    public void setHeight(int index, float value) {
        this.getHeightField().set1Value(index, value);
    }

    public void setHeights(String value) {
        this.getHeightField().setValues(value);
    }

    public void setHeights(String[] value) {
        this.getHeightField().setValues(value);
    }

    public float getHeight(int index) {
        return this.getHeightField().get1Value(index);
    }

    public void removeHeight(int index) {
        this.getHeightField().removeValue(index);
    }

    public boolean isChildNodeType(Node node) {
        return node.isColorNode() || node.isNormalNode() || node.isTextureCoordinateNode();
    }

    public void initialize() {
        super.initialize();
        this.updateColorField();
        this.updateNormalField();
        this.updateTexCoordField();
        this.updateBoundingBox();
    }

    public void uninitialize() {
    }

    public void update() {
    }

    public void outputContext(PrintWriter printStream, String indentString) {
        TextureCoordinateNode texCoord;
        ColorNode color;
        SFBool ccw = this.getCCWField();
        SFBool solid = this.getSolidField();
        SFBool colorPerVertex = this.getColorPerVertexField();
        SFBool normalPerVertex = this.getNormalPerVertexField();
        printStream.println(indentString + "\t" + "xDimension " + this.getXDimension());
        printStream.println(indentString + "\t" + "xSpacing " + this.getXSpacing());
        printStream.println(indentString + "\t" + "zDimension " + this.getZDimension());
        printStream.println(indentString + "\t" + "zSpacing " + this.getZSpacing());
        MFFloat height = this.getHeightField();
        printStream.println(indentString + "\t" + "height [");
        height.outputContext(printStream, indentString + "\t\t");
        printStream.println(indentString + "\t" + "]");
        printStream.println(indentString + "\t" + "colorPerVertex " + colorPerVertex);
        printStream.println(indentString + "\t" + "normalPerVertex " + normalPerVertex);
        printStream.println(indentString + "\t" + "ccw " + ccw);
        printStream.println(indentString + "\t" + "solid " + solid);
        printStream.println(indentString + "\t" + "creaseAngle " + this.getCreaseAngle());
        NormalNode normal = this.getNormalNodes();
        if (normal != null) {
            if (!normal.isInstanceNode()) {
                String nodeName = normal.getName();
                if (nodeName != null && 0 < nodeName.length()) {
                    printStream.println(indentString + "\t" + "normal DEF " + normal.getName() + " Normal {");
                } else {
                    printStream.println(indentString + "\t" + "normal Normal {");
                }
                normal.outputContext(printStream, indentString + "\t");
                printStream.println(indentString + "\t" + "}");
            } else {
                printStream.println(indentString + "\t" + "normal USE " + normal.getName());
            }
        }
        if ((color = this.getColorNodes()) != null) {
            if (!color.isInstanceNode()) {
                String nodeName = color.getName();
                if (nodeName != null && 0 < nodeName.length()) {
                    printStream.println(indentString + "\t" + "color DEF " + color.getName() + " Color {");
                } else {
                    printStream.println(indentString + "\t" + "color Color {");
                }
                color.outputContext(printStream, indentString + "\t");
                printStream.println(indentString + "\t" + "}");
            } else {
                printStream.println(indentString + "\t" + "color USE " + color.getName());
            }
        }
        if ((texCoord = this.getTextureCoordinateNodes()) != null) {
            if (!texCoord.isInstanceNode()) {
                String nodeName = texCoord.getName();
                if (nodeName != null && 0 < nodeName.length()) {
                    printStream.println(indentString + "\t" + "texCoord DEF " + texCoord.getName() + " TextureCoordinate {");
                } else {
                    printStream.println(indentString + "\t" + "texCoord TextureCoordinate {");
                }
                texCoord.outputContext(printStream, indentString + "\t");
                printStream.println(indentString + "\t" + "}");
            } else {
                printStream.println(indentString + "\t" + "texCoord USE " + texCoord.getName());
            }
        }
    }

    public void updateBoundingBox() {
        float xSize = (float)(this.getXDimension() - 1) * this.getXSpacing();
        float zSize = (float)(this.getZDimension() - 1) * this.getZSpacing();
        float minHeight = 0.0f;
        float maxHeight = 0.0f;
        int nHeights = this.getNHeights();
        if (0 < nHeights) {
            minHeight = maxHeight = this.getHeight(0);
            for (int n = 1; n < nHeights; ++n) {
                float height = this.getHeight(n);
                if (height < minHeight) {
                    minHeight = height;
                }
                if (!(maxHeight < height)) continue;
                maxHeight = height;
            }
        }
        this.setBoundingBoxCenter(xSize / 2.0f, (maxHeight + minHeight) / 2.0f, zSize / 2.0f);
        this.setBoundingBoxSize(xSize / 2.0f, Math.abs(maxHeight + minHeight) / 2.0f, zSize / 2.0f);
        float[] bboxCenter = this.getBoundingBoxCenter();
        float[] bboxSize = this.getBoundingBoxSize();
        Debug.message("ElevatoinGridNode::updateBoundingBox");
        Debug.message("\tbboxCenter = " + bboxCenter[0] + ", " + bboxCenter[1] + ", " + bboxCenter[2]);
        Debug.message("\tbboxSize   = " + bboxSize[0] + ", " + bboxSize[1] + ", " + bboxSize[2]);
    }

    public int getVertexCount() {
        return this.getXDimension() * this.getZDimension();
    }

    public int getNTriangleCoordIndices() {
        return 6 * (this.getXDimension() - 1) * (this.getZDimension() - 1);
    }
}

