/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.mainpanel;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.MyMessageBox;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.logger.JTextAreaAppender;
import ciss.phase_viewer.main.Main;
import ciss.phase_viewer.mainpanel.ChaseFrame;
import ciss.phase_viewer.mainpanel.ChaseInitializer;
import ciss.phase_viewer.mainpanel.ChaseMenu;
import ciss.phase_viewer.mainpanel.ChaseProgressMonitor;
import ciss.phase_viewer.mainpanel.ChaseSplitPane;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.mainpanel.Desktop4Frame;
import ciss.phase_viewer.mainpanel.FrameChase;
import ciss.phase_viewer.mainpanel.GlobalHotkeyManager;
import ciss.phase_viewer.mainpanel.LogoBooter;
import ciss.phase_viewer.mainpanel.LookandFeel;
import ciss.phase_viewer.projectbrowser.ProjectBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;
import ciss.phase_viewer.textviewer.HelpViewer;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class ChaseGUI
extends FrameChase {
    private static Logger logger = Logger.getLogger(ChaseGUI.class.getName());
    private final String FS = System.getProperty("file.separator");
    private MyMessageBox mbox;
    private Container cont;
    public JDesktopPane desktop;
    private int fontsize = 12;
    private String fonttype = "SansSerif";
    private int fontstyle = 0;
    private boolean chaseiniExists = true;
    private ChaseMenu chaseMenu;
    private static ProjectDirBrowser dirBrowser;
    private Vector components = new Vector();
    private ChaseProgressMonitor monitor;
    private final String toggleWindowString = "TOGGLE_WINDOW";
    private final KeyStroke toggleWindowKey = KeyStroke.getKeyStroke(9, 128, false);
    private final Action toggleWindowAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            ChaseGUI.this.toggleWindow(false);
            this.setEnabled(true);
        }
    };
    private final String toggleWindowRevString = "TOGGLE_WINDOW_REVERSE";
    private final KeyStroke toggleWindowRevKey = KeyStroke.getKeyStroke(9, 192, false);
    private final Action toggleWindowRevAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            ChaseGUI.this.toggleWindow(true);
            this.setEnabled(true);
        }
    };
    private final String closeWindowString = "CLOSE_WINDOW";
    private final KeyStroke closeWindowKey = KeyStroke.getKeyStroke(87, 2, false);
    private final KeyStroke closeWindowKey2 = KeyStroke.getKeyStroke(27, 0, false);
    private final Action closeWindowAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            ChaseGUI.this.closeActiveWindow();
            this.setEnabled(true);
        }
    };
    private final String closeAppString = "CLOSE_APPLICATION";
    private final KeyStroke closeAppKey = KeyStroke.getKeyStroke(81, 2, false);
    private final Action closeAppAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            ChaseGUI.this.endApplication();
            this.setEnabled(true);
        }
    };
    private final String toggleDirString = "TOGGLE_DIR_BROWSER";
    private final KeyStroke toggleDirKey = KeyStroke.getKeyStroke(84, 3, false);
    private final Action toggleDirAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            dirBrowser.requestFocus();
            this.setEnabled(true);
        }
    };
    private final String bootHelpString = "BOOT_HELP";
    private final KeyStroke bootHelpKey = KeyStroke.getKeyStroke(112, 0, false);
    private final Action bootHelpAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            HelpViewer vie = new HelpViewer();
            this.setEnabled(true);
        }
    };
    private final String selectFromProj = "SELECT_FROM_PROJECTS";
    private final KeyStroke selectFromProjKey = KeyStroke.getKeyStroke(49, 3, false);
    private final Action selectFromProjAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            ChaseGUI.selectFromProjects();
        }
    };
    private boolean loadSample = false;
    private LogoBooter lb;
    private ChaseInitializer ini;
    private String oldHosts = System.getProperty("user.home") + System.getProperty("file.separator") + ".phase-viewer" + System.getProperty("file.separator") + "hosts";
    private String currHosts = System.getProperty("user.home") + System.getProperty("file.separator") + ".phase-viewer" + System.getProperty("file.separator") + "hosts.xml";
    private JInternalFrame[] frameMap;

    void setLoadSample(boolean loadSample) {
        this.loadSample = loadSample;
    }

    void init() {
        logger.info("Welcome to PHASE-Viewer!");
        String ver = "Copyright (C)  Corporation.";
        try {
            ver = Main.getDefaultPropertiesDocument().getRootElement().getChildTextTrim("copyright");
        }
        catch (Exception exc) {
            // empty catch block
        }
        logger.info(ver);
        GlobalProperties props = PropertiesManager.getGlobalProperties(0);
        this.desktop = Desk.getDesktop();
        JScrollPane scrpanedesk = new JScrollPane(this.desktop);
        scrpanedesk.setPreferredSize(new Dimension(this.desktop.getWidth(), this.desktop.getHeight()));
        ((Desk)this.desktop).setScrollPane(scrpanedesk);
        ((Desk)this.desktop).setParentFrame(this);
        dirBrowser = new ProjectDirBrowser("projects");
        if (this.loadSample) {
            dirBrowser.loadSample();
        }
        this.mbox = new MyMessageBox();
        this.cont = this.getContentPane();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        String unit_increment = props.getProperty("desktop_scrollbar_increment");
        int unitincre = 30;
        try {
            unitincre = Integer.parseInt(unit_increment);
        }
        catch (NumberFormatException nfe) {
            unitincre = 30;
        }
        int hunit = unitincre;
        int vunit = unitincre;
        scrpanedesk.getHorizontalScrollBar().setUnitIncrement(hunit);
        scrpanedesk.getVerticalScrollBar().setUnitIncrement(vunit);
        scrpanedesk.getViewport().setScrollMode(0);
        JTextArea textarea = JTextAreaAppender.getTextArea();
        textarea.setLineWrap(true);
        textarea.setWrapStyleWord(true);
        JScrollPane scrpane = new JScrollPane(textarea);
        scrpane.setVerticalScrollBarPolicy(22);
        scrpane.setPreferredSize(new Dimension(250, 250));
        JPanel logview = new JPanel();
        logview.setLayout(new BoxLayout(logview, 0));
        JButton clearLogButton = new JButton("clear log");
        JButton logsaveButton = new JButton("save log");
        logview.add(scrpane);
        JPanel logbuttons = new JPanel();
        logbuttons.setLayout(new BoxLayout(logbuttons, 1));
        logbuttons.add(clearLogButton);
        logbuttons.add(logsaveButton);
        logview.add(logbuttons);
        JScrollPane scrDir = new JScrollPane();
        JPanel panel = new JPanel();
        scrDir.getViewport().setView(dirBrowser);
        ChaseSplitPane splitpaneDir = new ChaseSplitPane("dirselector", 1, (Component)this);
        this.components.addElement(splitpaneDir);
        splitpaneDir.setOneTouchExpandable(true);
        splitpaneDir.setLeftComponent(dirBrowser);
        splitpaneDir.setRightComponent(scrpanedesk);
        splitpaneDir.init();
        ChaseSplitPane splitpane = new ChaseSplitPane("logviewer", 0, (Component)this);
        splitpane.setTopComponent(splitpaneDir);
        splitpane.setBottomComponent(logview);
        splitpane.setContinuousLayout(true);
        splitpane.setOneTouchExpandable(true);
        splitpane.setResizeWeight(1.0);
        splitpane.init();
        JPanel foo = new JPanel();
        foo.setLayout(new BoxLayout(foo, 0));
        foo.add(splitpane);
        panel1.add(foo);
        JPanel foo1 = new JPanel();
        foo1.setLayout(new BorderLayout());
        this.monitor = ChaseProgressMonitor.getMonitor();
        foo1.add((Component)this.monitor, "West");
        panel1.add(this.monitor);
        this.cont.add(panel1);
        this.components.addElement(splitpane);
        logsaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseGUI.this.exportLog();
            }
        });
        clearLogButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseGUI.this.clearLog();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ChaseGUI.this.endApplication();
            }
        });
        GlobalProperties gp = PropertiesManager.getGlobalProperties(0);
        String me = gp.getProperty("dont_show_menu");
        if (!new Boolean(me).booleanValue()) {
            this.chaseMenu = new ChaseMenu(this);
            this.setJMenuBar(this.chaseMenu);
        }
        GlobalHotkeyManager hkmanager = GlobalHotkeyManager.getInstance();
        hkmanager.getInputMap().put(this.toggleWindowKey, "TOGGLE_WINDOW");
        hkmanager.getActionMap().put("TOGGLE_WINDOW", this.toggleWindowAction);
        hkmanager.getInputMap().put(this.toggleWindowRevKey, "TOGGLE_WINDOW_REVERSE");
        hkmanager.getActionMap().put("TOGGLE_WINDOW_REVERSE", this.toggleWindowRevAction);
        hkmanager.getInputMap().put(this.closeWindowKey, "CLOSE_WINDOW");
        hkmanager.getActionMap().put("CLOSE_WINDOW", this.closeWindowAction);
        hkmanager.getInputMap().put(this.closeAppKey, "CLOSE_APPLICATION");
        hkmanager.getActionMap().put("CLOSE_APPLICATION", this.closeAppAction);
        hkmanager.getInputMap().put(this.toggleDirKey, "TOGGLE_DIR_BROWSER");
        hkmanager.getActionMap().put("TOGGLE_DIR_BROWSER", this.toggleDirAction);
        hkmanager.getInputMap().put(this.bootHelpKey, "BOOT_HELP");
        hkmanager.getActionMap().put("BOOT_HELP", this.bootHelpAction);
        hkmanager.getInputMap().put(this.selectFromProjKey, "SELECT_FROM_PROJECTS");
        hkmanager.getActionMap().put("SELECT_FROM_PROJECTS", this.selectFromProjAction);
        if (this.lb != null) {
            this.lb.stop();
        }
        if (this.ini != null) {
            this.ini.setVisible(false);
            this.ini.dispose();
        }
        this.display(true);
    }

    private void convertHostsFile() {
        HostInfo hinfo = HostList.getHostList().getHostInfo("localhost");
        DataManager dm = new DataManager(this.oldHosts);
        dm.setWSisDelimiter(false);
        dm.parse();
        InputInterface inputInterface = dm.getInputInterface();
        inputInterface.selectRoot();
        String oldbdir = inputInterface.getInputInterfacePrimitiveEntry("localhost.basedir").getValue();
        if (oldbdir != null && oldbdir.trim().length() != 0) {
            hinfo.setProperty("basedir", oldbdir);
        }
        HostList.getHostList().save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChaseGUI(boolean splash) {
        super("PHASE-Viewer:", new Dimension(1024, 768), false);
        String chaseini = System.getProperty("user.home") + System.getProperty("file.separator") + System.getProperty("file.separator") + ".phase-viewer" + System.getProperty("file.separator") + "phase-viewer.ini";
        boolean chaseiniExists = new File(chaseini).exists();
        String version = System.getProperty("user.home") + System.getProperty("file.separator") + ".phase-viewer" + System.getProperty("file.separator") + "VERSION";
        boolean verfileExists = new File(version).exists();
        double locversion = -1.0;
        if (verfileExists) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(version));
                locversion = Double.parseDouble(reader.readLine().split(":")[1].trim());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (NumberFormatException nfe) {
            }
            catch (NullPointerException npe) {
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception io) {}
            }
        }
        logger.debug("version file: " + version + " does it exsist? " + verfileExists);
        String versionno = Main.getDefaultPropertiesDocument().getRootElement().getChildTextTrim("version");
        double currversion = Double.parseDouble(versionno);
        logger.debug("version: " + versionno);
        boolean currhostsexi = new File(this.currHosts).exists();
        boolean oldhostsexi = new File(this.oldHosts).exists();
        logger.debug("currhost exists? " + currhostsexi);
        logger.debug("oldhost exists? " + oldhostsexi);
        if (new File(this.oldHosts).exists() && !new File(this.currHosts).exists()) {
            this.convertHostsFile();
        }
        if (splash) {
            this.lb = new LogoBooter(this);
        }
        this.setInitialLookandFeel();
        if (chaseiniExists && currversion <= locversion) {
            this.init();
        } else {
            if (this.lb != null) {
                this.lb.stop();
            }
            PrintWriter verwriter = null;
            try {
                verwriter = new PrintWriter(new BufferedWriter(new FileWriter(version)));
                verwriter.println("version: " + versionno);
                verwriter.flush();
            }
            catch (Exception exc) {
                logger.error("failed write to: " + version);
            }
            finally {
                try {
                    verwriter.close();
                }
                catch (Exception exc) {}
            }
            this.ini = new ChaseInitializer(this);
        }
    }

    public ChaseMenu getMenuBarChase() {
        return this.chaseMenu;
    }

    private void toggleWindow(boolean reverse) {
        if (this.isActive()) {
            this.toggleInternalFrame(reverse);
        } else {
            Desktop4Frame.toggleFrame(reverse);
        }
    }

    private void closeActiveWindow() {
        Frame frameHeavy = Desktop4Frame.getActiveComponent();
        if (frameHeavy != null && frameHeavy != this) {
            frameHeavy.dispose();
            return;
        }
        JInternalFrame frame = this.desktop.getSelectedFrame();
        if (frame != null) {
            frame.dispose();
        }
    }

    public void display(boolean disp) {
        if (this.monitor != null) {
            this.monitor.init();
        }
        this.setVisible(disp);
        JInternalFrame[] frames = this.desktop.getAllFrames();
        if (frames != null && frames.length != 0) {
            try {
                frames[frames.length - 1].setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void endApplication() {
        this.exiting();
        this.dispose();
        System.exit(0);
    }

    public void exiting() {
        dirBrowser.saveMyProjects();
        for (int i = 0; i < this.components.size(); ++i) {
            ((ChaseFrame)this.components.elementAt(i)).saveState();
        }
    }

    public static int getScreenHeight() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        DisplayMode mode = device.getDisplayMode();
        if (mode == null) {
            return 0;
        }
        return mode.getHeight();
    }

    public static int getScreenWidth() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        DisplayMode mode = device.getDisplayMode();
        if (mode == null) {
            return 0;
        }
        return mode.getWidth();
    }

    public void setUI(String str) {
        try {
            UIManager.setLookAndFeel(str);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exc) {
            logger.error("Error loading L&F: " + str);
            exc.printStackTrace();
        }
        catch (Error er) {
            this.setUI(LookandFeel.landf_metal);
        }
    }

    static ProjectDirBrowser getProjectDirBrowser() {
        return dirBrowser;
    }

    private void updateInternalFrameMap(JInternalFrame[] frames, JInternalFrame currentFrame) {
        block4: {
            int i;
            block3: {
                if (this.frameMap != null && this.frameMap.length == frames.length) break block3;
                this.frameMap = new JInternalFrame[frames.length];
                for (int i2 = 0; i2 < this.frameMap.length; ++i2) {
                    this.frameMap[i2] = frames[i2];
                }
                break block4;
            }
            boolean found = false;
            for (i = 0; i < this.frameMap.length; ++i) {
                if (this.frameMap[i] != currentFrame) continue;
                found = true;
            }
            if (found) break block4;
            this.frameMap = new JInternalFrame[frames.length];
            for (i = 0; i < this.frameMap.length; ++i) {
                this.frameMap[i] = frames[i];
            }
        }
    }

    static void selectFromProjects() {
        JInternalFrame currFrame = Desk.getDesktop().getSelectedFrame();
        if (currFrame instanceof ProjectBrowser) {
            ((ProjectBrowser)currFrame).selectFromProjects();
        }
    }

    private void toggleInternalFrame(boolean reverse) {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        if (frames == null || frames.length == 0) {
            return;
        }
        JInternalFrame currentFrame = this.desktop.getSelectedFrame();
        if (currentFrame == null) {
            currentFrame = frames[frames.length - 1];
        }
        JInternalFrame nextFrame = null;
        this.updateInternalFrameMap(frames, currentFrame);
        if (this.frameMap.length == 1) {
            nextFrame = currentFrame;
        } else if (!reverse) {
            for (int i = 0; i < this.frameMap.length; ++i) {
                if (this.frameMap[i] != currentFrame) continue;
                nextFrame = i == this.frameMap.length - 1 ? this.frameMap[0] : this.frameMap[i + 1];
            }
        } else {
            for (int i = 0; i < this.frameMap.length; ++i) {
                if (this.frameMap[i] != currentFrame) continue;
                nextFrame = i == 0 ? this.frameMap[this.frameMap.length - 1] : this.frameMap[i - 1];
            }
        }
        try {
            nextFrame.setSelected(true);
        }
        catch (Exception exc) {
            // empty catch block
        }
    }

    private void clearLog() {
        JTextArea textArea = JTextAreaAppender.getTextArea();
        textArea.setText("");
    }

    private void exportLog() {
        JTextArea textArea = JTextAreaAppender.getTextArea();
        ChaseFileChooser filechooser = new ChaseFileChooser("log");
        filechooser.setFileSelectionMode(0);
        if (filechooser.showDialog(this, "open") != 0) {
            return;
        }
        String selectedFile = filechooser.getSelectedFile().getAbsolutePath();
        logger.info("exported log file to " + selectedFile);
        try {
            FileWriter writer = new FileWriter(new File(selectedFile));
            writer.write(textArea.getText());
            writer.flush();
            writer.close();
        }
        catch (IOException ioe) {
            logger.error("failed to export log to file : " + selectedFile);
        }
    }

    protected void setInitialLookandFeel() {
        GlobalProperties props = PropertiesManager.getGlobalProperties(0);
        try {
            int default_font_style = 1;
            String default_font_name = "Helvetica";
            int default_font_size = 11;
            default_font_name = props.getProperty("default_font_name");
            default_font_style = Integer.parseInt(props.getProperty("default_font_style"));
            default_font_size = Integer.parseInt(props.getProperty("default_font_size"));
            LookandFeel.setUIFont(default_font_name, default_font_style, default_font_size);
        }
        catch (Exception exc) {
            // empty catch block
        }
        String lf = props.getProperty("look_and_feel");
        if (lf != null && lf.length() != 0) {
            boolean failed_skin_load = false;
            if (lf.equals(LookandFeel.landf_skin)) {
                String skin = props.getProperty("look_and_feel_skin");
                String defaultSkin = "defaultthemepack.zip";
                if (skin != null && skin.trim().length() != 0) {
                    try {
                        SkinLookAndFeel.setSkin(SkinLookAndFeel.loadThemePack(System.getProperty("pviewer.home") + this.FS + "lib" + this.FS + "skinlf" + this.FS + skin));
                    }
                    catch (Exception ee) {
                        failed_skin_load = true;
                        logger.error("failed to load: " + skin);
                    }
                } else {
                    try {
                        SkinLookAndFeel.setSkin(SkinLookAndFeel.loadThemePack(System.getProperty("pviewer.home") + this.FS + "lib" + this.FS + "skinlf" + this.FS + defaultSkin));
                    }
                    catch (Exception ex) {
                        failed_skin_load = true;
                        logger.error("failed to load: " + defaultSkin);
                    }
                }
            }
            boolean sup = false;
            for (int i = 0; i < LookandFeel.supported_lf.length; ++i) {
                if (!LookandFeel.supported_lf[i].equals(lf)) continue;
                this.setUI(lf);
                sup = true;
                break;
            }
            if (!sup) {
                logger.error("unsupported look and feel: " + lf);
                logger.error("using default: " + LookandFeel.landf_metal);
                this.setUI(LookandFeel.landf_metal);
            } else if (failed_skin_load) {
                logger.error("unsupported skin.");
                this.setUI(LookandFeel.landf_metal);
            }
        } else if (Utils.isWindows()) {
            this.setUI(LookandFeel.landf_win);
        } else {
            this.setUI(LookandFeel.landf_metal);
        }
    }
}

