/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.symmetry;

import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import org.apache.log4j.Logger;

public class Cubic
extends BravaisLattice {
    private Logger logger = Logger.getLogger(Cubic.class.getName());

    public String getName() {
        return this.latticeSystem + " cubic";
    }

    public double[][] getPrimitiveLatticeVector() {
        if (this.latticeSystem.equals("bodycentered")) {
            return new double[][]{{-0.5 * this.a, 0.5 * this.a, 0.5 * this.a}, {0.5 * this.a, -0.5 * this.a, 0.5 * this.a}, {0.5 * this.a, 0.5 * this.a, -0.5 * this.a}};
        }
        if (this.latticeSystem.equals("facecentered")) {
            return new double[][]{{0.0, 0.5 * this.a, 0.5 * this.a}, {0.5 * this.a, 0.0, 0.5 * this.a}, {0.5 * this.a, 0.5 * this.a, 0.0}};
        }
        return new double[][]{{this.a, 0.0, 0.0}, {0.0, this.a, 0.0}, {0.0, 0.0, this.a}};
    }

    protected boolean isThisForMe(double a, double b, double c, double alpha, double beta, double gamma) {
        return this.epsilonEquals(a, b) && this.epsilonEquals(a, c) && this.epsilonEquals(alpha, 90.0) && this.epsilonEquals(beta, 90.0) && this.epsilonEquals(gamma, 90.0);
    }

    protected BravaisLattice tryToCreateBravaisLattice(double[] avec, double[] bvec, double[] cvec) {
        boolean bccc;
        boolean fccc;
        boolean scbc;
        Cubic blat = null;
        String lat = null;
        this.logger.debug("avec: " + avec[0] + " " + avec[1] + " " + avec[2]);
        boolean scba = avec[0] != 0.0 && this.epsilonEquals(avec[1], 0.0) && this.epsilonEquals(avec[2], 0.0);
        boolean scbb = this.epsilonEquals(avec[0], bvec[1]) && this.epsilonEquals(bvec[0], 0.0) && this.epsilonEquals(bvec[2], 0.0);
        boolean bl = scbc = this.epsilonEquals(avec[0], cvec[2]) && this.epsilonEquals(cvec[0], 0.0) && this.epsilonEquals(cvec[1], 0.0);
        if (scba && scbb && scbc) {
            lat = "primitive";
            blat = new Cubic();
            blat.a = avec[0];
            blat.b = avec[0];
            blat.c = avec[0];
            blat.alpha = 90.0;
            blat.beta = 90.0;
            blat.gamma = 90.0;
            blat.latticeSystem = lat;
            return blat;
        }
        boolean fcca = this.epsilonEquals(avec[0], 0.0) && !this.epsilonEquals(avec[1], 0.0) && this.epsilonEquals(avec[1], avec[2]);
        boolean fccb = this.epsilonEquals(bvec[1], 0.0) && !this.epsilonEquals(bvec[0], 0.0) && this.epsilonEquals(bvec[0], bvec[2]);
        boolean bl2 = fccc = this.epsilonEquals(cvec[2], 0.0) && !this.epsilonEquals(cvec[0], 0.0) && this.epsilonEquals(cvec[0], cvec[1]);
        if (fcca && fccb && fccc) {
            lat = "facecentered";
            blat = new Cubic();
            this.a = avec[1] * 2.0;
            this.b = avec[1] * 2.0;
            this.c = avec[1] * 2.0;
            this.alpha = 90.0;
            this.beta = 90.0;
            this.gamma = 90.0;
            this.latticeSystem = lat;
            return this;
        }
        boolean bcca = this.epsilonEquals(-avec[0], avec[1]) && this.epsilonEquals(avec[1], avec[2]);
        boolean bccb = this.epsilonEquals(bvec[0], -bvec[1]) && this.epsilonEquals(bvec[0], bvec[2]);
        boolean bl3 = bccc = this.epsilonEquals(cvec[0], -cvec[2]) && this.epsilonEquals(cvec[0], cvec[1]);
        if (bcca && bccb && bccc) {
            lat = "bodycentered";
            blat = new Cubic();
            blat.a = Math.abs(avec[0] * 2.0);
            blat.b = Math.abs(avec[0] * 2.0);
            blat.c = Math.abs(avec[0] * 2.0);
            blat.alpha = 90.0;
            blat.beta = 90.0;
            blat.gamma = 90.0;
            blat.latticeSystem = lat;
            return blat;
        }
        return null;
    }

    public String[] getLatticeSystemCandidate() {
        return new String[]{"primitive", "facecentered", "bodycentered"};
    }

    public String getCrystalSystem() {
        return "cubic";
    }
}

