/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.primitiveguis;

import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuListener;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.primitiveguis.ComboBoxPhase;
import jp.advancesoft.chase.primitiveguis.PhaseInputPanelInterface;
import jp.advancesoft.chase.primitiveguis.PrimitiveInputComponents;
import org.apache.log4j.Logger;

public class ChoicePanelPhase
extends PrimitiveInputComponents
implements PhaseInputPanelInterface {
    private ComboBoxPhase combobox;
    private static Logger logger = Logger.getLogger(ChoicePanelPhase.class.getName());
    private String[] choices;
    private String[] fullName;
    private String title;
    private Vector dupli = null;

    public ChoicePanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices, EventListener parent) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;
        this.createGUI();
        this.addListeners(parent);
    }

    public ChoicePanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices, Vector dupli, EventListener parent) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;
        this.dupli = dupli;
        this.createGUI();
        this.addListeners(parent);
    }

    public ChoicePanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;
        this.createGUI();
    }

    public ChoicePanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices, Vector dupli) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;
        this.dupli = dupli;
        this.createGUI();
    }

    private void createGUI() {
        super.setLayout(new BoxLayout(this, 0));
        this.createComboBox();
        super.add(this.combobox);
        if (this.title != null) {
            super.setBorder(new TitledBorder(this.title));
        }
    }

    private void createComboBox() {
        int i;
        this.combobox = new ComboBoxPhase(this.choices, this.inputSpecifications, this.inputInterface, false);
        String value = this.entry.getValue().trim();
        for (i = 0; i < this.choices.length; ++i) {
            logger.debug("choice at: " + i + " is " + this.choices[i]);
            if (!this.choices[i].equalsIgnoreCase(value)) continue;
            this.combobox.setSelectedIndex(i);
        }
        if (this.dupli != null) {
            for (i = 0; i < this.dupli.size(); ++i) {
                String[] d = (String[])this.dupli.get(i);
                int index = Integer.parseInt(d[0]);
                String newval = d[1];
                if (!newval.equalsIgnoreCase(value)) continue;
                this.combobox.setSelectedIndex(index);
            }
        }
    }

    public void addListeners(EventListener listener) {
        if (listener instanceof ActionListener) {
            this.combobox.addActionListener((ActionListener)listener);
        }
        if (listener instanceof PopupMenuListener) {
            this.combobox.addPopupMenuListener((PopupMenuListener)listener);
        }
    }

    public void registerDisabableGUI(int[] index, JComponent jcomponent) {
        this.combobox.removeListeners();
        this.combobox.setDisabableGUI(index, jcomponent);
        try {
            this.combobox.setSelectedIndex(this.combobox.getSelectedIndex());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.combobox.restoreListeners();
    }

    public void setEnabled(boolean enabled) {
        this.combobox.setEnabled(enabled);
    }

    public String getValue() {
        return (String)this.combobox.getSelectedItem();
    }

    public String getUnit() {
        return new String();
    }

    public JComboBox getComboBox() {
        return this.combobox;
    }
}

