/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IBaseStyle;
import hep.aida.ref.plotter.AbstractStyleParameter;
import hep.aida.ref.plotter.BooleanStyleParameter;
import hep.aida.ref.plotter.StringStyleParameter;
import hep.aida.ref.plotter.StyleListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public abstract class BaseStyle
implements IBaseStyle,
StyleListener {
    private Hashtable internalParameterHash = new Hashtable();
    private Hashtable parameterHash = new Hashtable();
    private Hashtable baseStyles = new Hashtable();
    private BaseStyle parent = null;
    private String name = "plotter";
    private ArrayList listeners = new ArrayList();

    protected BaseStyle() {
        this.initializeBaseStyle();
        this.setParent(null);
        this.addParameter(new BooleanStyleParameter("isVisible", true));
    }

    protected BaseStyle(BaseStyle style) {
        this();
        this.copyStyle(this, style);
    }

    private void copyStyle(BaseStyle newStyle, BaseStyle oldStyle) {
        Collection pars = oldStyle.parameters();
        Iterator iter = pars.iterator();
        while (iter.hasNext()) {
            AbstractStyleParameter oldPar = (AbstractStyleParameter)iter.next();
            if (!oldPar.isParameterValueSet()) {
                newStyle.setParameter(oldPar.name());
                continue;
            }
            newStyle.setParameter(oldPar.name(), oldPar.parameterValue());
        }
        String[] names = newStyle.baseStyleNames();
        for (int i = 0; i < names.length; ++i) {
            this.copyStyle(newStyle.baseStyle(names[i]), oldStyle.baseStyle(names[i]));
        }
    }

    protected abstract void initializeBaseStyle();

    protected void setName(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public Class type() {
        return this.getClass().getInterfaces()[0];
    }

    public IBaseStyle child(String name) {
        return (IBaseStyle)this.baseStyles.get(name);
    }

    public IBaseStyle[] children() {
        IBaseStyle[] children = new IBaseStyle[this.baseStyles.size()];
        Set keys = this.baseStyles.keySet();
        Iterator i = keys.iterator();
        int count = 0;
        while (i.hasNext()) {
            children[count++] = (IBaseStyle)this.baseStyles.get(i.next());
        }
        return children;
    }

    public boolean setVisible(boolean visible) {
        return this.setParameter("isVisible", String.valueOf(visible));
    }

    public boolean isVisible() {
        String isVisible = this.parameterValue("isVisible");
        return Boolean.valueOf(isVisible);
    }

    public void setParent(IBaseStyle p) {
        BaseStyle parent;
        this.parent = parent = (BaseStyle)p;
        if (parent != null) {
            Enumeration keys = this.baseStyles.keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                this.baseStyle(name).setParent(parent.baseStyle(name));
            }
        }
    }

    public BaseStyle parent() {
        return this.parent;
    }

    protected boolean addBaseStyle(IBaseStyle baseStyle, String name) {
        BaseStyle bs = (BaseStyle)baseStyle;
        bs.setName(name);
        if (this.baseStyles.get(bs.name()) != null) {
            ((BaseStyle)this.baseStyles.get(bs.name())).removeStyleListener(this);
        }
        this.baseStyles.put(bs.name(), baseStyle);
        bs.addStyleListener(this);
        if (this.parent != null) {
            bs.setParent(this.parent.baseStyle(bs.name()));
        }
        this.notifyStyleChanged();
        return true;
    }

    private BaseStyle baseStyle(String name) {
        return (BaseStyle)this.child(name);
    }

    private String[] baseStyleNames() {
        String[] names = new String[this.baseStyles.size()];
        Enumeration e = this.baseStyles.keys();
        int count = 0;
        while (e.hasMoreElements()) {
            names[count++] = (String)e.nextElement();
        }
        return names;
    }

    protected void addParameter(AbstractStyleParameter styleParameter) {
        this.addParameter(styleParameter, true);
    }

    private void addParameter(AbstractStyleParameter styleParameter, boolean isInternal) {
        String name = styleParameter.name();
        if (this.isRegisteredParameter(name)) {
            throw new IllegalArgumentException("Parameter " + styleParameter.name() + " already belongs to this style.");
        }
        if (isInternal) {
            this.internalParameterHash.put(name, styleParameter);
        }
        this.parameterHash.put(name, styleParameter);
    }

    private boolean isInternalParameter(String parameterName) {
        return this.internalParameterHash.containsKey(parameterName);
    }

    private boolean isExternalParameter(String parameterName) {
        return !this.internalParameterHash.containsKey(parameterName) && this.parameterHash.containsKey(parameterName);
    }

    private boolean isRegisteredParameter(String parameterName) {
        return this.parameterHash.containsKey(parameterName);
    }

    public AbstractStyleParameter parameter(String parName) {
        if (!this.isRegisteredParameter(parName)) {
            throw new IllegalArgumentException("Parameter with name " + parName + " does not belong to this style.");
        }
        return (AbstractStyleParameter)this.parameterHash.get(parName);
    }

    protected AbstractStyleParameter deepestSetParameter(String parName) {
        if (this.parameter(parName).isParameterValueSet() || this.parent() == null) {
            return this.parameter(parName);
        }
        return this.parent().deepestSetParameter(parName);
    }

    protected int numberOfParameters() {
        return this.parameterHash.size();
    }

    protected Collection parameters() {
        return this.parameterHash.values();
    }

    public boolean isParameterSet(String parameterName) {
        if (this.parameter(parameterName).isParameterValueSet() || this.parent() == null) {
            return this.parameter(parameterName).isParameterValueSet();
        }
        return this.parent().isParameterSet(parameterName);
    }

    public String[] availableParameterOptions(String parameterName) {
        AbstractStyleParameter par = this.parameter(parameterName);
        return par.allowedValues();
    }

    public String[] availableParameters() {
        int size = this.numberOfParameters();
        String[] pars = new String[size];
        Collection parameters = this.parameters();
        Iterator iter = parameters.iterator();
        int count = 0;
        while (iter.hasNext()) {
            pars[count++] = ((AbstractStyleParameter)iter.next()).name();
        }
        return pars;
    }

    public String parameterValue(String parameterName) {
        AbstractStyleParameter par = this.deepestSetParameter(parameterName);
        return par.parameterValue();
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean sendNotification) {
        Enumeration parKeys = this.parameterHash.keys();
        while (parKeys.hasMoreElements()) {
            this.parameter((String)parKeys.nextElement()).reset();
        }
        Enumeration keys = this.baseStyles.keys();
        while (keys.hasMoreElements()) {
            this.baseStyle((String)keys.nextElement()).reset(false);
        }
        if (sendNotification) {
            this.notifyStyleChanged();
        }
    }

    public boolean setParameter(String parameterName) {
        boolean result = false;
        if (this.isRegisteredParameter(parameterName)) {
            result = this.parameter(parameterName).setParameter();
            if (!this.isInternalParameter(parameterName)) {
                result = false;
            }
        } else {
            StringStyleParameter styleParameter = new StringStyleParameter(parameterName, null);
            this.addParameter(styleParameter, false);
        }
        this.notifyStyleChanged();
        return result;
    }

    public boolean setParameter(String parameterName, String parValue) {
        boolean result = false;
        if (this.isRegisteredParameter(parameterName)) {
            result = this.parameter(parameterName).setParameter(parValue);
            if (!this.isInternalParameter(parameterName)) {
                result = false;
            }
        } else {
            StringStyleParameter styleParameter = new StringStyleParameter(parameterName, null);
            this.addParameter(styleParameter, false);
            styleParameter.setValue(parValue);
        }
        this.notifyStyleChanged();
        return result;
    }

    protected void setParameterDefault(String parameterName, String parDefaultValue) {
        if (!this.isRegisteredParameter(parameterName)) {
            throw new IllegalArgumentException("Parameter " + parameterName + " does not exist ");
        }
        this.parameter(parameterName).setDefaultValue(parDefaultValue);
        this.notifyStyleChanged();
    }

    void addStyleListener(StyleListener listener) {
        this.listeners.add(listener);
    }

    void removeStyleListener(StyleListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    void notifyStyleChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            StyleListener listener = (StyleListener)this.listeners.get(i);
            listener.styleChanged(this);
        }
    }

    boolean hasListener(StyleListener listener) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (listener != this.listeners.get(i)) continue;
            return true;
        }
        return false;
    }

    public void styleChanged(BaseStyle style) {
        this.notifyStyleChanged();
    }
}

