/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/16, 14:38
!  AUTHOR(S): KOGA, Junichiro
!  File : EnergyPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.tools.LoadingFilePanel;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;

/**
 * F_ENFt@C̕\.
 * 
 * @author KOGA, Junichiro
 */
public class EnergyPanel extends ProjectManipulator implements
        OutputParserListener {
    private Logger logger = Logger.getLogger(EnergyPanel.class.getName());
    private OutputData output;
    private OutputData[] outputs;

    /** Creates a new instance of EnergyPanel */
    public EnergyPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void parseFinished() {
        removeAll();
        try {
            output = projectInfo.getOutputInterface().getParser("F_ENF", this)
                    .getOutputData()[0];
            if (reac) {
                outputs = projectInfo.getOutputInterface()
                        .getParser("F_ENF", this).getOutputData();
            }
            // output = parser.getOutputData()[0];
        } catch (NullPointerException npe) {
            return;
        }
        if (output == null) {
            return;
        }
        add(firstRow());
        add(projectInfo.getOutputInterface().getDataPanel("F_ENF"));
        revalidate();
    }

    private OutputParser parser;
    private ChaseFile cf;
    private boolean reac = false;
    private String[] reacfiles = null;

    public void init() {
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        cf = projectInfo.getChaseFileManager().getFile("F_ENF");
        String fname = projectInfo.getProjectDirectory()
                + System.getProperty("file.separator") + cf.getFileName();
        logger.debug("at Energy Panel: fname: " + fname);
        if (!new File(fname).exists()) {
            add(new NoFilePanel("F_ENF"));
            return;
        }
        add(new LoadingFilePanel("F_ENF"));
        if (parser == null) {
            parser = projectInfo.getOutputInterface().getParser("F_ENF", this);
        }
        reacfiles = new File(projectInfo.getProjectDirectory())
                .list(new FilenameFilter() {
                    public boolean accept(File arg0, String arg1) {
                        if (arg1.matches(cf.getFileName() + ".reac\\d+"))
                            return true;
                        if (arg1.matches(cf.getFileName() + ".converged"))
                            return true;
                        return false;
                    }
                });
        if (reacfiles != null && reacfiles.length != 0) {
            reac = true;
            logger.info("found multiple F_ENF files.");
            parser.resetFiles();
            for (int i = 0; i < reacfiles.length; i++) {
                logger.debug("F_ENF file: " + reacfiles[i]);
                parser.addFile(projectInfo.getProjectDirectory()
                        + System.getProperty("file.separator") + reacfiles[i]);
            }
        }
        parser.setParsed(false);
        parser.doParse();
    }

    public void initializeProject() {
    }

    private JComboBox combofiles;
    private JLabel type;
    private JLabel numsteps;

    private JPanel firstRow() {
        JPanel panel = new JPanel();

        panel.setBorder(new TitledBorder("info"));
        panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));

        JPanel pfile = new JPanel();
        pfile.setBorder(new TitledBorder("file name"));
        if (!reac) {
            cf = projectInfo.getChaseFileManager().getFile("F_ENF");
            JLabel file = new JLabel(cf.getFileName());
            pfile.add(file);
        } else {
            combofiles = new JComboBox(reacfiles);
            pfile.add(combofiles);
        }

        int nsteps = output.getData2D().length;
        int ndata = output.getIdentifier().length;
        JPanel pnumsteps = new JPanel();
        pnumsteps.setBorder(new TitledBorder("nsteps"));
        numsteps = new JLabel(String.valueOf(nsteps));
        pnumsteps.add(numsteps);

        JPanel ptype = new JPanel();
        ptype.setBorder(new TitledBorder("type"));
        String strtype = getDynamicsType(output);
        if (strtype.equals("NEB"))
            pnumsteps.setBorder(new TitledBorder("nreplicas"));
        // String strtype = "static calculation";
        // if (nsteps > 1 && ndata == 4) {
        // strtype = "geom. optimization";
        // }
        // if (nsteps > 1 && ndata > 4) {
        // strtype = "molecular dynamics";
        // }
        type = new JLabel(strtype);
        ptype.add(type);

        JButton btn = new JButton("boot editor");

        btn.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                String fname = projectInfo.getProjectDirectory()
                        + System.getProperty("file.separator")
                        + cf.getFileName();
                if (reac)
                    fname = projectInfo.getProjectDirectory()
                            + System.getProperty("file.separator")
                            + combofiles.getSelectedItem().toString();
                ProjectBrowserUtils.bootTextViewer(fname);
            }
        });

        if (combofiles != null) {
            combofiles.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent arg0) {
                    OutputData out = outputs[combofiles.getSelectedIndex()];
                    type.setText(getDynamicsType(out));
                }
            });
            combofiles.setSelectedIndex(0);
        }

        panel.add(pfile);
        panel.add(pnumsteps);
        panel.add(ptype);
        panel.add(btn);
        return panel;
    }

    private String getDynamicsType(OutputData out) {
        int nsteps = out.getData2D().length;
        int ndata = out.getIdentifier().length;
        numsteps.setText(String.valueOf(nsteps));
        String strtype = "static calculation";
        if (nsteps > 1 && ndata == 4) {
            strtype = "geom. optimization";
        }
        if ((nsteps > 1 && ndata > 4)
                && !out.getIdentifier()[0].startsWith("#step")) {
            strtype = "molecular dynamics";
        }
        if ((nsteps > 1 && ndata > 4)
                && out.getIdentifier()[0].startsWith("#step")) {
            strtype = "NEB";
        }
        if (combofiles != null) {
            if (combofiles.getSelectedItem().toString().endsWith("converged"))
                strtype = "geom. opt at each reac coord";
        }
        return strtype;

    }

}
