/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/16, 21:27
!  AUTHOR(S): KOGA, Junichiro
!  File : DFTUPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.AddButton;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhaseUnit;
import ciss.phase_viewer.primitiveguis.DeleteButton;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.PhaseInputPanelInterface;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author KOGA, Junichiro
 */
public class DFTUPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(DFTUPanel.class.getName());

    /** Creates a new instance of DFTUPanel */
    public DFTUPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void init() {
        setLayout(new BorderLayout());
        add(new DFTU(projectInfo), BorderLayout.NORTH);
    }

    class DFTU extends PhaseInputItems {
        protected DFTU(ProjectInfo projectInfo) {
            super(projectInfo);
        }

        public void createGUI() {
            setLayout(new GridLayout());

            JPanel phub = new JPanel();
            phub.setLayout(new BoxLayout(phub, BoxLayout.Y_AXIS));

            String[] dummyArray = new String[] { "" };

            JPanel pswitch = new JPanel();
            pswitch.setLayout(new BoxLayout(pswitch, BoxLayout.X_AXIS));

            String[] spec_sw_hub = new String[] { "accuracy.hubbard.sw_hubbard" };
            ChoicePanelPhase cpp_sw_hub = new ChoicePanelPhase(spec_sw_hub,
                    inputInterface, "include Hubbard correction", ON_OFF,
                    ON_OFF_DUPLI, this);
            String[] spec_proj_type = new String[] { "accuracy.hubbard.projector_type" };
            String[] proj_type_choices = new String[] { NO_SELECTION,
                    "atomic_orbital", "spherical_harmonics", "wannier_function" };
            ChoicePanelPhase cpp_proj_type = new ChoicePanelPhase(
                    spec_proj_type, inputInterface, "choose projector type",
                    proj_type_choices, this);
            pswitch.add(cpp_sw_hub);
            JButton btnproj = new JButton("configure projectors");
            btnproj.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    ProjectorEditor edi = new ProjectorEditor(projectInfo);
                }
            });
            pswitch.add(btnproj);

            // pswitch.add(cpp_proj_type);
            JPanel ptmp = new JPanel();
            ptmp.setLayout(new BorderLayout());
            ptmp.add(pswitch);
            phub.add(ptmp);

            JPanel phubbard = new JPanel();
            phubbard.setBorder(new TitledBorder("Hubbard"));
            phubbard.setLayout(new BoxLayout(phubbard, BoxLayout.Y_AXIS));

            String[] unitspec = { "accuracy.hubbard.projectors.units" };
            String[] unitChoice = { NO_SELECTION, "eV", "Hartree", "Rydberg" };
            ChoicePanelPhaseUnit unitchoice = new ChoicePanelPhaseUnit(
                    unitspec, inputInterface, "energy unit", unitChoice, this);
            String[] spec_hubbard = { "accuracy.hubbard.projectors" };

            TableForInputInterface hubbard_table = new TableForInputInterface(
                    spec_hubbard, inputInterface, this);

            phubbard.add(unitchoice);
            JScrollPane scrPane = new JScrollPane();
            // scrPane.setPreferredSize(new Dimension(400,100));
            JPanel phubtable = hubbard_table.getPanel();
            // phubtable.setPreferredSize(new Dimension(400,100));
            scrPane.getViewport().setView(phubtable);
            JPanel pp = new JPanel();
            pp.setLayout(new GridLayout());
            pp.setPreferredSize(new Dimension(500, 100));
            pp.add(scrPane);
            phubbard.add(pp);

            JPanel p_new_hubbard = new JPanel();
            // p_new_hubbard.setLayout(new
            // BoxLayout(p_new_hubbard,BoxLayout.X_AXIS));
            p_new_hubbard.setBorder(new TitledBorder("new hubbard correction"));
            InputPanelPhase ippno_hubbard = new InputPanelPhase(dummyArray,
                    inputInterface, "no.", InputPanelPhase.NONE, 15);
            InputPanelPhase ippueff = new InputPanelPhase(dummyArray,
                    inputInterface, "ueff", InputPanelPhase.NONE, 15);
            p_new_hubbard.add(ippno_hubbard);
            p_new_hubbard.add(ippueff);

            JPanel p_new_hubbard_btns = new JPanel();
            p_new_hubbard_btns.setLayout(new BoxLayout(p_new_hubbard_btns,
                    BoxLayout.X_AXIS));
            PhaseInputPanelInterface[] hubbard_guis = { ippno_hubbard, ippueff };
            AddButton add_hubbard = new AddButton(hubbard_table, hubbard_guis,
                    this);
            DeleteButton delete_hubbard = new DeleteButton(hubbard_table, this);
            JButton hubbard_from_file = new JButton("from file");
            hubbard_from_file.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent ae) {
                    fromFile("accuracy.hubbard", "projectors");
                }
            });
            p_new_hubbard_btns.add(add_hubbard);
            p_new_hubbard_btns.add(delete_hubbard);
            p_new_hubbard_btns.add(hubbard_from_file);
            phubbard.add(p_new_hubbard);
            phubbard.add(p_new_hubbard_btns);

            phub.add(phubbard);
            JPanel pphub = new JPanel();
            pphub.add(phub);
            add(pphub);
        }

    }

    public void initializeProject() {
    }
}
