/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/21, 17:16
!  AUTHOR(S): KOGA, Junichiro
!  File : PreparationPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.ekcal.preparationpanel;

import java.io.FileInputStream;
import java.util.Properties;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.PreparationPanelBase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;

/**
 * ekcal͕ҏWp.
 * 
 * @author
 */
public class PreparationPanel extends PreparationPanelBase {
    private Logger logger = Logger.getLogger(PreparationPanel.class.getName());
    private InputInterface inputInterface;

    /** Creates new form PreparationPanel */
    public PreparationPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    protected java.net.URL getTabbedManipulatorSpec() {
        return getClass()
                .getResource(
                        "/ciss/phase_viewer/plugins/projectmanipulator/ekcal/tabbed_manipulator_prep.xml");
    }

    protected Properties getInputCheckerProps() {
        String file = getClass()
                .getResource(
                        "/ciss/phase_viewer/plugins/projectmanipulator/ekcal/inputcheck/supported.properties")
                .getFile();
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(file));
        } catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
        return props;
    }

}
