/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/09/11, 16:14
!  AUTHOR(S): KOGA, Junichiro
!  File : AtomCoordsTranslationPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.viewer.view;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.mainpanel.InternalFrameChase;

/**
 * q̍Wi邽߂GUI; PBClɓꂽi
 * 
 * @author
 */
public class AtomCoordsTranslationPanel extends InternalFrameChase {
    private Logger logger = Logger.getLogger(AtomCoordsTranslationPanel.class
            .getName());

    private TGAtom tgatom;

    /** Creates a new instance of AtomCoordsTranslationPanel */
    public AtomCoordsTranslationPanel(TGAtom tgatom) {
        super("translation", new Dimension(350, 450));
        this.tgatom = tgatom;
        init();
        setVisible(true);
    }

    private AtomCoordsTrans subPanel;

    private void init() {
        subPanel = new AtomCoordsTrans(tgatom);

        Container container = getContentPane();
        container.setLayout(new BoxLayout(container, BoxLayout.Y_AXIS));

        JButton dismiss = new JButton("dismiss");
        dismiss.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });
        JPanel pbtn = new JPanel();
        pbtn.add(dismiss);

        container.add(subPanel);
        container.add(pbtn);
    }

    public void dispose() {
        subPanel.dispose();
        super.dispose();
    }

}
