/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/08, 14:01
!  AUTHOR(S): KOGA, Junichiro
!  File : FreqPlPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.tools;

import java.awt.Dimension;
import java.io.File;

import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.ExternalProgramPanel;
import ciss.phase_viewer.common.InputPanel;
import ciss.phase_viewer.common.Utils;

/**
 * 'freq.pl'𑀍삷GUI
 * 
 * @author
 */
public class FreqPlPanel extends ExternalProgramPanel {
    private Logger logger = Logger.getLogger(FreqPlPanel.class.getName());
    private String dir;
    private String modeData;

    /**
     * @param dir
     *            x[XfBNg[
     * @param modeData
     *            F_MODEt@C̃t@C
     */
    public FreqPlPanel(String dir, String modeData) {
        super("run freq.pl", new Dimension(400, 200));
        this.dir = dir;
        this.modeData = modeData;
    }

    private InputPanel width;
    private InputPanel height;
    private InputPanel nrep;
    private JCheckBox solid;
    private JCheckBox mol;
    private InputPanel ignored_modes;

    public JPanel createMainPanel() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, BoxLayout.Y_AXIS));
        width = new InputPanel("width", 0, 10);
        height = new InputPanel("height", 0, 10);
        nrep = new InputPanel("nrep", 0, 10);
        solid = new JCheckBox("solid");
        mol = new JCheckBox("mol");
        ignored_modes = new InputPanel("ignored_modes", 0, 10);
        JPanel row1 = new JPanel();
        // row1.setLayout(new BoxLayout(row1,BoxLayout.X_AXIS));
        row1.add(width);
        row1.add(height);
        row1.add(nrep);
        JPanel row2 = new JPanel();
        // row2.setLayout(new BoxLayout(row2,BoxLayout.X_AXIS));
        row2.add(solid);
        row2.add(mol);
        row2.add(ignored_modes);
        ret.add(row1);
        ret.add(row2);
        return ret;
    }

    public boolean createExeString() {
        String curDir = System.getProperty("user.dir");
        if (!(new File(curDir)).canWrite()) {
            logger.error("can't create tmp file ... check permission.");
            return false;
        }

        String freqpl = getPerlScript("freq.pl");

        /* set options */
        String opts = "";
        String strwidth = width.getValue();
        String strheight = height.getValue();
        String strnrep = nrep.getValue();
        boolean bsolid = solid.isSelected();
        boolean bmol = mol.isSelected();
        String strignored = ignored_modes.getValue();

        if (strwidth.trim().length() != 0) {
            opts += " -width=" + strwidth;
        }
        if (strheight.trim().length() != 0) {
            opts += " -height=" + strheight;
        }
        if (strnrep.trim().length() != 0) {
            opts += " -nrep=" + strnrep;
        }
        if (strignored.trim().length() != 0) {
            opts += " -ignored_modes=" + strignored;
        }
        if (bsolid) {
            opts += " -solid";
        }
        if (bmol) {
            opts += " -mol";
        }
        exeString = freqpl
                + " "
                + opts
                + " "
                + Utils.getPathDQ(dir + System.getProperty("file.separator")
                        + modeData);

        logger.debug(exeString);
        System.out.println("exeString: " + exeString);
        return true;
    }

    /**
     * perlXNvgs̃|Xgs. ̓Iɂ, JgfBNg[ɂepst@C
     * vWFNgfBNg[ֈڂs.
     */
    public void bootPostProcess() {
        String moveToPath = dir + FS + "freq.eps";
        String epspath = System.getProperty("user.dir")
                + System.getProperty("file.separator") + "freq.eps";
        // System.out.println("epspath: "+epspath);
        // System.out.println("moveto: "+projdir+"band_structure.eps");
        if (!epspath.trim().equalsIgnoreCase(moveToPath.trim())) {
            ExternalProgramExecuter.remove(moveToPath);
        }
        try {
            Thread.sleep(100);
        } catch (Exception e) {
        }

        ExternalProgramExecuter.move(epspath, moveToPath);
    }
}
