/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/09/02, 9:39
!  AUTHOR(S): KOGA, Junichiro
!  File : LookandFeel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.mainpanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Vector;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.UIManager;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.MyJCheckBoxMenuItem;
import ciss.phase_viewer.common.MyJMenu;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;

/**
 * manages the "look and feel" of the application.
 * 
 * @author KOGA, Junichiro
 */
public class LookandFeel extends MyJMenu {
    protected Logger logger = Logger.getLogger(LookandFeel.class.getName());
    protected GlobalProperties props = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_PVIEWER);

    public static String landf_metal = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static String landf_motif = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static String landf_win = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static String landf_skin = "com.l2fprod.gui.plaf.skin.SkinLookAndFeel";
    public static String[] supported_lf = { landf_metal, landf_motif,
            landf_win, landf_skin };

    private String FS = ConstParameters.FS;

    private MyJMenu mskin;
    private String theme;
    private String theme_full;

    private ChaseMenu parent;

    private Vector menuArray = new Vector();

    private String init_lf = "";
    private String init_skin = "";

    /** Creates a new instance of LookandFeel */
    public LookandFeel() {
        super("Look & feel", KeyEvent.VK_L);
        this.parent = parent;

        init_lf = props.getProperty("look_and_feel");
        init_skin = props.getProperty("look_and_feel_skin");

        init();
        skinLF();
    }

    private void skinLF() {
        File skinlfdir = new File(System.getProperty("pviewer.home") + FS
                + "lib" + FS + "skinlf");
        if (!skinlfdir.exists()) {
            return;
        }

        File[] skinfiles = skinlfdir.listFiles();
        if (skinfiles == null || skinfiles.length == 0) {
            logger.info("no skin found.");
            return;
        }

        for (int i = 0; i < skinfiles.length; i++) {
            theme_full = skinfiles[i].getName();
            if (!theme_full.endsWith("themepack.zip")) {
                continue;
            }
            String[] str2 = theme_full.split("themepack.zip");
            if (str2 == null || str2[0].trim().length() == 0) {
                continue;
            }

            theme = str2[0];
            MyJCheckBoxMenuItem skin = new MyJCheckBoxMenuItem(theme);
            mskin.add(skin);
            menuArray.addElement(skin);

            skin.addActionListener(new UIActionListener(skin, menuArray));
            skin.addActionListener(new SkinActionListener(skinfiles[i]
                    .getName(), this));
            if (init_skin != null && init_skin.equals(theme_full)
                    && init_lf.equals(landf_skin)) {
                skin.setState(true);
            }
        }

    }

    /**
     * vOftHgtHg̐ݒs.
     * 
     * @param name
     *            tHg
     * @param style
     *            tHgX^C (java.awt.Font.PLAINƂjava.awt.Font.BOLDȂ)
     * @param size
     *            tHg̃TCY
     */
    public static void setUIFont(String name, int style, int size) {
        java.util.Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value instanceof javax.swing.plaf.FontUIResource) {
                javax.swing.plaf.FontUIResource font = new javax.swing.plaf.FontUIResource(
                        name, style, size);
                UIManager.put(key, font);
            }
        }
    }

    private void init() {
        mskin = new MyJMenu("Skin", KeyEvent.VK_S);
        add(mskin);

        MyJCheckBoxMenuItem mmetal = new MyJCheckBoxMenuItem("Metal",
                KeyEvent.VK_M);
        mmetal.addActionListener(new UIActionListener(mmetal, menuArray));
        mmetal.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                setUI(landf_metal);
                props.setProperty("look_and_feel", landf_metal);
                props.storeProperty();
            }
        });
        menuArray.addElement(mmetal);
        add(mmetal);
        if (init_lf != null && init_lf.equals(landf_metal)) {
            mmetal.setState(true);
        }

        MyJCheckBoxMenuItem mmotif = new MyJCheckBoxMenuItem("Motif",
                KeyEvent.VK_O);
        mmotif.addActionListener(new UIActionListener(mmotif, menuArray));
        mmotif.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                setUI(landf_motif);
                props.setProperty("look_and_feel", landf_motif);
                props.storeProperty();
            }
        });
        menuArray.addElement(mmotif);
        add(mmotif);
        if (init_lf != null && init_lf.equals(landf_motif)) {
            mmotif.setState(true);
        }

        MyJCheckBoxMenuItem mwin = new MyJCheckBoxMenuItem("Windows",
                KeyEvent.VK_W);
        mwin.addActionListener(new UIActionListener(mwin, menuArray));
        mwin.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                setUI(landf_win);
                props.setProperty("look_and_feel", landf_win);
                props.storeProperty();
            }
        });
        menuArray.addElement(mwin);
        add(mwin);
        if (init_lf != null && init_lf.equals(landf_win)) {
            mwin.setState(true);
        }
    }

    protected void setUI(String str) {
        Chase.setUI(str);
    }

}

class SkinActionListener implements ActionListener {
    private String skinName;
    private String skinName_short;
    private String FS = ConstParameters.FS;
    private String landf_skin = "com.l2fprod.gui.plaf.skin.SkinLookAndFeel";
    private LookandFeel parent;
    private Logger logger = Logger.getLogger(LookandFeel.class.getName());
    private GlobalProperties props = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_PVIEWER);

    protected SkinActionListener(String skinName, LookandFeel parent) {
        this.skinName = skinName;
        skinName_short = skinName.split("themepack.zip")[0];
        this.parent = parent;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            SkinLookAndFeel.setSkin(SkinLookAndFeel.loadThemePack(System
                    .getProperty("pviewer.home")
                    + FS
                    + "lib"
                    + FS
                    + "skinlf"
                    + FS + skinName));
            Chase.setUI(landf_skin);
            logger.info("loaded skin: " + skinName_short);
        } catch (Exception ex) {
            logger.error("failed to load skin: " + skinName_short);
        }
        props.setProperty("look_and_feel", landf_skin);
        props.setProperty("look_and_feel_skin", skinName);
        props.storeProperty();
    }

}

class UIActionListener implements ActionListener {
    private JCheckBoxMenuItem menuItem;
    private Vector menuArray;

    protected UIActionListener(JCheckBoxMenuItem menuItem, Vector menuArray) {
        this.menuItem = menuItem;
        this.menuArray = menuArray;
    }

    public void actionPerformed(ActionEvent e) {
        if (menuArray == null) {
            return;
        }
        for (int i = 0; i < menuArray.size(); i++) {
            JCheckBoxMenuItem it = (JCheckBoxMenuItem) menuArray.elementAt(i);
            it.setSelected(false);
        }
        menuItem.setState(true);
    }

}
