/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/10/07, 22:59
!  AUTHOR(S): KOGA, Junichiro
!  File : UndoRedo.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.atomcoord;

import java.util.Stack;

import org.apache.log4j.Logger;

/**
 * ̃pbP[W̃f[^\pUndo/RedoNX
 * 
 * @author
 */
public class UndoRedo {
    private Logger logger = Logger.getLogger(UndoRedo.class.getName());

    private AtomList list;

    private Stack undoStack = new Stack();
    private Stack redoStack = new Stack();

    private Stack undoCount = new Stack();
    private Stack redoCount = new Stack();

    /** Creates a new instance of UndoRedo */
    public UndoRedo(AtomList list) {
        this.list = list;
    }

    /**
     * undo/redoԂɖ߂.
     */
    protected void init() {
        undoStack = new Stack();
        redoStack = new Stack();
        undoCount = new Stack();
        redoCount = new Stack();
    }

    /**
     * undoGg[𑫂. nullꂽ, Ήundo/redóu폜v
     * 
     * @param atom
     *            ݂AtomIuWFNg
     * @param index
     *            atom̃CfbNX.
     * @param mode
     *            XV, 폜, VKo^̂ꂩ
     */
    protected void addEntry(Atom atom, int index, int mode) {
        Atom copy = null;
        if (atom != null) {
            copy = atom.getCopy();
        }

        UndoRedoObject uro = new UndoRedoObject(copy, index, mode);
        undoStack.push(uro);
        redoStack.clear();
        redoCount.clear();
        logger.debug("pushed: " + uro);
    }

    /**
     * CellIuWFNgGg[肤邱Ƃɂ܂. Cell͓ ڂׂȂǂ͂ȂƎv.
     * 
     * @param cell
     *            ݂CellIuWFNg
     */
    protected void addEntry(Cell cell) {
        Cell copy = null;
        if (cell != null) {
            copy = cell.getCopy();
        }
        UndoRedoObject uro = new UndoRedoObject(copy);
        undoStack.push(uro);
        redoStack.clear();
        redoCount.clear();
    }

    /**
     * undoɂ, ܂Ŗ߂邩w肷. undoStack Ƃ͎̐Iɂ͎Ȃ̂ŗv(󂾂ꍇ,
     * 1Ƃl̗p).
     * 
     * @param count
     *            ܂Ŗ߂邩.
     */
    protected void setUndoCount(int count) {
        undoCount.push(new Integer(count));
    }

    /**
     * ԍŏ̃R}֖߂.
     * 
     * @return Xԍŏ̃R}ꍇfalseԂ.
     */
    protected boolean undoToFirstEntry() {
        if (undoStack.empty()) {
            logger.info("undo stack empty.");
            return false;
        }
        while (!undoStack.empty()) {
            undo();
        }
        return true;
    }

    /**
     * undos.
     * 
     * @return undoX^bN󂾂ꍇfalseԂ.
     */
    protected boolean undo() {
        if (undoStack.empty()) {
            logger.info("undo stack empty.");
            return false;
        }

        int count = 1;
        if (!undoCount.empty()) {
            count = ((Integer) undoCount.pop()).intValue();
        }

        for (int i = 0; i < count; i++) {
            UndoRedoObject uro = (UndoRedoObject) undoStack.pop();
            redoStack.push(doIt(undoStack, uro));
        }
        redoCount.push(new Integer(count));
        return true;
    }

    /**
     * redos.
     * 
     * @return redopX^bN󂾂ꍇfalseԂ.
     */
    protected boolean redo() {
        if (redoStack.empty()) {
            logger.info("redo stack empty.");
            return false;
        }

        int count = 1;
        if (!redoCount.empty()) {
            count = ((Integer) redoCount.pop()).intValue();
        }

        for (int i = 0; i < count; i++) {
            UndoRedoObject uro = (UndoRedoObject) redoStack.pop();
            undoStack.push(doIt(redoStack, uro));
        }
        undoCount.push(new Integer(count));
        return true;
    }

    private UndoRedoObject doIt(Stack stack, UndoRedoObject uro) {
        if (uro.isCell()) {
            Cell cell = uro.getCell();
            Cell tmpcell = list.getParent().getCell(cell.getCellScheme());
            list.getParent().setCell(cell, false);
            return new UndoRedoObject(tmpcell);
        }

        Atom atom = uro.getAtom();
        int index = uro.getIndex();
        int mode = uro.getMode();
        logger.debug("old UndoRedo: " + uro);

        if (atom == null || mode == UndoRedoObject.ADD) {
            list.removeAtomAt(index, false);
            UndoRedoObject newuro = new UndoRedoObject(atom, index,
                    UndoRedoObject.REMOVE);
            logger.debug("new UndoRedoObject: " + newuro);
            return newuro;
        }

        int retmode = UndoRedoObject.ADD;
        Atom retAtom = null;
        if (mode == UndoRedoObject.REPLACE) {
            if (index < list.size()) {
                retAtom = ((Atom) list.get(index)).getCopy();
                list.replaceAtomAt(index, atom, false);
                logger.debug("at doIt.REPLACE");
                retmode = UndoRedoObject.REPLACE;
            } else {
                retAtom = atom;
                list.addAtom(atom, false);
                logger.debug("at doIt.REPLACE");
            }
        } else if (mode == UndoRedoObject.REMOVE) {
            if (index < list.size()) {
                retAtom = atom;
                list.addAtomAt(index, atom, false);
                logger.debug("at doIt.REMOVE; index: " + index);
            } else {
                retAtom = atom;
                list.addAtom(atom, false);
                logger.debug("at doIt.REMOVE");
            }
        }

        UndoRedoObject newuro = new UndoRedoObject(retAtom, index, retmode);
        logger.debug("new UndoRedoObject: " + newuro);
        return newuro;
    }

    /**
     * svɂȂȂ邾Ăڂ
     */
    public void nullify() {
        while (!undoStack.empty()) {
            UndoRedoObject uro = (UndoRedoObject) undoStack.pop();
            uro.nullify();
        }
        undoStack = null;
        while (!redoStack.empty()) {
            UndoRedoObject uro = (UndoRedoObject) redoStack.pop();
            uro.nullify();
        }
        redoStack = null;
        list = null;
    }
}

/**
 * Undo/RedoΏۂƂȂIuWFNgJvZNX
 */
class UndoRedoObject {
    static int REPLACE = 0;
    static int REMOVE = 1;
    static int ADD = 2;

    static int ATOM = 10;
    static int CELL = 11;

    private Atom atom;
    private Cell cell;
    private int index;
    private int mode = REPLACE;
    private int atom_or_cell = ATOM;

    /**
     * ΏۂƂȂ錴q, ̃CfbNX, Ă̌qɂĂǂȑ삪sꂽ, Ƃ񂪕Kvł, RXgN^[Œ`.
     * 
     * @param atom
     *            undo/redoΏۂ̌q
     * @param index
     *            ̌q̃CfbNX
     * @param mode
     *            ǂ̂悤ȑ삪sꂽ. REPLACE, REMOVE, ADD̂ꂩ.
     */
    protected UndoRedoObject(Atom atom, int index, int mode) {
        this.atom = atom;
        this.index = index;
        this.mode = mode;
    }

    /**
     * ΏۂƂȂZɂƂRXgN^[. Z̏ꍇ͌qقǂ₱͂Ȃ.
     * 
     * @param cell
     *            undo/redoΏۂƂȂZ.
     */
    protected UndoRedoObject(Cell cell) {
        this.cell = cell;
        atom_or_cell = CELL;
    }

    /**
     * svɂȂł邾Ă
     */
    protected void nullify() {
        atom = null;
        cell = null;
    }

    /**
     * ̃IuWFNgΏۂɂĂ̂ZȂ̂ǂ𔻒.
     * 
     * @return ZȂtrue.
     */
    boolean isCell() {
        return atom_or_cell == CELL;
    }

    /**
     * ̃IuWFNgɊi[ĂCellIuWFNg擾
     * 
     * @return cell ̃IuWFNgɊi[ĂCellIuWFNg.
     */
    Cell getCell() {
        return cell;
    }

    /**
     * ̃IuWFNgɊi[ĂAtomIuWFNg擾
     * 
     * @return ̃IuWFNgɊi[ĂAtomIuWFNg
     */
    Atom getAtom() {
        return this.atom;
    }

    /**
     * ̃IuWFNgɊi[ĂAtomIuWFNg̃CfbNX擾
     * 
     * @return ̃IuWFNgɊi[ĂAtomIuWFNg̃CfbNX
     */
    int getIndex() {
        return this.index;
    }

    /**
     * ̃IuWFNgɊi[ĂAtomIuWFNgɑ΂, ǂ̂悤ȑ삪sꂽ擾
     * 
     * @return ̃IuWFNgɊi[ĂAtomIuWFNgɑ΂, ǂ̂悤ȑ삪sꂽ.
     */
    int getMode() {
        return this.mode;
    }

    public String toString() {
        String smode = "";
        if (mode == REPLACE) {
            smode = "REPLACE";
        } else if (mode == REMOVE) {
            smode = "REMOVE";
        } else if (mode == ADD) {
            smode = "ADD";
        }

        return "atom: " + atom + " index: " + index + " mode: " + smode;
    }
}
