/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : LightObject.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.PointLight;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

public class LightObject extends SceneGraphElement {
    private GlobalProperties gp = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_ACV);

    public LightObject() {
        super();
    }

    public int getType() {
        return SceneGraphElement.LIGHT;
    }

    private BranchGroup bg;
    private BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0,
            0.0), 100.0);

    public void create() {
        if (bg != null) {
            bg.detach();
        }
        bg = new BranchGroup();
        bg.setCapability(BranchGroup.ALLOW_DETACH);

        String[] light_type = new String[5];
        light_type[0] = gp.getProperty("light1_type");
        light_type[1] = gp.getProperty("light2_type");
        light_type[2] = gp.getProperty("light3_type");
        light_type[3] = gp.getProperty("light4_type");
        light_type[4] = gp.getProperty("light5_type");
        for (int i = 0; i < 5; i++) {
            if (light_type[i] == null || light_type[i].equals("off")) {
                continue;
            }
            String light_prefix = "light" + String.valueOf(i + 1) + "_";
            if (light_type[i].equals("directional")) {
                DirectionalLight light = null;
                try {
                    String[] dire = gp.getProperty(light_prefix + "direction")
                            .split(",");
                    Vector3f dir = new Vector3f(Float.parseFloat(dire[0]),
                            Float.parseFloat(dire[1]),
                            Float.parseFloat(dire[2]));
                    String[] col = gp.getProperty(light_prefix + "color")
                            .split(",");
                    Color3f co = new Color3f(Float.parseFloat(col[0]),
                            Float.parseFloat(col[1]), Float.parseFloat(col[2]));
                    light = new DirectionalLight(co, dir);
                    light.setInfluencingBounds(bounds);
                } catch (Exception exc) {
                }
                if (light != null) {
                    bg.addChild(light);
                }
            } else if (light_type[i].equals("ambient")) {
                AmbientLight light = null;
                try {
                    String[] col = gp.getProperty(light_prefix + "color")
                            .split(",");
                    Color3f co = new Color3f(Float.parseFloat(col[0]),
                            Float.parseFloat(col[1]), Float.parseFloat(col[2]));
                    light = new AmbientLight(co);
                    light.setInfluencingBounds(bounds);
                    bg.addChild(light);
                } catch (Exception exc) {
                }
            } else if (light_type[i].equals("point")) {
                PointLight light = null;
                try {
                    String[] col = gp.getProperty(light_prefix + "color")
                            .split(",");
                    Color3f co = new Color3f(Float.parseFloat(col[0]),
                            Float.parseFloat(col[1]), Float.parseFloat(col[2]));
                    String[] pos = gp.getProperty(light_prefix + "position")
                            .split(",");
                    light = new PointLight(co, new Point3f(
                            Float.parseFloat(pos[0]), Float.parseFloat(pos[1]),
                            Float.parseFloat(pos[2])), new Point3f(1.f, 0.f,
                            0.f));
                    light.setInfluencingBounds(bounds);
                    bg.addChild(light);
                } catch (Exception exc) {
                }
            }
        }
        addChild(bg);
        //
        // Color3f lColor = new Color3f(0.45f, 0.45f, 0.45f);
        // Vector3f lDir = new Vector3f(-1f, -1f, -1.0f);
        // DirectionalLight lightD1 = new DirectionalLight(lColor,lDir);
        // lightD1.setInfluencingBounds(bounds);
        // this.addChild(lightD1);
        //
        // lDir = new Vector3f(1f, 0f, -1.0f);
        // lightD1 = new DirectionalLight(lColor, lDir);
        // lightD1.setInfluencingBounds(bounds);
        // this.addChild(lightD1);
        //
        // lDir = new Vector3f(0f, 1f, -1.0f);
        // lightD1 = new DirectionalLight(lColor, lDir);
        // lightD1.setInfluencingBounds(bounds);
        // this.addChild(lightD1);
        //
        // lDir = new Vector3f(1f, 0f, +1.0f);
        // lightD1 = new DirectionalLight(lColor, lDir);
        // lightD1.setInfluencingBounds(bounds);
        // this.addChild(lightD1);
        //
        // lDir = new Vector3f(0f, 1f, +1.0f);
        // lightD1 = new DirectionalLight(lColor, lDir);
        // lightD1.setInfluencingBounds(bounds);
        // this.addChild(lightD1);

        // AmbientLight light = new AmbientLight(new Color3f(0.2f,0.2f,0.2f));
        // light.setInfluencingBounds(bounds);
        // this.addChild(light);
    }

    public void recreate() {
        create();
    }

    public void configDataUpdate() {
    }

    public void configDataUpdate(boolean foo, ConfigDataUpdateEvent e) {
    }
}
