/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.remotehostexecuter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableModel;
import jp.advancesoft.chase.common.TaggedString;
import jp.advancesoft.chase.ssh.hosts.HostInfo;
import jp.advancesoft.chase.ssh.remotehostexecuter.ChaseFile;
import jp.advancesoft.chase.ssh.remotehostexecuter.ChaseFileHolder;
import jp.advancesoft.chase.ssh.remotehostexecuter.ChaseFileProperty;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class FileTransferSchemeManager {
    private static Logger logger = Logger.getLogger(FileTransferSchemeManager.class.getName());
    private HostInfo hostinfo;
    private ChaseFileHolder parent;
    private ChaseFile[] files;
    private String localdir;
    private String targetdir;
    private Document doc;
    private File xmlfile;
    private Vector filevec = new Vector();

    public FileTransferSchemeManager(HostInfo hostinfo, ChaseFileHolder parent) {
        this.hostinfo = hostinfo;
        this.parent = parent;
        this.files = parent.getChaseFiles();
        this.init();
    }

    public FileTransferSchemeManager(HostInfo hostinfo, ChaseFileHolder parent, String localdir) {
        this.hostinfo = hostinfo;
        this.parent = parent;
        this.localdir = localdir;
        this.files = parent.getChaseFiles();
        this.init();
    }

    private void init() {
        if (this.localdir == null || this.localdir.length() == 0) {
            this.localdir = this.files[0].getFile().getParent();
        }
        boolean docvalid = true;
        this.xmlfile = new File(this.localdir + System.getProperty("file.separator") + "filetransferscheme.xml");
        if (!this.xmlfile.exists() || !this.readFromDisk()) {
            docvalid = false;
            this.doc = new Document();
            Element root = new Element("project");
            this.doc.addContent(root);
            root.addContent(this.createFileTransferElement(null));
            try {
                FileWriter writer = new FileWriter(this.xmlfile);
                XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
                outputter.output(this.doc, (Writer)writer);
            }
            catch (IOException ioe) {
                logger.error("failed to save file transfer scheme to disk.");
                ioe.printStackTrace();
                return;
            }
            logger.info("saved filetransferinfo.");
        }
    }

    Element createFileTransferElement(TableModel tableModel) {
        int j2;
        if (tableModel != null) {
            int row = tableModel.getRowCount();
            int col = tableModel.getColumnCount();
            for (int i = 0; i < row; ++i) {
                ChaseFileProperty[] props = this.files[i].getChaseFileProperties();
                for (j2 = 0; j2 < col; ++j2) {
                    String colname = tableModel.getColumnName(j2);
                    Object ovalue = tableModel.getValueAt(i, j2);
                    String value = "";
                    if (ovalue instanceof String) {
                        value = (String)ovalue;
                    } else if (ovalue instanceof Boolean) {
                        value = ((Boolean)ovalue).toString();
                    }
                    for (int k = 0; k < props.length; ++k) {
                        TaggedString ts = props[k].getProp();
                        if (!ts.getTag().equals(colname)) continue;
                        props[k].getProp().setValue(value);
                    }
                }
            }
        }
        Element ret = new Element("filetransferscheme");
        ret.setAttribute("hostname", this.hostinfo.getName());
        ret.addContent(new Element("targetdir").addContent(this.getTargetDir()));
        for (int i = 0; i < this.files.length; ++i) {
            ChaseFileProperty[] props = this.files[i].getChaseFileProperties();
            Element elemfile = new Element("file");
            for (j2 = 0; j2 < props.length; ++j2) {
                TaggedString ts = props[j2].getProp();
                String value = null;
                try {
                    value = ts.getValue();
                }
                catch (NullPointerException npe) {
                    continue;
                }
                String ident = ts.getTag();
                if (props[j2].getAttrorElem() == 1) {
                    elemfile.setAttribute(new Attribute(ident, value));
                }
                if (props[j2].getAttrorElem() != 0) continue;
                elemfile.addContent(new Element(ident).addContent(value));
            }
            ret.addContent(elemfile);
        }
        return ret;
    }

    static Element getCorrespondingElement(Document doc, File xmlfile, HostInfo hostinfo, ChaseFileHolder cfholder) {
        Element root = doc.getRootElement();
        List children = root.getChildren();
        if (children == null) {
            logger.debug("no 'filetransferscheme'");
            return null;
        }
        int numscheme = children.size();
        if (numscheme == 0) {
            logger.debug("no scheme.");
            return null;
        }
        boolean found = false;
        Element filetransferinfo = null;
        for (int i = 0; i < numscheme; ++i) {
            Element element = (Element)children.get(i);
            String str = element.getName();
            if (!str.equals("filetransferscheme") || !element.getAttribute("hostname").getValue().equals(hostinfo.getName())) continue;
            found = true;
            filetransferinfo = element;
            logger.debug("found " + hostinfo.getName());
            break;
        }
        if (!found) {
            return null;
        }
        ChaseFile[] cfiles = cfholder.getChaseFiles();
        if (cfiles == null) {
            return null;
        }
        List fileElements = filetransferinfo.getChildren("file");
        if (fileElements.size() != cfiles.length) {
            return null;
        }
        for (int i = 0; i < fileElements.size(); ++i) {
            String filenameFromCF;
            String filenameFromFile = ((Element)fileElements.get(i)).getChild("filename").getTextTrim();
            if (filenameFromFile.equals(filenameFromCF = cfiles[i].getChaseFileProperty("filename").getProp().getValue().trim())) continue;
            ((Element)fileElements.get(i)).getChild("filename").setText(filenameFromCF);
        }
        return filetransferinfo;
    }

    private boolean readFromDisk() {
        int i;
        SAXBuilder builder = new SAXBuilder();
        try {
            this.doc = builder.build(this.xmlfile);
        }
        catch (JDOMException jde) {
            logger.error("failed to parse " + this.xmlfile);
            return false;
        }
        catch (IOException ioe) {
            logger.error("failed to parse " + this.xmlfile);
            return false;
        }
        Element filetransferinfo = FileTransferSchemeManager.getCorrespondingElement(this.doc, this.xmlfile, this.hostinfo, this.parent);
        if (filetransferinfo == null) {
            return false;
        }
        this.targetdir = filetransferinfo.getChildText("targetdir");
        boolean filecount = false;
        List transspecs = filetransferinfo.getChildren("file");
        int numFilesinFile = transspecs.size();
        if (numFilesinFile != this.getNumFiles()) {
            logger.info("number of files have changed ... will re-initialize file transfer scheme.");
            return false;
        }
        Vector<ChaseFile> chasefilevec = new Vector<ChaseFile>();
        for (i = 0; i < transspecs.size(); ++i) {
            try {
                chasefilevec.addElement(ChaseFile.createChaseFile((Element)transspecs.get(i)));
                continue;
            }
            catch (NullPointerException npe) {
                logger.error("parse error in: " + this.xmlfile);
                logger.error("using default file transfer scheme.");
                return false;
            }
        }
        this.files = new ChaseFile[chasefilevec.size()];
        for (i = 0; i < chasefilevec.size(); ++i) {
            this.files[i] = (ChaseFile)chasefilevec.elementAt(i);
        }
        return true;
    }

    public int getNumFiles() {
        return this.files.length;
    }

    public String[] getColNames() {
        int i;
        String[] ret = null;
        Vector<String> tmpvec = new Vector<String>();
        int col = 0;
        if (this.files == null || this.files.length == 0) {
            return ret;
        }
        ChaseFileProperty[] props = this.files[0].getChaseFileProperties();
        for (i = 0; i < props.length; ++i) {
            if (!props[i].showOnTable()) continue;
            tmpvec.addElement(props[i].getProp().getTag());
            ++col;
        }
        ret = new String[tmpvec.size()];
        for (i = 0; i < ret.length; ++i) {
            ret[i] = (String)tmpvec.elementAt(i);
        }
        return ret;
    }

    public void createTableModel(TableModel tableModel) {
        for (int i = 0; i < this.files.length; ++i) {
            ChaseFileProperty[] props = this.files[i].getChaseFileProperties();
            int col = 0;
            for (int j2 = 0; j2 < props.length; ++j2) {
                logger.debug(props[j2]);
                TaggedString str = props[j2].getProp();
                try {
                    str.getTag();
                    str.getValue();
                }
                catch (NullPointerException npe) {
                    continue;
                }
                if (!props[j2].showOnTable()) continue;
                if (props[j2].getTableEditorScheme() == 1) {
                    tableModel.setValueAt(new Boolean(str.getValue()), i, col);
                } else {
                    tableModel.setValueAt(str.getValue(), i, col);
                }
                ++col;
            }
        }
    }

    public String getLocalDir() {
        if (this.localdir == null || this.localdir.length() == 0) {
            this.localdir = this.files[0].getFile().getParent();
        }
        return this.localdir;
    }

    public String getTargetDir() {
        if (this.targetdir == null) {
            String loc = this.getLocalDir();
            String basedir = this.hostinfo.getProperty("basedir");
            if (basedir == null || basedir.length() == 0) {
                basedir = "$HOME";
            }
            this.targetdir = basedir + "/" + new File(this.localdir).getName();
        }
        return this.targetdir;
    }

    public ChaseFile[] getFiles() {
        return this.files;
    }

    public HostInfo getHostInfo() {
        return this.hostinfo;
    }

    public void setLocalDir(String localdir) {
        this.localdir = localdir;
    }

    public void setTargetDir(String targetdir) {
        this.targetdir = targetdir;
    }

    public void setFiles(ChaseFile[] files) {
        this.files = files;
    }

    public void saveToDisk(TableModel tableModel) {
        logger.info("saving filetransfer info to file: " + this.xmlfile);
        Element root = this.doc.getRootElement();
        List filetransferschemes = root.getChildren("filetransferscheme");
        for (int i = 0; i < filetransferschemes.size(); ++i) {
            Element el = (Element)filetransferschemes.get(i);
            if (!el.getAttribute("hostname").getValue().equals(this.hostinfo.getName())) continue;
            root.removeContent(el);
            root.addContent(this.createFileTransferElement(tableModel));
        }
        try {
            FileWriter writer = new FileWriter(this.xmlfile);
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            outputter.output(this.doc, (Writer)writer);
        }
        catch (IOException ioe) {
            logger.error("failed to save file transfer scheme to disk.");
            ioe.printStackTrace();
            return;
        }
        logger.info("saved filetransferinfo.");
    }
}

