/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.common;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;
import jp.advancesoft.chase.common.ComboBoxChoices;
import jp.advancesoft.chase.common.ConstParameters;
import jp.advancesoft.chase.common.ElementDef;
import jp.advancesoft.chase.settings.PropertiesManager;
import org.apache.log4j.Logger;

public class ElementInfo
implements ComboBoxChoices {
    private Logger logger = Logger.getLogger(ElementInfo.class.getName());
    int MAX_ELEMENTS;
    int NOSUCHELEMENT;
    public int num_elements;
    public ElementDef[] edef;
    private String elementInfoFile = new String();

    public ElementInfo() {
        this.MAX_ELEMENTS = ConstParameters.MAX_ELEMENTS;
        this.NOSUCHELEMENT = ConstParameters.NOSUCHELEMENT;
        this.elementInfoFile = PropertiesManager.getGlobalProperties(3).getFileName();
        this.edef = new ElementDef[this.MAX_ELEMENTS];
        this.num_elements = this.getNumElementInfo() + 1;
        for (int i = 0; i < this.MAX_ELEMENTS; ++i) {
            this.edef[i] = new ElementDef();
        }
        this.setEdef();
    }

    private void setEdef() {
        int i = 1;
        String str = new String();
        try {
            FileReader reader = new FileReader(this.elementInfoFile);
            BufferedReader br = new BufferedReader(reader);
            while ((str = br.readLine()) != null) {
                if ((str = str.trim()).startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(str);
                this.edef[i].setSymbol(st.nextToken());
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                String string = st.nextToken();
                string = Double.toString(Double.parseDouble(string) * ConstParameters.AMU);
                char[] value = new char[10];
                for (int ic = 0; ic < 10; ++ic) {
                    value[ic] = string.charAt(ic);
                }
                this.edef[i].setMass(new String(value, 0, 10));
                ++i;
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println("failed to read elementinfo,");
            System.out.println(e);
        }
    }

    private int getNumElementInfo() {
        int i = 0;
        try {
            String str;
            FileReader reader = new FileReader(this.elementInfoFile);
            BufferedReader br = new BufferedReader(reader);
            while ((str = br.readLine()) != null) {
                if (str.startsWith("#")) continue;
                ++i;
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println("failed to read elementinfo,");
            System.out.println(e);
            return -1;
        }
        return i++;
    }

    public String getSymbolFromNumber(int iat) {
        if (iat >= this.num_elements) {
            return "";
        }
        if (iat < 1) {
            return "";
        }
        return this.edef[iat].getSymbol();
    }

    public String getMassFromNumber(int iat) {
        if (iat >= this.num_elements) {
            return "";
        }
        if (iat < 1) {
            return "";
        }
        return this.edef[iat].getMass();
    }

    public String getMassFromSymbol(String symbol) {
        int i;
        int iret = 0;
        for (i = 1; i < this.num_elements && (iret = this.edef[i].getSymbol().compareToIgnoreCase(symbol)) != 0; ++i) {
        }
        if (iret != 0) {
            return "";
        }
        return this.edef[i].getMass();
    }

    public int getNumberFromSymbol(String symbol) {
        int i;
        int iret = 0;
        for (i = 1; i < this.num_elements && (iret = this.edef[i].getSymbol().compareToIgnoreCase(symbol)) != 0; ++i) {
        }
        if (iret != 0) {
            return -1;
        }
        return i;
    }

    public Object[] getChoices() {
        Object[] ret = new String[this.num_elements];
        ret[0] = "";
        for (int i = 1; i < this.num_elements; ++i) {
            ret[i] = this.getSymbolFromNumber(i);
        }
        return ret;
    }

    public Object[] getChoices(int index) {
        if (index == 0) {
            return this.getChoices();
        }
        if (index == 1) {
            Object[] ret = new String[this.num_elements];
            for (int i = 0; i < this.num_elements; ++i) {
                ret[i] = String.valueOf(i + 1);
            }
            return ret;
        }
        if (index == 2) {
            Object[] ret = new String[this.num_elements];
            ret[0] = "";
            for (int i = 1; i < this.num_elements; ++i) {
                ret[i] = this.getMassFromNumber(i);
            }
            return ret;
        }
        this.logger.error("wrong specification of index!");
        return null;
    }

    public Object[] getChoices(String index) {
        if (index.trim().equals("element")) {
            return this.getChoices();
        }
        if (index.trim().equals("atomic_number")) {
            Object[] ret = new String[this.num_elements];
            for (int i = 0; i < this.num_elements; ++i) {
                ret[i] = String.valueOf(i + 1);
            }
            return ret;
        }
        if (index.trim().equals("mass")) {
            Object[] ret = new String[this.num_elements];
            for (int i = 0; i < this.num_elements; ++i) {
                ret[i] = this.getMassFromNumber(i);
            }
            return ret;
        }
        this.logger.error("wrong specification of index!");
        return null;
    }

    public String getToolTipTexts(int index) {
        return "";
    }
}

