/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.atomcoord;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import jp.advancesoft.chase.atomcoord.Atom;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.atomcoord.Cell;
import jp.advancesoft.chase.common.ElementInfo;
import org.apache.log4j.Logger;

public class Cube2AtomCoords {
    private Logger logger = Logger.getLogger(Cube2AtomCoords.class.getName());
    private String fileName;
    private AtomCoords coords;
    private boolean atomParseEnd = false;
    private Vector densityVector = new Vector();
    private float[] chargeDensity;
    private int lineCount;
    private int numAt;
    private int[] nCell = new int[3];
    private float[][] deltaCell = new float[3][3];
    private float[] numValenceElectrons;
    private float[][] atomPos;
    private String[] elementName;
    private float[] origin = new float[3];

    public Cube2AtomCoords(String fileName) {
        this.fileName = fileName;
    }

    public AtomCoords getAtomCoords() {
        if (this.coords == null) {
            this.coords = new AtomCoords();
            this.coords.isCart(true);
            this.coords.setUnit(1);
        }
        try {
            String line;
            FileReader freader = new FileReader(this.fileName);
            BufferedReader breader = new BufferedReader(freader);
            while ((line = breader.readLine()) != null) {
                if (this.atomParseEnd) {
                    String[] density = line.trim().split("\\s+");
                    if (density != null) {
                        for (int i = 0; i < density.length; ++i) {
                            this.densityVector.addElement(density[i]);
                        }
                    }
                } else {
                    this.parseLine(line.trim());
                }
                ++this.lineCount;
            }
        }
        catch (IOException ioe) {
            this.logger.error("error in parsing file: " + this.fileName);
            ioe.printStackTrace();
            return null;
        }
        this.createAtomCoords();
        return this.coords;
    }

    private void createChargeDensityArray() {
        if (this.densityVector.size() == 0) {
            this.logger.warn("no charge info found.");
        } else {
            this.logger.debug("number of 'density points': " + this.densityVector.size());
            this.chargeDensity = new float[this.densityVector.size()];
            try {
                for (int i = 0; i < this.densityVector.size(); ++i) {
                    this.chargeDensity[i] = Float.parseFloat(((String)this.densityVector.elementAt(i)).replace('D', 'E'));
                }
            }
            catch (NumberFormatException exc) {
                this.logger.error("found non-float value for charge density.");
            }
        }
    }

    private void createAtomCoords() {
        String[][] strcell = new String[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                strcell[i][j] = String.valueOf(this.deltaCell[i][j] * (float)this.nCell[i]);
            }
        }
        Cell cell = new Cell(strcell[0], strcell[1], strcell[2]);
        this.coords.setCell(cell);
        for (int i = 0; i < this.numAt; ++i) {
            double[] tmp = new double[3];
            for (int j = 0; j < 3; ++j) {
                tmp[j] = this.atomPos[i][j];
            }
            Atom atom = new Atom(this.elementName[i], tmp);
            this.coords.getAtomList().addAtom(atom);
        }
        this.coords.convert(6, 8);
        this.createChargeDensityArray();
        this.coords.setChargeDensity(this.chargeDensity, this.nCell, this.deltaCell, this.origin);
    }

    private void allocateArrays() {
        this.numValenceElectrons = new float[this.numAt];
        this.atomPos = new float[this.numAt][3];
        this.elementName = new String[this.numAt];
    }

    private void parseLine(String line) throws IOException {
        if (this.lineCount <= 1) {
            return;
        }
        String[] arline = line.split("\\s+");
        if (arline == null || arline.length == 0) {
            throw new IOException();
        }
        if (this.lineCount == 2) {
            if (!this.parseFirstRow(arline)) {
                throw new IOException();
            }
            return;
        }
        if (this.lineCount >= 3 && this.lineCount <= 5) {
            if (!this.parseCell(arline)) {
                throw new IOException();
            }
            return;
        }
        if (this.lineCount >= 6 && this.lineCount < 6 + this.numAt) {
            if (!this.parseAtoms(arline)) {
                throw new IOException();
            }
            if (this.lineCount == this.numAt + 5) {
                this.atomParseEnd = true;
            }
            return;
        }
    }

    private boolean parseAtoms(String[] arline) {
        if (arline.length < 5) {
            return false;
        }
        int atnum = 0;
        try {
            atnum = Integer.parseInt(arline[0]);
            this.numValenceElectrons[this.lineCount - 6] = Float.parseFloat(arline[1]);
            for (int i = 0; i < 3; ++i) {
                this.atomPos[this.lineCount - 6][i] = Float.parseFloat(arline[i + 2]);
            }
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return false;
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            aiobe.printStackTrace();
            return false;
        }
        ElementInfo ei = new ElementInfo();
        this.elementName[this.lineCount - 6] = ei.getSymbolFromNumber(atnum);
        return true;
    }

    private boolean parseFirstRow(String[] arline) {
        if (arline.length < 4) {
            return false;
        }
        String num = arline[0];
        try {
            this.numAt = Integer.parseInt(num);
        }
        catch (NumberFormatException nfe) {
            this.logger.error("invalid numAt.");
            return false;
        }
        this.allocateArrays();
        try {
            this.origin[0] = Float.parseFloat(arline[0]);
            this.origin[1] = Float.parseFloat(arline[1]);
            this.origin[2] = Float.parseFloat(arline[2]);
        }
        catch (NumberFormatException nfe) {
            this.logger.error("invalid origin.");
            return false;
        }
        return true;
    }

    private boolean parseCell(String[] arline) {
        if (arline.length < 4) {
            return false;
        }
        try {
            this.nCell[this.lineCount - 3] = Integer.parseInt(arline[0]);
            for (int i = 0; i < 3; ++i) {
                this.deltaCell[this.lineCount - 3][i] = Float.parseFloat(arline[i + 1]);
            }
        }
        catch (NumberFormatException npe) {
            npe.printStackTrace();
            return false;
        }
        catch (ArrayIndexOutOfBoundsException aiob) {
            aiob.printStackTrace();
            return false;
        }
        return true;
    }
}

