/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.mainpanel;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.util.Vector;
import jp.advancesoft.chase.mainpanel.Chase;
import jp.advancesoft.chase.mainpanel.ChaseDesktop;
import jp.advancesoft.chase.mainpanel.FrameChase;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;
import org.apache.log4j.Logger;

public class Desktop4Frame
implements ChaseDesktop {
    private static Logger logger = Logger.getLogger(Desktop4Frame.class.getName());
    private static Desktop4Frame desktop;
    protected static final int screenWidth;
    protected static final int screenHeight;
    private Vector children = new Vector();
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(0);

    private Desktop4Frame() {
    }

    public static Desktop4Frame getDesktop() {
        if (desktop == null) {
            desktop = new Desktop4Frame();
        }
        return desktop;
    }

    protected void add(FrameChase child) {
        this.children.addElement(child);
    }

    public void componentShown() {
        this.update();
    }

    public void componentResized() {
        this.update();
    }

    public void componentMoved() {
        this.update();
    }

    public void componentHidden() {
        this.update();
    }

    public void initialLocation(Component frameNow) {
        this.initialLocation(frameNow, 0);
    }

    public void initialLocation(Component frameNow, int location) {
        Component activeComponent = this.getActiveComponent();
        if (activeComponent == null || activeComponent == frameNow) {
            logger.debug("activeComponent == null");
            frameNow.setLocation(0, 0);
            return;
        }
        if (location == 0) {
            String initial_position = this.gp.getProperty("initial_position");
            boolean tile = false;
            if (initial_position != null && initial_position.trim().equals("tile")) {
                tile = true;
            }
            this.locationAuto(activeComponent, frameNow, screenWidth, screenHeight, tile);
        } else if (location == 1) {
            Desktop4Frame.locationCenter(activeComponent, frameNow);
        }
    }

    protected void locationAuto(Component activeComponent, Component currComponent, int widthThis, int heightThis, boolean tile) {
        float d;
        int hidari = activeComponent.getLocation().x;
        int migi = hidari + activeComponent.getSize().width;
        int ue = activeComponent.getLocation().y;
        int sita = ue + activeComponent.getSize().height;
        if (!tile) {
            int overlap_x = 20;
            int overlap_y = 20;
            String ox = this.gp.getProperty("overlap_x");
            String oy = this.gp.getProperty("overlap_y");
            if (ox != null) {
                try {
                    overlap_x = Integer.parseInt(ox);
                }
                catch (NumberFormatException nfe) {
                    overlap_x = 20;
                }
            }
            Point point = activeComponent.getLocation();
            Point newpoint = new Point(point.x + overlap_x, point.y + overlap_y);
            currComponent.setLocation(newpoint);
            return;
        }
        logger.debug("hidari, migi, ue, sita: " + hidari + " " + migi + " " + ue + " " + sita);
        float a2 = (float)hidari / (float)widthThis;
        float b2 = (float)ue / (float)heightThis;
        float c2 = (float)(widthThis - migi) / (float)widthThis;
        if (c2 < 0.0f) {
            c2 = 0.0f;
        }
        if ((d = (float)(heightThis - sita) / (float)heightThis) < 0.0f) {
            d = 0.0f;
        }
        float comp = 0.0f;
        int index = 1;
        if (a2 > comp) {
            comp = a2;
            index = 1;
        }
        if (b2 > comp) {
            comp = b2;
            index = 2;
        }
        if (c2 > comp) {
            comp = c2;
            index = 3;
        }
        if (d > comp) {
            comp = d;
            index = 4;
        }
        logger.debug("a,b,c,d,index: " + index + " " + a2 + " " + b2 + " " + c2 + " " + d);
        int locx = 0;
        int locy = 0;
        if (index == 1) {
            locx = hidari - currComponent.getSize().width;
            locy = ue;
        } else if (index == 2) {
            locx = hidari;
            locy = ue - currComponent.getSize().height;
        } else if (index == 3) {
            locx = migi;
            locy = ue;
        } else if (index == 4) {
            locx = hidari;
            locy = sita;
        }
        currComponent.setLocation(locx, locy);
    }

    protected static void locationCenter(Component activeComponent, Component currComponent) {
        int centerx = activeComponent.getLocation().x + activeComponent.getWidth() / 2;
        int centery = activeComponent.getLocation().y + activeComponent.getHeight() / 2;
        int locx = centerx - currComponent.getWidth() / 2;
        int locy = centery - currComponent.getHeight() / 2;
        currComponent.setLocation(locx, locy);
    }

    private Component getActiveComponent() {
        if (this.children.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (!((Window)this.children.get(i)).isActive()) continue;
            return (Component)this.children.get(i);
        }
        return null;
    }

    private void update() {
        logger.debug("invoking update method");
    }

    static {
        screenWidth = Chase.getScreenWidth();
        screenHeight = Chase.getScreenHeight();
    }
}

